/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.contact.action.InsertRequest;
import com.openexchange.ajax.contact.action.InsertResponse;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import java.util.Date;

public class Bug19543Test_DeletingContactsInDistributionList
extends AbstractManagedContactTest {
    private static final int MAX_ATTEMPTS = 5;

    public Bug19543Test_DeletingContactsInDistributionList(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.manager.setSleep(0);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.manager.setSleep(500);
    }

    public void testWithExternalContacts() throws Exception {
        int type = 0;
        DistributionListEntryObject[] members = new DistributionListEntryObject[]{new DistributionListEntryObject("Displayname 1", "user1@oxample.invalid", type), new DistributionListEntryObject("Displayname 2", "user2@oxample.invalid", type), new DistributionListEntryObject("Displayname 3", "user3@oxample.invalid", type), new DistributionListEntryObject("Displayname 4", "user4@oxample.invalid", type)};
        this.runTests(members);
    }

    public void testWithInternalContacts() throws Exception {
        String email1 = "abel@oxample.invalid";
        Contact c1 = this.generateContact("Abel");
        c1.setEmail1(email1);
        this.manager.newAction(c1);
        String email2 = "baker@oxample.invalid";
        Contact c2 = this.generateContact("Baker");
        c2.setEmail1(email2);
        this.manager.newAction(c2);
        int type = 1;
        DistributionListEntryObject entry1 = new DistributionListEntryObject("Displayname 1", "abel@oxample.invalid", type);
        entry1.setEntryID(c1.getObjectID());
        entry1.setFolderID(this.folderID);
        DistributionListEntryObject entry2 = new DistributionListEntryObject("Displayname 2", "baker2@oxample.invalid", type);
        entry2.setEntryID(c2.getObjectID());
        entry2.setFolderID(this.folderID);
        DistributionListEntryObject[] members = new DistributionListEntryObject[]{entry1, entry2};
        this.runTests(members);
    }

    public void runTests(DistributionListEntryObject[] members) throws Exception {
        int sleep = 0;
        int expectedSize = members.length;
        Contact distributionList = this.makeDistro(-1);
        InsertResponse insertResponse = this.getClient().execute(new InsertRequest(distributionList), sleep);
        int objId = insertResponse.getId();
        Date timeStamp = insertResponse.getTimestamp();
        int listErrors = 0;
        int allErrors = 0;
        int updatesErrors = 0;
        int getFullErrors = 0;
        int getEmptyErrors = 0;
        for (int attempts = 0; attempts < 5; ++attempts) {
            Contact addMemberUpdate = this.makeDistro(objId);
            addMemberUpdate.setDistributionList(members);
            addMemberUpdate.setLastModified(timeStamp);
            this.manager.updateAction(addMemberUpdate);
            timeStamp = this.manager.getLastResponse().getTimestamp();
            Date updatesTimeStamp = new Date(timeStamp.getTime() - 1L);
            int actualSize = this.manager.listAction(new int[][]{{this.folderID, objId}})[0].getNumberOfDistributionLists();
            Bug19543Test_DeletingContactsInDistributionList.assertEquals((String)("[list] Attempt #" + attempts + " failed"), (int)expectedSize, (int)actualSize);
            actualSize = this.manager.allAction(this.folderID, Contact.ALL_COLUMNS)[0].getNumberOfDistributionLists();
            Bug19543Test_DeletingContactsInDistributionList.assertEquals((String)("[all] Attempt #" + attempts + " failed"), (int)expectedSize, (int)actualSize);
            actualSize = this.manager.updatesAction(this.folderID, updatesTimeStamp)[0].getNumberOfDistributionLists();
            Bug19543Test_DeletingContactsInDistributionList.assertEquals((String)("[updates] Attempt #" + attempts + " failed"), (int)expectedSize, (int)actualSize);
            Contact actual = this.manager.getAction(this.folderID, objId);
            actualSize = actual.getNumberOfDistributionLists();
            Bug19543Test_DeletingContactsInDistributionList.assertEquals((String)("[get] Attempt #" + attempts + " failed"), (int)expectedSize, (int)actualSize);
            Contact removeMemberUpdate = this.makeDistro(objId);
            removeMemberUpdate.setDistributionList(new DistributionListEntryObject[0]);
            removeMemberUpdate.setLastModified(timeStamp);
            this.manager.updateAction(removeMemberUpdate);
            timeStamp = this.manager.getLastResponse().getTimestamp();
            actual = this.manager.getAction(this.folderID, objId);
            Bug19543Test_DeletingContactsInDistributionList.assertEquals((String)("[get] Attempt #" + attempts + " failed"), (int)0, (int)actual.getNumberOfDistributionLists());
        }
        if (allErrors + updatesErrors + listErrors + getEmptyErrors + getFullErrors > 0) {
            Bug19543Test_DeletingContactsInDistributionList.fail((String)("Errors during the following requests :\nall: " + allErrors + ", updates: " + updatesErrors + ", list: " + listErrors + ", get (before deletion): " + getFullErrors + ", get (after deletion): " + getEmptyErrors + ", during " + 5 + " attempts"));
        }
    }

    protected Contact makeDistro(int objectId) {
        Contact distro = new Contact();
        distro.setDisplayName("Distribution list for Bug 19543");
        distro.setSurName("Distribution list for Bug 19543");
        distro.setDistributionList(new DistributionListEntryObject[0]);
        distro.setLabel(0);
        distro.setParentFolderID(this.folderID);
        if (objectId != -1) {
            distro.setObjectID(objectId);
        }
        return distro;
    }
}

