/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.helper.AbstractPositiveAssertion;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Changes;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.container.Expectations;
import com.openexchange.test.CalendarTestManager;

public class PositiveAssertionOnChangeException
extends AbstractPositiveAssertion {
    private Appointment series;
    private Appointment changeException;

    public Appointment getSeries() {
        return this.series;
    }

    public void setSeries(Appointment series) {
        this.series = series;
    }

    public Appointment getChangeException() {
        return this.changeException;
    }

    public void setChangeException(Appointment exception) {
        this.changeException = exception;
    }

    public PositiveAssertionOnChangeException(CalendarTestManager manager, int folder) {
        super(manager, folder);
    }

    @Override
    public void check(Appointment startAppointment, Changes changes, Expectations expectations) throws OXException {
        this.approachUsedForTest = "Create change exception";
        Appointment copy = startAppointment.clone();
        if (!startAppointment.containsObjectID()) {
            this.manager.insert(copy);
        }
        Appointment update = new Appointment();
        update.setLastModified(copy.getLastModified());
        update.setParentFolderID(copy.getParentFolderID());
        update.setObjectID(copy.getObjectID());
        changes.update((CommonObject)update);
        this.manager.update(update);
        this.checkViaGet(update.getParentFolderID(), update.getObjectID(), expectations);
        this.checkViaList(update.getParentFolderID(), update.getObjectID(), expectations);
        this.setChangeException(this.manager.get(update));
        this.setSeries(this.manager.get(copy));
    }
}

