/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.LoginTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractUploadParser;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.test.AjaxInit;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

@Deprecated
public abstract class AbstractAJAXTest
extends TestCase {
    public static final String PROTOCOL = "http://";
    private static final String HOSTNAME = "hostname";
    protected static final String jsonTagData = "data";
    protected static final String jsonTagTimestamp = "timestamp";
    protected static final String jsonTagError = "error";
    private static final Map<String, String> testArgsMap = new HashMap<String, String>();
    private String hostName = null;
    private WebConversation webConversation = null;
    private WebConversation webConversation2 = null;
    private String sessionId = null;
    private String sessionId2 = null;
    private String login = null;
    private String seconduser = null;
    private String password = null;
    private Properties ajaxProps = null;
    protected static final int APPEND_MODIFIED = 1000000;

    public AbstractAJAXTest(String name) {
        super(name);
        try {
            AJAXConfig.init();
        }
        catch (OXException ex) {
            ex.printStackTrace();
        }
    }

    protected void tearDown() throws Exception {
        this.logout();
        super.tearDown();
    }

    protected String getAJAXProperty(String key) {
        return this.getAJAXProperties().getProperty(key);
    }

    protected Properties getAJAXProperties() {
        if (null == this.ajaxProps) {
            this.ajaxProps = AjaxInit.getAJAXProperties();
        }
        return this.ajaxProps;
    }

    public String getHostName() {
        if (null == this.hostName) {
            this.hostName = this.getAJAXProperty(HOSTNAME);
        }
        return this.hostName;
    }

    protected WebConversation getWebConversation() {
        if (null == this.webConversation) {
            this.webConversation = this.newWebConversation();
        }
        return this.webConversation;
    }

    protected WebConversation getSecondWebConversation() {
        if (null == this.webConversation2) {
            this.webConversation2 = this.newWebConversation();
        }
        return this.webConversation2;
    }

    protected WebConversation newWebConversation() {
        HttpUnitOptions.setDefaultCharacterSet((String)"UTF-8");
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        WebConversation conv = new WebConversation();
        conv.setUserAgent("HTTP API Testing Agent");
        return conv;
    }

    protected String getSessionId() throws IOException, JSONException, OXException {
        if (null == this.sessionId) {
            this.sessionId = LoginTest.getSessionId(this.getWebConversation(), this.getHostName(), this.getLogin(), this.getPassword());
            AbstractAJAXTest.assertNotNull((String)"Can't get session id.", (Object)this.sessionId);
        }
        return this.sessionId;
    }

    protected String getSecondSessionId() throws Exception {
        if (null == this.sessionId2) {
            this.sessionId2 = LoginTest.getSessionId(this.getSecondWebConversation(), this.getHostName(), this.getSeconduser(), this.getPassword());
            AbstractAJAXTest.assertNotNull((String)"Can't get session id for second user.", (Object)this.sessionId2);
        }
        return this.sessionId2;
    }

    protected void logout() throws Exception {
        if (null != this.sessionId) {
            LoginTest.logout(this.getWebConversation(), this.getHostName(), this.getSessionId());
            this.sessionId = null;
            this.webConversation = null;
        }
        this.webConversation = null;
        if (null != this.sessionId2) {
            LoginTest.logout(this.getSecondWebConversation(), this.getHostName(), this.getSecondSessionId());
            this.sessionId2 = null;
        }
        this.webConversation2 = null;
    }

    public String getLogin() {
        if (null == this.login) {
            this.login = this.getAJAXProperty("login");
        }
        if (!this.login.contains("@")) {
            this.login = this.login + "@" + this.getAJAXProperty("contextName");
        }
        return this.login;
    }

    public String getPassword() {
        if (null == this.password) {
            this.password = this.getAJAXProperty("password");
        }
        return this.password;
    }

    public String getSeconduser() {
        if (null == this.seconduser) {
            this.seconduser = this.getAJAXProperty("seconduser");
        }
        if (!this.seconduser.contains("@")) {
            this.seconduser = this.seconduser + "@" + this.getAJAXProperty("contextName");
        }
        return this.seconduser;
    }

    protected String putS(WebConversation webConv, String url, String body) throws MalformedURLException, IOException, SAXException {
        PutMethodWebRequest m = new PutMethodWebRequest(url, (InputStream)new ByteArrayInputStream(body.getBytes(Charsets.UTF_8)), "text/javascript; charset=UTF-8");
        WebResponse resp = webConv.getResponse((WebRequest)m);
        String text = resp.getText();
        return text;
    }

    protected JSONObject put(WebConversation webConv, String url, String body) throws MalformedURLException, JSONException, IOException, SAXException {
        JSONObject o = new JSONObject(this.putS(webConv, url, body));
        return o;
    }

    protected void putN(WebConversation webConv, String url, String body) throws MalformedURLException, IOException, SAXException {
        this.putS(webConv, url, body);
    }

    protected JSONArray putA(WebConversation webConv, String url, String body) throws MalformedURLException, JSONException, IOException, SAXException {
        JSONArray a = new JSONArray(this.putS(webConv, url, body));
        return a;
    }

    protected String gS(WebConversation webConv, String url) throws MalformedURLException, IOException, SAXException {
        GetMethodWebRequest m = new GetMethodWebRequest(url);
        WebResponse resp = webConv.getResponse((WebRequest)m);
        return resp.getText();
    }

    protected JSONObject g(WebConversation webConv, String url) throws MalformedURLException, JSONException, IOException, SAXException {
        JSONObject o = new JSONObject(this.gS(webConv, url));
        return o;
    }

    protected JSONArray gA(WebConversation webConv, String url) throws MalformedURLException, JSONException, IOException, SAXException {
        JSONArray a = new JSONArray(this.gS(webConv, url));
        return a;
    }

    protected String pS(WebConversation webConv, String url, Map<String, String> data) throws MalformedURLException, IOException, SAXException {
        PostMethodWebRequest m = new PostMethodWebRequest(url);
        for (String key : data.keySet()) {
            m.setParameter(key, data.get(key));
        }
        WebResponse resp = webConv.getResponse((WebRequest)m);
        return resp.getText();
    }

    protected JSONObject p(WebConversation webConv, String url, Map<String, String> data) throws MalformedURLException, JSONException, IOException, SAXException {
        JSONObject o = new JSONObject(this.pS(webConv, url, data));
        return o;
    }

    protected JSONArray pA(WebConversation webConv, String url, Map<String, String> data) throws MalformedURLException, JSONException, IOException, SAXException {
        return new JSONArray(this.pS(webConv, url, data));
    }

    protected Response gT(WebConversation webConv, String url) throws MalformedURLException, JSONException, IOException, SAXException {
        String res = this.gS(webConv, url);
        if ("".equals(res.trim())) {
            return null;
        }
        return Response.parse((String)res);
    }

    protected Response pT(WebConversation webConv, String url, Map<String, String> data) throws MalformedURLException, JSONException, IOException, SAXException {
        String res = this.pS(webConv, url, data);
        if ("".equals(res.trim())) {
            return null;
        }
        return Response.parse((String)res);
    }

    protected Response putT(WebConversation webConv, String url, String data) throws MalformedURLException, JSONException, IOException, SAXException {
        String res = this.putS(webConv, url, data);
        if ("".equals(res.trim())) {
            return null;
        }
        return Response.parse((String)res);
    }

    public static void assertNoError(Response res) {
        AbstractAJAXTest.assertFalse((String)res.getErrorMessage(), (boolean)res.hasError());
    }

    public static JSONObject extractFromCallback(String html) throws JSONException {
        return new JSONObject(AbstractUploadParser.extractFromCallback(html));
    }

    protected Map<String, String> m(String ... pairs) {
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException("Must contain matching pairs");
        }
        HashMap<String, String> m = new HashMap<String, String>();
        for (int i = 0; i < pairs.length; ++i) {
            m.put(pairs[i], pairs[++i]);
        }
        return m;
    }

    public static String appendPrefix(String host) {
        if (host.startsWith(PROTOCOL) || host.startsWith("https://")) {
            return host;
        }
        return PROTOCOL + host;
    }

    public static final boolean containsTestArg(String arg) {
        return testArgsMap.containsKey(arg);
    }

    public static final String getTestArg(String arg) {
        return testArgsMap.get(arg);
    }

    public static final void putTestArg(String arg, String value) {
        testArgsMap.put(arg, value);
    }
}

