/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.internal;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;

public final class BoundedExecutor {
    private final Executor executor;
    private final Semaphore semaphore;

    public BoundedExecutor(Executor exec, int bound) {
        this.executor = exec;
        this.semaphore = new Semaphore(bound);
    }

    public void submitTask(final Runnable command) throws InterruptedException {
        if (null == command) {
            return;
        }
        final Semaphore semaphore = this.semaphore;
        semaphore.acquire();
        try {
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        command.run();
                    }
                    finally {
                        semaphore.release();
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            semaphore.release();
            throw e;
        }
    }
}

