/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.smtp.SMTPProvider;

public enum SMTPExceptionCode implements OXExceptionCode
{
    IO_ERROR(MailExceptionCode.IO_ERROR),
    ENCODING_ERROR(MailExceptionCode.ENCODING_ERROR),
    PART_NOT_FOUND("The message part with sequence ID %1$s could not be found in message %2$s in folder %3$s", CATEGORY_ERROR, 3003),
    HTML2TEXT_CONVERTER_ERROR("Html-2-Text conversion failed: %1$s", CATEGORY_ERROR, 3004),
    INTERNAL_ERROR("An internal error occurred: %1$s", CATEGORY_ERROR, 3005),
    MISSING_RECIPIENTS("There are no recipient(s) for the new message.", CATEGORY_USER_INPUT, 3006),
    COPY_TO_SENT_FOLDER_FAILED(MailExceptionCode.COPY_TO_SENT_FOLDER_FAILED),
    MISSING_NOTIFICATION_HEADER("Receipt acknowledgment cannot be sent: missing header %1$s in message %2$s", CATEGORY_ERROR, 3008),
    NO_SEND_ADDRESS_FOUND("No send address could be found in user configuration", CATEGORY_ERROR, 3009),
    NO_CONTENT("No content available in mail part", CATEGORY_ERROR, 3010),
    COPY_TO_SENT_FOLDER_FAILED_QUOTA(MailExceptionCode.COPY_TO_SENT_FOLDER_FAILED_QUOTA),
    NOT_CONNECTED("No storage access because mail connection is not connected", CATEGORY_ERROR, 3012),
    URI_PARSE_FAILED("Unable to parse SMTP server URI \"%1$s\".", CATEGORY_CONFIGURATION, 3013),
    RECIPIENT_NOT_ALLOWED("The following recipient is not allowed: %1$s. Please remove associated address and try again.", CATEGORY_USER_INPUT, 3014),
    SECURE_CONNECTION_NOT_POSSIBLE("The SMTP server %1$s cannot be accessed using a secure SSL connection for user %2$s. Please change configuration accordingly.", CATEGORY_USER_INPUT, 3015);

    private final String message;
    private final int detailNumber;
    private final Category category;
    private final String prefix;

    private SMTPExceptionCode(String message, Category category, int detailNumber) {
        this.message = message;
        this.detailNumber = detailNumber;
        this.category = category;
        this.prefix = SMTPProvider.PROTOCOL_SMTP.getName();
    }

    private SMTPExceptionCode(MailExceptionCode code) {
        this.message = code.getMessage();
        this.detailNumber = code.getNumber();
        this.category = code.getCategory();
        this.prefix = code.getPrefix();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

