/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.memory;

import com.openexchange.tools.oxfolder.OXFolderProperties;
import com.openexchange.tools.oxfolder.memory.Condition;
import com.openexchange.tools.oxfolder.memory.Permission;
import gnu.trove.TIntCollection;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.LinkedList;
import java.util.List;

public final class ConditionTree {
    private static final int SYSTEM_GLOBAL_FOLDER_ID = 5;
    static final Condition CONDITION_ADMIN = new Condition(){

        @Override
        public boolean fulfilled(Permission p) {
            return p.admin;
        }
    };
    static final Condition CONDITION_READ_FOLDER = new Condition(){

        @Override
        public boolean fulfilled(Permission p) {
            return p.readFolder;
        }
    };
    private static final Condition CONDITION_FOLDER_VISIBLE = new Condition(){

        @Override
        public boolean fulfilled(Permission p) {
            return CONDITION_ADMIN.fulfilled(p) || CONDITION_READ_FOLDER.fulfilled(p);
        }
    };
    private final TIntSet folderIds = new TIntHashSet();
    private final List<Permission> permissions = new LinkedList<Permission>();
    private final boolean ignoreSharedAddressbook = OXFolderProperties.isIgnoreSharedAddressbook();
    private final long stamp = System.currentTimeMillis();

    public boolean isElapsed(long stamp) {
        return this.stamp < stamp;
    }

    public void insert(Permission p) {
        if (this.ignoreSharedAddressbook && 5 == p.fuid) {
            return;
        }
        if (CONDITION_FOLDER_VISIBLE.fulfilled(p)) {
            this.folderIds.add(p.fuid);
            this.permissions.add(p);
        }
    }

    public TIntSet getVisibleFolderIds() {
        return this.folderIds;
    }

    public TIntSet getVisibleFolderIds(Condition condition) {
        if (null == condition) {
            return new TIntHashSet((TIntCollection)this.folderIds);
        }
        TIntHashSet retval = new TIntHashSet((TIntCollection)this.folderIds);
        for (Permission p : this.permissions) {
            if (condition.fulfilled(p)) continue;
            retval.remove(p.fuid);
        }
        return retval;
    }
}

