/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.osgi;

import com.openexchange.server.osgi.ModuleSpecificServiceTracker;
import com.openexchange.tools.service.ServicePriorityConflictException;
import com.openexchange.tools.service.SpecificServiceChooser;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AttachmentPluginsTracker<T>
extends ModuleSpecificServiceTracker<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AttachmentPluginsTracker.class);

    public AttachmentPluginsTracker(BundleContext context, Class<T> toTrack) {
        super(context, toTrack);
    }

    @Override
    public void removedService(int module, T tracked, ServiceReference reference) {
        Integer contextId = this.getInt(reference, "override_context");
        Integer folderId = this.getInt(reference, "override_folder");
        SpecificServiceChooser<T> chooser = this.getChooser(module);
        if (chooser == null) {
            LOG.warn("Can't register services for module {} in tracker {}", (Object)module, (Object)((Object)((Object)this)).getClass().getName());
        }
        if (contextId == null && folderId == null) {
            chooser.removeForEverything(tracked);
            return;
        }
        if (contextId != null && folderId != null) {
            chooser.removeForContextAndFolder(tracked, (int)contextId, folderId);
            return;
        }
        if (contextId != null) {
            chooser.removeForContext(tracked, contextId);
            return;
        }
        if (folderId != null) {
            chooser.removeForFolder(tracked, folderId);
        }
    }

    @Override
    public void addingService(int module, T tracked, ServiceReference reference) {
        SpecificServiceChooser<T> chooser;
        Integer contextId = this.getInt(reference, "override_context");
        Integer folderId = this.getInt(reference, "override_folder");
        Integer ranking = this.getInt(reference, "service.ranking");
        if (ranking == null) {
            ranking = 0;
        }
        if ((chooser = this.getChooser(module)) == null) {
            LOG.error("Can't register services for module {} in tracker {}", (Object)module, (Object)((Object)((Object)this)).getClass().getName());
            return;
        }
        try {
            if (contextId == null && folderId == null) {
                chooser.registerForEverything(tracked, ranking);
                return;
            }
            if (contextId != null && folderId != null) {
                chooser.registerForContextAndFolder(tracked, (int)ranking, (int)contextId, folderId);
                return;
            }
            if (contextId != null) {
                chooser.registerForContext(tracked, ranking, contextId);
                return;
            }
            if (folderId != null) {
                chooser.registerForFolder(tracked, (int)ranking, folderId);
            }
        }
        catch (ServicePriorityConflictException x) {
            LOG.error("Could not register service {} with contextId: {} for folder: {} with ranking: {}. A conflicting service has already been registered for the combination", new Object[]{tracked, contextId, folderId, ranking});
        }
    }

    @Override
    public void modifiedService(int module, T tracked, ServiceReference reference) {
    }

    public abstract SpecificServiceChooser<T> getChooser(int var1);

    protected Integer getInt(ServiceReference reference, String key) {
        Object property = reference.getProperty(key);
        if (property == null) {
            return null;
        }
        if (Integer.class.isInstance(property)) {
            return (Integer)property;
        }
        return Integer.parseInt(property.toString());
    }
}

