/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.multiple;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.multiple.MultipleHandler;
import com.openexchange.multiple.MultipleHandlerFactoryService;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class AJAXActionServiceAdapterHandler
implements MultipleHandler,
MultipleHandlerFactoryService {
    private AJAXActionServiceFactory factory = null;
    private AJAXRequestResult result;
    private final String module;

    public AJAXActionServiceAdapterHandler(AJAXActionServiceFactory factory, String module) {
        this.factory = factory;
        this.module = module;
    }

    @Override
    public void close() {
        this.result = null;
    }

    @Override
    public Date getTimestamp() {
        if (null == this.result) {
            return null;
        }
        Date timestamp = this.result.getTimestamp();
        return null == timestamp ? null : new Date(timestamp.getTime());
    }

    @Override
    public Collection<OXException> getWarnings() {
        if (null == this.result) {
            return Collections.emptySet();
        }
        return this.result.getWarnings();
    }

    @Override
    public Object performRequest(String action, JSONObject jsonObject, ServerSession session, boolean secure) throws JSONException, OXException {
        AJAXActionService actionService = this.factory.createActionService(action);
        if (null == actionService) {
            throw AjaxExceptionCodes.UNKNOWN_ACTION.create(action);
        }
        AJAXRequestData request = new AJAXRequestData();
        request.setSecure(secure);
        request.setHostname(jsonObject.getString("__hostname"));
        request.setRoute(jsonObject.getString("__route"));
        request.setRemoteAddress(jsonObject.getString("__remoteAddress"));
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            if ("data".equals(key)) {
                request.setData(entry.getValue());
                continue;
            }
            request.putParameter(key, entry.getValue().toString());
        }
        try {
            this.result = actionService.perform(request, session);
        }
        catch (IllegalStateException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OXException) {
                throw (OXException)cause;
            }
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            request.cleanUploads();
        }
        return this.result.getResultObject();
    }

    @Override
    public MultipleHandler createMultipleHandler() {
        return this;
    }

    @Override
    public String getSupportedModule() {
        return this.module;
    }
}

