/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.parser;

import com.openexchange.ajax.parser.DataParser;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.json.fields.SetSwitch;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class MailAccountParser
extends DataParser {
    private static final Map<String, StandardPorts> PORTS;
    private static final MailAccountParser INSTANCE;

    public static MailAccountParser getInstance() {
        return INSTANCE;
    }

    private MailAccountParser() {
    }

    public Set<Attribute> parse(MailAccountDescription account, JSONObject json, Collection<OXException> warnings) throws OXException {
        return this.parse(account, json, warnings, false);
    }

    public Set<Attribute> parse(MailAccountDescription account, JSONObject json, Collection<OXException> warnings, boolean asNewAccount) throws OXException {
        try {
            return this.parseElementAccount(account, json, warnings, asNewAccount);
        }
        catch (JSONException e) {
            throw OXJSONExceptionCodes.JSON_READ_ERROR.create(e, json.toString());
        }
    }

    protected Set<Attribute> parseElementAccount(MailAccountDescription account, JSONObject json, Collection<OXException> warnings, boolean asNewAccount) throws JSONException, OXException {
        String string;
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        if (json.hasAndNotNull("id")) {
            account.setId(MailAccountParser.parseInt(json, "id"));
            attributes.add(Attribute.ID_LITERAL);
        }
        if (json.hasAndNotNull("login")) {
            account.setLogin(MailAccountParser.parseString(json, "login"));
            attributes.add(Attribute.LOGIN_LITERAL);
        }
        if (json.hasAndNotNull("password")) {
            account.setPassword(MailAccountParser.parseString(json, "password"));
            attributes.add(Attribute.PASSWORD_LITERAL);
        }
        if (json.hasAndNotNull("mail_url")) {
            boolean mailSecure;
            String mailServer;
            String mailProtocol;
            int mailPort;
            account.parseMailServerURL(MailAccountParser.parseString(json, "mail_url").trim());
            if (json.hasAndNotNull("mail_port") && (mailPort = json.optInt("mail_port", -1)) > 0 && mailPort != account.getMailPort()) {
                account.setMailPort(mailPort);
            }
            if (json.hasAndNotNull("mail_protocol") && !Strings.isEmpty((String)(mailProtocol = json.optString("mail_protocol", null))) && !mailProtocol.equals(account.getMailProtocol())) {
                account.setMailProtocol(mailProtocol);
            }
            if (json.hasAndNotNull("mail_server") && !Strings.isEmpty((String)(mailServer = json.optString("mail_server", null))) && !mailServer.equals(account.getMailServer())) {
                account.setMailServer(mailServer);
            }
            if (json.hasAndNotNull("mail_secure") && (mailSecure = json.optBoolean("mail_secure", account.isMailSecure())) != account.isMailSecure()) {
                account.setMailSecure(mailSecure);
            }
            attributes.add(Attribute.MAIL_URL_LITERAL);
            attributes.addAll(Attribute.MAIL_URL_ATTRIBUTES);
        } else {
            SetSwitch setSwitch = new SetSwitch(account);
            for (Attribute attribute : Attribute.MAIL_URL_ATTRIBUTES) {
                if (!json.has(attribute.getName())) continue;
                setSwitch.setValue(json.get(attribute.getName()));
                attribute.doSwitch(setSwitch);
                attributes.add(attribute);
            }
            if (null != account.getMailProtocol()) {
                account.setMailProtocol(account.getMailProtocol().trim());
            }
            if (null != account.getMailServer()) {
                account.setMailServer(account.getMailServer().trim());
            }
        }
        if (json.hasAndNotNull("transport_url")) {
            boolean transportSecure;
            String transportServer;
            String transportProtocol;
            int transportPort;
            account.parseTransportServerURL(MailAccountParser.parseString(json, "transport_url").trim());
            if (json.hasAndNotNull("transport_port") && (transportPort = json.optInt("transport_port", -1)) > 0 && transportPort != account.getTransportPort()) {
                account.setTransportPort(transportPort);
            }
            if (json.hasAndNotNull("transport_protocol") && !Strings.isEmpty((String)(transportProtocol = json.optString("transport_protocol", null))) && !transportProtocol.equals(account.getTransportProtocol())) {
                account.setTransportProtocol(transportProtocol);
            }
            if (json.hasAndNotNull("transport_server") && !Strings.isEmpty((String)(transportServer = json.optString("transport_server", null))) && !transportServer.equals(account.getTransportServer())) {
                account.setTransportServer(transportServer);
            }
            if (json.hasAndNotNull("transport_secure") && (transportSecure = json.optBoolean("transport_secure", account.isTransportSecure())) != account.isTransportSecure()) {
                account.setTransportSecure(transportSecure);
            }
            attributes.add(Attribute.TRANSPORT_URL_LITERAL);
            attributes.addAll(Attribute.TRANSPORT_URL_ATTRIBUTES);
        } else {
            SetSwitch setSwitch = new SetSwitch(account);
            for (Attribute attribute : Attribute.TRANSPORT_URL_ATTRIBUTES) {
                if (!json.has(attribute.getName())) continue;
                setSwitch.setValue(json.get(attribute.getName()));
                attribute.doSwitch(setSwitch);
                attributes.add(attribute);
            }
            if (null != account.getTransportProtocol()) {
                account.setTransportProtocol(account.getTransportProtocol().trim());
            }
            if (null != account.getTransportServer()) {
                account.setTransportServer(account.getTransportServer().trim());
            }
        }
        MailAccountParser.checkMailPort(account, warnings);
        MailAccountParser.checkTransportPort(account, warnings);
        if (asNewAccount) {
            this.parseTransportCredentials(account, json, attributes);
        } else {
            if (json.hasAndNotNull("transport_login")) {
                account.setTransportLogin(MailAccountParser.parseString(json, "transport_login"));
                attributes.add(Attribute.TRANSPORT_LOGIN_LITERAL);
            }
            if (json.hasAndNotNull("transport_password")) {
                account.setTransportPassword(MailAccountParser.parseString(json, "transport_password"));
                attributes.add(Attribute.TRANSPORT_PASSWORD_LITERAL);
            }
        }
        if (json.has("name")) {
            account.setName(MailAccountParser.parseString(json, "name"));
            attributes.add(Attribute.NAME_LITERAL);
        }
        if (json.has("primary_address")) {
            String string2 = MailAccountParser.parseString(json, "primary_address");
            account.setPrimaryAddress(null == string2 ? string2 : string2.trim());
            attributes.add(Attribute.PRIMARY_ADDRESS_LITERAL);
        }
        if (json.has("personal")) {
            account.setPersonal(MailAccountParser.parseString(json, "personal"));
            attributes.add(Attribute.PERSONAL_LITERAL);
        }
        HashMap<String, String> props = new HashMap<String, String>(8);
        if (json.has("reply_to")) {
            account.setReplyTo(MailAccountParser.parseString(json, "reply_to"));
            props.put("replyto", json.getString("reply_to").trim());
            attributes.add(Attribute.REPLY_TO_LITERAL);
        }
        if (json.has("spam_handler")) {
            string = MailAccountParser.parseString(json, "spam_handler");
            account.setSpamHandler(null == string ? string : string.trim());
            attributes.add(Attribute.SPAM_HANDLER_LITERAL);
        }
        if (json.has("trash")) {
            string = MailAccountParser.parseString(json, "trash");
            account.setTrash(null == string ? string : string.trim());
            attributes.add(Attribute.TRASH_LITERAL);
        }
        if (json.has("archive")) {
            string = MailAccountParser.parseString(json, "archive");
            account.setTrash(null == string ? string : string.trim());
            attributes.add(Attribute.ARCHIVE_LITERAL);
        }
        if (json.has("sent")) {
            string = MailAccountParser.parseString(json, "sent");
            account.setSent(null == string ? string : string.trim());
            attributes.add(Attribute.SENT_LITERAL);
        }
        if (json.has("drafts")) {
            string = MailAccountParser.parseString(json, "drafts");
            account.setDrafts(null == string ? string : string.trim());
            attributes.add(Attribute.DRAFTS_LITERAL);
        }
        if (json.has("spam")) {
            string = MailAccountParser.parseString(json, "spam");
            account.setSpam(null == string ? string : string.trim());
            attributes.add(Attribute.SPAM_LITERAL);
        }
        if (json.has("confirmed_spam")) {
            string = MailAccountParser.parseString(json, "confirmed_spam");
            account.setConfirmedSpam(null == string ? string : string.trim());
            attributes.add(Attribute.CONFIRMED_SPAM_LITERAL);
        }
        if (json.has("confirmed_ham")) {
            string = MailAccountParser.parseString(json, "confirmed_ham");
            account.setConfirmedHam(null == string ? string : string.trim());
            attributes.add(Attribute.CONFIRMED_HAM_LITERAL);
        }
        if (json.has("unified_inbox_enabled")) {
            account.setUnifiedINBOXEnabled(MailAccountParser.parseBoolean(json, "unified_inbox_enabled"));
            attributes.add(Attribute.UNIFIED_INBOX_ENABLED_LITERAL);
        }
        if (json.has("trash_fullname")) {
            string = MailAccountParser.parseString(json, "trash_fullname");
            account.setTrashFullname(null == string ? string : string.trim());
            attributes.add(Attribute.TRASH_FULLNAME_LITERAL);
        }
        if (json.has("archive_fullname")) {
            string = MailAccountParser.parseString(json, "archive_fullname");
            account.setTrashFullname(null == string ? string : string.trim());
            attributes.add(Attribute.ARCHIVE_FULLNAME_LITERAL);
        }
        if (json.has("sent_fullname")) {
            string = MailAccountParser.parseString(json, "sent_fullname");
            account.setSentFullname(null == string ? string : string.trim());
            attributes.add(Attribute.SENT_FULLNAME_LITERAL);
        }
        if (json.has("drafts_fullname")) {
            string = MailAccountParser.parseString(json, "drafts_fullname");
            account.setDraftsFullname(null == string ? string : string.trim());
            attributes.add(Attribute.DRAFTS_FULLNAME_LITERAL);
        }
        if (json.has("spam_fullname")) {
            string = MailAccountParser.parseString(json, "spam_fullname");
            account.setSpamFullname(null == string ? string : string.trim());
            attributes.add(Attribute.SPAM_FULLNAME_LITERAL);
        }
        if (json.has("confirmed_spam_fullname")) {
            string = MailAccountParser.parseString(json, "confirmed_spam_fullname");
            account.setConfirmedSpamFullname(null == string ? string : string.trim());
            attributes.add(Attribute.CONFIRMED_SPAM_FULLNAME_LITERAL);
        }
        if (json.has("confirmed_ham_fullname")) {
            string = MailAccountParser.parseString(json, "confirmed_ham_fullname");
            account.setConfirmedHamFullname(null == string ? string : string.trim());
            attributes.add(Attribute.CONFIRMED_HAM_FULLNAME_LITERAL);
        }
        if (json.hasAndNotNull("pop3_delete_write_through")) {
            props.put("pop3.deletewt", json.getString("pop3_delete_write_through").trim());
            attributes.add(Attribute.POP3_DELETE_WRITE_THROUGH_LITERAL);
        }
        if (json.hasAndNotNull("pop3_expunge_on_quit")) {
            props.put("pop3.expunge", json.getString("pop3_expunge_on_quit").trim());
            attributes.add(Attribute.POP3_EXPUNGE_ON_QUIT_LITERAL);
        }
        if (json.hasAndNotNull("pop3_refresh_rate")) {
            props.put("pop3.refreshrate", json.getString("pop3_refresh_rate").trim());
            attributes.add(Attribute.POP3_REFRESH_RATE_LITERAL);
        }
        if (json.hasAndNotNull("pop3_storage")) {
            props.put("pop3.storage", json.getString("pop3_storage").trim());
            attributes.add(Attribute.POP3_STORAGE_LITERAL);
        } else if ("pop3".equalsIgnoreCase(account.getMailProtocol())) {
            props.put("pop3.storage", "mailaccount");
            attributes.add(Attribute.POP3_STORAGE_LITERAL);
        }
        if (json.hasAndNotNull("pop3_path")) {
            props.put("pop3.path", json.getString("pop3_path").trim());
            attributes.add(Attribute.POP3_PATH_LITERAL);
        }
        account.setProperties(props);
        return attributes;
    }

    protected void parseTransportCredentials(MailAccountDescription account, JSONObject json, Set<Attribute> attributes) {
        boolean transportAuth = json.optBoolean("transport_auth", true);
        if (transportAuth) {
            if (MailAccountParser.seemsSet("transport_login", json)) {
                String transLogin = json.optString("transport_login", null);
                account.setTransportLogin(transLogin);
                attributes.add(Attribute.TRANSPORT_LOGIN_LITERAL);
            } else {
                account.setTransportLogin(null);
            }
            if (MailAccountParser.seemsSet("transport_password", json)) {
                String transPassw = json.optString("transport_password", null);
                account.setTransportPassword(transPassw);
                attributes.add(Attribute.TRANSPORT_PASSWORD_LITERAL);
            } else {
                account.setTransportPassword(null);
            }
        } else {
            account.setTransportLogin(null);
            attributes.add(Attribute.TRANSPORT_LOGIN_LITERAL);
            account.setTransportPassword(null);
            attributes.add(Attribute.TRANSPORT_PASSWORD_LITERAL);
        }
    }

    private static boolean seemsSet(String key, JSONObject json) {
        if (!json.hasAndNotNull(key)) {
            return false;
        }
        String str = json.optString(key, null);
        if (Strings.isEmpty((String)str)) {
            return false;
        }
        return !"null".equalsIgnoreCase(str);
    }

    private static void checkMailPort(MailAccountDescription account, Collection<OXException> warnings) {
        String mailProtocol = account.getMailProtocol();
        if (Strings.isEmpty((String)mailProtocol)) {
            return;
        }
        StandardPorts standardPorts = PORTS.get(Strings.toLowerCase((CharSequence)mailProtocol));
        if (null != standardPorts) {
            int port = account.getMailPort();
            if (account.isMailSecure()) {
                if (standardPorts.isDefaultPort(port)) {
                    warnings.add(MailAccountExceptionCodes.DEFAULT_BUT_SECURE_MAIL.create(mailProtocol));
                }
            } else if (standardPorts.isDefaultSSLPort(port)) {
                warnings.add(MailAccountExceptionCodes.SECURE_BUT_DEFAULT_MAIL.create(mailProtocol));
            }
        }
    }

    private static void checkTransportPort(MailAccountDescription account, Collection<OXException> warnings) {
        String transportProtocol = account.getTransportProtocol();
        if (Strings.isEmpty((String)transportProtocol)) {
            return;
        }
        StandardPorts standardPorts = PORTS.get(Strings.toLowerCase((CharSequence)transportProtocol));
        if (null != standardPorts) {
            int port = account.getTransportPort();
            if (account.isTransportSecure()) {
                if (standardPorts.isDefaultPort(port)) {
                    warnings.add(MailAccountExceptionCodes.DEFAULT_BUT_SECURE_TRANSPORT.create(transportProtocol));
                }
            } else if (standardPorts.isDefaultSSLPort(port)) {
                warnings.add(MailAccountExceptionCodes.SECURE_BUT_DEFAULT_TRANSPORT.create(transportProtocol));
            }
        }
    }

    private static MailAccount loadDefaultAccount(Session session) {
        if (null == session) {
            return null;
        }
        try {
            MailAccountStorageService mass = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class);
            return null == mass ? null : mass.getDefaultMailAccount(session.getUserId(), session.getContextId());
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        HashMap<String, StandardPorts> m = new HashMap<String, StandardPorts>(4);
        TIntHashSet ports = new TIntHashSet(new int[]{143});
        TIntHashSet sslPorts = new TIntHashSet(new int[]{993});
        m.put("imap", new StandardPorts((TIntSet)ports, (TIntSet)sslPorts));
        ports = new TIntHashSet(new int[]{110});
        sslPorts = new TIntHashSet(new int[]{995});
        m.put("pop3", new StandardPorts((TIntSet)ports, (TIntSet)sslPorts));
        ports = new TIntHashSet(new int[]{25});
        sslPorts = new TIntHashSet(new int[]{465});
        m.put("smtp", new StandardPorts((TIntSet)ports, (TIntSet)sslPorts));
        PORTS = Collections.unmodifiableMap(m);
        INSTANCE = new MailAccountParser();
    }

    private static final class StandardPorts {
        private final TIntSet ports;
        private final TIntSet sslPorts;

        StandardPorts(TIntSet ports, TIntSet sslPorts) {
            this.ports = ports;
            this.sslPorts = sslPorts;
        }

        boolean isDefaultPort(int port) {
            return this.ports.contains(port);
        }

        boolean isDefaultSSLPort(int port) {
            return this.sslPorts.contains(port);
        }
    }
}

