/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.delete.DeleteFailedExceptionCode;
import com.openexchange.groupware.delete.DeleteListener;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.linked.TIntLinkedList;
import gnu.trove.procedure.TIntProcedure;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;

public class MailAccountDeleteListener
implements DeleteListener {
    @Override
    public void deletePerformed(DeleteEvent deleteEvent, Connection readCon, final Connection writeCon) throws OXException {
        if (deleteEvent.getType() == 1) {
            final MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
            final int user = deleteEvent.getId();
            final int cid = deleteEvent.getContext().getContextId();
            final OXException[] cup = new OXException[1];
            TIntList ids = this.getUserMailAccountIDs(user, cid, writeCon);
            ids.forEach(new TIntProcedure(){

                public boolean execute(int accountId) {
                    try {
                        storageService.deleteMailAccount(accountId, Collections.<String, Object>emptyMap(), user, cid, true, writeCon);
                        return true;
                    }
                    catch (OXException e) {
                        cup[0] = e;
                        return false;
                    }
                    catch (RuntimeException e) {
                        cup[0] = MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
                        return false;
                    }
                }
            });
            OXException err = cup[0];
            if (null != err) {
                throw err;
            }
        }
    }

    private TIntList getUserMailAccountIDs(int user, int cid, Connection con) throws OXException {
        TIntArrayList tIntArrayList;
        ResultSet result;
        PreparedStatement stmt;
        block6: {
            stmt = null;
            result = null;
            stmt = con.prepareStatement("SELECT id FROM user_mail_account WHERE cid = ? AND user = ? ORDER BY id");
            stmt.setLong(1, cid);
            stmt.setLong(2, user);
            result = stmt.executeQuery();
            if (result.next()) break block6;
            TIntLinkedList tIntLinkedList = new TIntLinkedList();
            DBUtils.closeSQLStuff(result, stmt);
            return tIntLinkedList;
        }
        try {
            TIntArrayList ids = new TIntArrayList(8);
            do {
                ids.add(result.getInt(1));
            } while (result.next());
            tIntArrayList = ids;
        }
        catch (SQLException e) {
            try {
                throw DeleteFailedExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return tIntArrayList;
    }
}

