/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.i18n.MailStrings;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Strings;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.utils.DefaultFolderNamesProvider;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.sql.Connection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import org.slf4j.LoggerFactory;

public final class Tools {
    private static final int RADIX = 10;

    private Tools() {
    }

    public static final int getUnsignedInteger(String s) {
        int digit;
        if (s == null) {
            return -1;
        }
        int max = s.length();
        if (max <= 0) {
            return -1;
        }
        if (s.charAt(0) == '-') {
            return -1;
        }
        int result = 0;
        int i = 0;
        int limit = -2147483647;
        int multmin = -214748364;
        if (i < max) {
            if ((digit = Tools.digit(s.charAt(i++))) < 0) {
                return -1;
            }
            result = -digit;
        }
        while (i < max) {
            if ((digit = Tools.digit(s.charAt(i++))) < 0) {
                return -1;
            }
            if (result < -214748364) {
                return -1;
            }
            if ((result *= 10) < -2147483647 + digit) {
                return -1;
            }
            result -= digit;
        }
        return -result;
    }

    private static int digit(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MailAccount checkFullNames(MailAccount account, MailAccountStorageService storageService, Session session) throws OXException {
        if (0 == account.getId()) {
            return account;
        }
        int contextId = session.getContextId();
        DatabaseService databaseService = ServerServiceRegistry.getServize(DatabaseService.class);
        Connection wcon = databaseService.getWritable(contextId);
        try {
            MailAccount mailAccount = Tools.checkFullNames(account, storageService, session, wcon);
            return mailAccount;
        }
        finally {
            databaseService.backWritable(contextId, wcon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MailAccount checkFullNames(MailAccount account, MailAccountStorageService storageService, Session session, Connection con) throws OXException {
        int accountId = account.getId();
        if (0 == accountId) {
            return account;
        }
        ServerSession serverSession = ServerSessionAdapter.valueOf(session);
        MailAccountDescription mad = new MailAccountDescription();
        mad.setId(accountId);
        EnumSet<Attribute> attributes = EnumSet.noneOf(Attribute.class);
        String prefix = null;
        String mailProtocol = account.getMailProtocol();
        if (null != mailProtocol && Strings.toLowerCase((CharSequence)mailProtocol).startsWith("pop3")) {
            prefix = "";
        }
        StringBuilder tmp = null;
        MailAccount primaryAccount = null;
        Locale locale = null;
        int userId = serverSession.getUserId();
        int contextId = serverSession.getContextId();
        try {
            MailAccount[] accounts;
            String name;
            String fullName = account.getConfirmedHamFullname();
            if (null == fullName) {
                if (null == prefix) {
                    prefix = Tools.getPrefix(accountId, serverSession);
                }
                if (null == (name = account.getConfirmedHam())) {
                    locale = serverSession.getUser().getLocale();
                    primaryAccount = storageService.getDefaultMailAccount(userId, contextId);
                    name = Tools.getName(5, primaryAccount, locale, Policy.BY_LOCALE);
                    mad.setConfirmedHam(name);
                    attributes.add(Attribute.CONFIRMED_HAM_LITERAL);
                }
                tmp = new StringBuilder(prefix);
                mad.setConfirmedHamFullname(tmp.append(name).toString());
                attributes.add(Attribute.CONFIRMED_HAM_FULLNAME_LITERAL);
            }
            if (null == (fullName = account.getConfirmedSpamFullname())) {
                if (null == prefix) {
                    prefix = Tools.getPrefix(accountId, serverSession);
                    tmp = new StringBuilder(prefix);
                } else if (null == tmp) {
                    tmp = new StringBuilder(prefix);
                } else {
                    tmp.setLength(prefix.length());
                }
                name = account.getConfirmedSpam();
                if (null == name) {
                    if (null == locale) {
                        locale = serverSession.getUser().getLocale();
                    }
                    if (null == primaryAccount) {
                        primaryAccount = storageService.getDefaultMailAccount(userId, contextId);
                    }
                    name = Tools.getName(4, primaryAccount, locale, Policy.BY_LOCALE);
                    mad.setConfirmedSpam(name);
                    attributes.add(Attribute.CONFIRMED_SPAM_LITERAL);
                }
                mad.setConfirmedSpamFullname(tmp.append(name).toString());
                attributes.add(Attribute.CONFIRMED_SPAM_FULLNAME_LITERAL);
            }
            if (null == (fullName = account.getDraftsFullname())) {
                if (null == prefix) {
                    prefix = Tools.getPrefix(accountId, serverSession);
                    tmp = new StringBuilder(prefix);
                } else if (null == tmp) {
                    tmp = new StringBuilder(prefix);
                } else {
                    tmp.setLength(prefix.length());
                }
                name = account.getDrafts();
                if (null == name) {
                    if (null == locale) {
                        locale = serverSession.getUser().getLocale();
                    }
                    if (null == primaryAccount) {
                        primaryAccount = storageService.getDefaultMailAccount(userId, contextId);
                    }
                    name = Tools.getName(0, primaryAccount, locale, Policy.BY_LOCALE);
                    mad.setDrafts(name);
                    attributes.add(Attribute.DRAFTS_LITERAL);
                }
                if ("Drafts".equalsIgnoreCase(name) && account.getMailServer().endsWith("yahoo.com")) {
                    name = "Draft";
                    mad.setDrafts(name);
                    attributes.add(Attribute.DRAFTS_LITERAL);
                }
                mad.setDraftsFullname(tmp.append(name).toString());
                attributes.add(Attribute.DRAFTS_FULLNAME_LITERAL);
            }
            if (null == (fullName = account.getSentFullname())) {
                if (null == prefix) {
                    prefix = Tools.getPrefix(accountId, serverSession);
                    tmp = new StringBuilder(prefix);
                } else if (null == tmp) {
                    tmp = new StringBuilder(prefix);
                } else {
                    tmp.setLength(prefix.length());
                }
                name = account.getSent();
                if (null == name) {
                    if (null == locale) {
                        locale = serverSession.getUser().getLocale();
                    }
                    if (null == primaryAccount) {
                        primaryAccount = storageService.getDefaultMailAccount(userId, contextId);
                    }
                    name = Tools.getName(1, primaryAccount, locale, Policy.BY_LOCALE);
                    mad.setSent(name);
                    attributes.add(Attribute.SENT_LITERAL);
                }
                if ("Sent Items".equalsIgnoreCase(name) && account.getMailServer().endsWith("yahoo.com")) {
                    name = "Sent";
                    mad.setSent(name);
                    attributes.add(Attribute.SENT_LITERAL);
                }
                mad.setSentFullname(tmp.append(name).toString());
                attributes.add(Attribute.SENT_FULLNAME_LITERAL);
            }
            if (null == (fullName = account.getSpamFullname())) {
                if (null == prefix) {
                    prefix = Tools.getPrefix(accountId, serverSession);
                    tmp = new StringBuilder(prefix);
                } else if (null == tmp) {
                    tmp = new StringBuilder(prefix);
                } else {
                    tmp.setLength(prefix.length());
                }
                name = account.getSpam();
                if (null == name) {
                    if (null == locale) {
                        locale = serverSession.getUser().getLocale();
                    }
                    if (null == primaryAccount) {
                        primaryAccount = storageService.getDefaultMailAccount(userId, contextId);
                    }
                    name = Tools.getName(2, primaryAccount, locale, Policy.BY_LOCALE);
                    mad.setSpam(name);
                    attributes.add(Attribute.SPAM_LITERAL);
                }
                if ("Spam".equalsIgnoreCase(name) && account.getMailServer().endsWith("yahoo.com")) {
                    name = "Bulk Mail";
                    mad.setSpam(name);
                    attributes.add(Attribute.SPAM_LITERAL);
                }
                mad.setSpamFullname(tmp.append(name).toString());
                attributes.add(Attribute.SPAM_FULLNAME_LITERAL);
            }
            if (null == (fullName = account.getTrashFullname())) {
                if (null == prefix) {
                    prefix = Tools.getPrefix(accountId, serverSession);
                    tmp = new StringBuilder(prefix);
                } else if (null == tmp) {
                    tmp = new StringBuilder(prefix);
                } else {
                    tmp.setLength(prefix.length());
                }
                name = account.getTrash();
                if (null == name) {
                    if (null == locale) {
                        locale = serverSession.getUser().getLocale();
                    }
                    if (null == primaryAccount) {
                        primaryAccount = storageService.getDefaultMailAccount(userId, contextId);
                    }
                    name = Tools.getName(3, primaryAccount, locale, Policy.BY_LOCALE);
                    mad.setTrash(name);
                    attributes.add(Attribute.TRASH_LITERAL);
                }
                mad.setTrashFullname(tmp.append(name).toString());
                attributes.add(Attribute.TRASH_FULLNAME_LITERAL);
            }
            if (attributes.isEmpty()) {
                return account;
            }
            if (null == con) {
                DatabaseService databaseService = ServerServiceRegistry.getServize(DatabaseService.class);
                Connection wcon = databaseService.getWritable(contextId);
                try {
                    MailAccount[] accounts2;
                    storageService.updateMailAccount(mad, attributes, userId, contextId, serverSession, wcon, false);
                    for (MailAccount macc : accounts2 = storageService.getUserMailAccounts(userId, contextId, wcon)) {
                        if (macc.getId() != accountId) continue;
                        MailAccount mailAccount = macc;
                        return mailAccount;
                    }
                    MailAccount[] arr$ = null;
                    return arr$;
                }
                finally {
                    databaseService.backWritable(contextId, wcon);
                }
            }
            storageService.updateMailAccount(mad, attributes, userId, contextId, serverSession, con, false);
            MailAccount[] arr$ = accounts = storageService.getUserMailAccounts(userId, contextId, con);
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                MailAccount macc = arr$[i$];
                if (macc.getId() == accountId) {
                    return macc;
                }
                ++i$;
            }
            return null;
        }
        catch (OXException e) {
            StringBuilder sb = new StringBuilder("Checking default folder full names for account ");
            sb.append(account.getId()).append(" failed with user ").append(userId);
            sb.append(" in context ").append(contextId);
            LoggerFactory.getLogger(Tools.class).warn(sb.toString(), (Throwable)e);
            return account;
        }
    }

    private static String getName(int index, MailAccount primaryAccount, Locale locale, Policy policy) {
        String retval;
        switch (index) {
            case 0: {
                if (Policy.BY_PRIMARY_ACCOUNT == policy) {
                    retval = primaryAccount.getDrafts();
                    if (null != retval) break;
                    retval = DefaultFolderNamesProvider.DEFAULT_PROVIDER.getDrafts();
                    break;
                }
                retval = StringHelper.valueOf(locale).getString(MailStrings.DRAFTS);
                break;
            }
            case 1: {
                if (Policy.BY_PRIMARY_ACCOUNT == policy) {
                    retval = primaryAccount.getSent();
                    if (null != retval) break;
                    retval = DefaultFolderNamesProvider.DEFAULT_PROVIDER.getSent();
                    break;
                }
                retval = StringHelper.valueOf(locale).getString(MailStrings.SENT);
                break;
            }
            case 2: {
                if (Policy.BY_PRIMARY_ACCOUNT == policy) {
                    retval = primaryAccount.getSpam();
                    if (null != retval) break;
                    retval = DefaultFolderNamesProvider.DEFAULT_PROVIDER.getSpam();
                    break;
                }
                retval = StringHelper.valueOf(locale).getString(MailStrings.SPAM);
                break;
            }
            case 3: {
                if (Policy.BY_PRIMARY_ACCOUNT == policy) {
                    retval = primaryAccount.getTrash();
                    if (null != retval) break;
                    retval = DefaultFolderNamesProvider.DEFAULT_PROVIDER.getTrash();
                    break;
                }
                retval = StringHelper.valueOf(locale).getString(MailStrings.TRASH);
                break;
            }
            case 4: {
                if (Policy.BY_PRIMARY_ACCOUNT == policy) {
                    retval = primaryAccount.getConfirmedSpam();
                    if (null != retval) break;
                    retval = DefaultFolderNamesProvider.DEFAULT_PROVIDER.getConfirmedSpam();
                    break;
                }
                retval = "confirmed-spam";
                break;
            }
            case 5: {
                if (Policy.BY_PRIMARY_ACCOUNT == policy) {
                    retval = primaryAccount.getConfirmedHam();
                    if (null != retval) break;
                    retval = DefaultFolderNamesProvider.DEFAULT_PROVIDER.getConfirmedHam();
                    break;
                }
                retval = "confirmed-ham";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown index value: " + index);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPrefix(int accountId, ServerSession session) throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> access = null;
        try {
            access = MailAccess.getInstance(session, accountId);
            access.connect(false);
            String string = access.getFolderStorage().getDefaultFolderPrefix();
            return string;
        }
        finally {
            if (null != access) {
                access.close(true);
            }
        }
    }

    public static void checkNames(MailAccountDescription accountDescription, Set<Attribute> fieldsToUpdate, char sep) {
        String name;
        if (fieldsToUpdate.contains((Object)Attribute.TRASH_FULLNAME_LITERAL) && !Strings.isEmpty((String)accountDescription.getTrashFullname()) && !fieldsToUpdate.contains((Object)Attribute.TRASH_LITERAL)) {
            name = Tools.getName(accountDescription.getTrashFullname(), sep);
            accountDescription.setTrash(name);
            fieldsToUpdate.add(Attribute.TRASH_LITERAL);
        }
        if (fieldsToUpdate.contains((Object)Attribute.SENT_FULLNAME_LITERAL) && !Strings.isEmpty((String)accountDescription.getSentFullname()) && !fieldsToUpdate.contains((Object)Attribute.SENT_LITERAL)) {
            name = Tools.getName(accountDescription.getSentFullname(), sep);
            accountDescription.setSent(name);
            fieldsToUpdate.add(Attribute.SENT_LITERAL);
        }
        if (fieldsToUpdate.contains((Object)Attribute.DRAFTS_FULLNAME_LITERAL) && !Strings.isEmpty((String)accountDescription.getDraftsFullname()) && !fieldsToUpdate.contains((Object)Attribute.DRAFTS_LITERAL)) {
            name = Tools.getName(accountDescription.getDraftsFullname(), sep);
            accountDescription.setDrafts(name);
            fieldsToUpdate.add(Attribute.DRAFTS_LITERAL);
        }
        if (fieldsToUpdate.contains((Object)Attribute.SPAM_FULLNAME_LITERAL) && !Strings.isEmpty((String)accountDescription.getSpamFullname()) && !fieldsToUpdate.contains((Object)Attribute.SPAM_LITERAL)) {
            name = Tools.getName(accountDescription.getSpamFullname(), sep);
            accountDescription.setSpam(name);
            fieldsToUpdate.add(Attribute.SPAM_LITERAL);
        }
        if (fieldsToUpdate.contains((Object)Attribute.CONFIRMED_SPAM_FULLNAME_LITERAL) && !Strings.isEmpty((String)accountDescription.getConfirmedSpamFullname()) && !fieldsToUpdate.contains((Object)Attribute.CONFIRMED_SPAM_LITERAL)) {
            name = Tools.getName(accountDescription.getConfirmedSpamFullname(), sep);
            accountDescription.setConfirmedSpam(name);
            fieldsToUpdate.add(Attribute.CONFIRMED_SPAM_LITERAL);
        }
        if (fieldsToUpdate.contains((Object)Attribute.CONFIRMED_HAM_FULLNAME_LITERAL) && !Strings.isEmpty((String)accountDescription.getConfirmedHamFullname()) && !fieldsToUpdate.contains((Object)Attribute.CONFIRMED_HAM_LITERAL)) {
            name = Tools.getName(accountDescription.getConfirmedHamFullname(), sep);
            accountDescription.setConfirmedHam(name);
            fieldsToUpdate.add(Attribute.CONFIRMED_HAM_LITERAL);
        }
        if (fieldsToUpdate.contains((Object)Attribute.ARCHIVE_FULLNAME_LITERAL) && !Strings.isEmpty((String)accountDescription.getArchiveFullname()) && !fieldsToUpdate.contains((Object)Attribute.ARCHIVE_LITERAL)) {
            name = Tools.getName(accountDescription.getArchiveFullname(), sep);
            accountDescription.setArchive(name);
            fieldsToUpdate.add(Attribute.ARCHIVE_LITERAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char getSeparator(int accountId, ServerSession session) throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> access = null;
        try {
            access = MailAccess.getInstance(session, accountId);
            access.connect(false);
            char c = access.getFolderStorage().getFolder("INBOX").getSeparator();
            return c;
        }
        finally {
            if (null != access) {
                access.close(true);
            }
        }
    }

    public static String getName(String fullName, char separator) {
        if (Strings.isEmpty((String)fullName)) {
            return null;
        }
        return fullName.substring(fullName.lastIndexOf(separator) + 1);
    }

    private static enum Policy {
        BY_PRIMARY_ACCOUNT,
        BY_LOCALE;

    }
}

