/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure.parser;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.java.Charsets;
import com.openexchange.java.StringAllocator;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.ParameterizedHeader;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.structure.parser.ComposedMailWrapper;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MIMEStructureParser {
    private static final Set<String> HEADERS_ADDRESS = new HashSet<String>(Arrays.asList("from", "to", "cc", "bcc", "reply-to", "sender", "errors-to", "resent-bcc", "resent-cc", "resent-from", "resent-to", "resent-sender", "disposition-notification-to"));
    private static final Set<String> HEADERS_DATE = new HashSet<String>(Arrays.asList("date"));
    private static final String PRIMARY_TEXT = "text/";
    private static final String[] SUB_TEXT = new String[]{"plain", "htm"};

    public static void main(String[] args) {
        try {
            JSONObject jsonMail = new JSONObject("{\n  \"user\": [],\n  \"headers\": {\n    \"to\": [{\"address\": \"bob@foobar.com\"}, {\"address\": \"cane@rofl.com\"}],\n    \"received\": [\n      \"from localhost (localhost.localdomain [127.0.0.1]) by ox.open-xchange.com (Postfix) with ESMTP id 63BA22AC4004 for <holger.achtziger@open-xchange.com>; Fri, 30 Oct 2009 08:54:58 +0100 (CET)\",\n      \"from ox.open-xchange.com ([127.0.0.1]) by localhost (ox.open-xchange.com [127.0.0.1]) (amavisd-new, port 10024) with ESMTP id UjQ1iBeTBbxN for <holger.achtziger@open-xchange.com>; Fri, 30 Oct 2009 08:54:58 +0100 (CET)\"\n    ],\n    \"content-disposition\": {\n      \"type\": \"inline\",\n      \"params\": {\"filename\": \"foo.txt\"}\n    },\n    \"from\": [{\n      \"address\": \"alice@foobar.com\",\n      \"personal\": \"Alice Doe\"\n    }],\n    \"subject\": \"The mail subject\",\n    \"content-type\": {\n      \"type\": \"text/plain\",\n      \"params\": {\n        \"charset\": \"UTF-8\",\n        \"name\": \"foo.txt\"\n      }\n    },\n    \"date\": {\n      \"utc\": 1258214589000,\n      \"date\": \"Sat, 14 Nov 2009 17:03:09 +0100 (CET)\"\n    },\n    \"mime-version\": \"1.0\",\n    \"x-priority\": \"3\",\n    \"message-id\": \"<1837640730.5.1258214590077.JavaMail.foobar@foobar>\"\n  },\n  \"color_label\": 0,\n  \"flags\": 0,\n  \"received_date\": null,\n  \"body\": {\n    \"data\": \"Hello Dave.\\nPeople have been asking ...\",\n    \"id\": \"1\"\n  }\n}");
            MailMessage mail = MIMEStructureParser.parseStructure(jsonMail);
            System.out.println(mail.getSource());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private MIMEStructureParser() {
    }

    public static byte[] parseStructure2MIME(JSONObject jsonStructure) throws OXException {
        try {
            MimeMessage mimeMessage = MIMEStructureParser.parseStructure2Message(jsonStructure);
            UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(4096);
            mimeMessage.writeTo((OutputStream)out);
            return out.toByteArray();
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    public static MailMessage parseStructure(JSONObject jsonStructure) throws OXException {
        MimeMessage mimeMessage = MIMEStructureParser.parseStructure2Message(jsonStructure);
        return MimeMessageConverter.convertMessage(mimeMessage);
    }

    public static ComposedMailMessage parseStructure(JSONObject jsonStructure, Session session) throws OXException {
        Context ctx = ContextStorage.getStorageContext(session.getContextId());
        return new ComposedMailWrapper(MIMEStructureParser.parseStructure(jsonStructure), session, ctx);
    }

    public static ComposedMailMessage parseStructure(JSONObject jsonStructure, ServerSession session) throws OXException {
        return new ComposedMailWrapper(MIMEStructureParser.parseStructure(jsonStructure), session, session.getContext());
    }

    private static MimeMessage parseStructure2Message(JSONObject jsonStructure) throws OXException {
        MimeMessage mimeMessage = new MimeMessage(MimeDefaultSession.getDefaultSession());
        MIMEStructureParser.parseMessage(jsonStructure, mimeMessage);
        return mimeMessage;
    }

    private static void parseMessage(JSONObject jsonMessage, MimeMessage mimeMessage) throws OXException {
        MIMEStructureParser.parseFlags(jsonMessage, mimeMessage);
        MIMEStructureParser.parsePart(jsonMessage, (MimePart)mimeMessage);
    }

    private static void parseFlags(JSONObject jsonMessage, MimeMessage mimeMessage) throws OXException {
        try {
            JSONArray jsonUser;
            int length;
            int colorLabel;
            int flags;
            Flags msgFlags = null;
            if (jsonMessage.hasAndNotNull("flags") && (flags = jsonMessage.getInt("flags")) > 0) {
                msgFlags = new Flags();
                if ((flags & 1) > 0) {
                    msgFlags.add(Flags.Flag.ANSWERED);
                }
                if ((flags & 2) > 0) {
                    msgFlags.add(Flags.Flag.DELETED);
                }
                if ((flags & 4) > 0) {
                    msgFlags.add(Flags.Flag.DRAFT);
                }
                if ((flags & 8) > 0) {
                    msgFlags.add(Flags.Flag.FLAGGED);
                }
                if ((flags & 0x10) > 0) {
                    msgFlags.add(Flags.Flag.RECENT);
                }
                if ((flags & 0x20) > 0) {
                    msgFlags.add(Flags.Flag.SEEN);
                }
                if ((flags & 0x40) > 0) {
                    msgFlags.add(Flags.Flag.USER);
                }
                if ((flags & 0x100) > 0) {
                    msgFlags.add("$Forwarded");
                }
                if ((flags & 0x200) > 0) {
                    msgFlags.add("$MDNSent");
                }
            }
            if (jsonMessage.hasAndNotNull("color_label") && (colorLabel = jsonMessage.getInt("color_label")) != 0) {
                if (msgFlags == null) {
                    msgFlags = new Flags();
                }
                msgFlags.add(MailMessage.getColorLabelStringValue(colorLabel));
            }
            if (jsonMessage.hasAndNotNull("user") && (length = (jsonUser = jsonMessage.getJSONArray("user")).length()) > 0) {
                if (msgFlags == null) {
                    msgFlags = new Flags();
                }
                for (int i = length - 1; i >= 0; --i) {
                    msgFlags.add(jsonUser.getString(i));
                }
            }
            if (msgFlags != null) {
                mimeMessage.setFlags(msgFlags, true);
            }
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    private static void parsePart(JSONObject jsonPart, MimePart mimePart) throws OXException {
        try {
            ContentType contentType = new ContentType("text/plain; charset=us-ascii");
            MIMEStructureParser.parseHeaders(jsonPart.getJSONObject("headers"), mimePart, contentType);
            if (contentType.startsWith(PRIMARY_TEXT)) {
                MIMEStructureParser.parseSimpleBodyText(jsonPart.getJSONObject("body"), mimePart, contentType);
            } else if (contentType.startsWith("multipart/")) {
                MIMEStructureParser.parseMultipartBody(jsonPart.getJSONArray("body"), mimePart, contentType.getSubType());
            } else if (contentType.startsWith("message/rfc822") || contentType.getNameParameter() != null && contentType.getNameParameter().endsWith(".eml")) {
                MIMEStructureParser.parseMessageBody(jsonPart.getJSONObject("body"), mimePart);
            } else {
                MIMEStructureParser.parseSimpleBodyBinary(jsonPart.getJSONObject("body"), mimePart, contentType);
            }
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private static void parseMessageBody(JSONObject jsonMessage, MimePart mimePart) throws OXException {
        try {
            MimeMessage mimeMessage = new MimeMessage(MimeDefaultSession.getDefaultSession());
            MIMEStructureParser.parseMessage(jsonMessage, mimeMessage);
            MessageUtility.setContent((Message)mimeMessage, (Part)mimePart);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    private static void parseMultipartBody(JSONArray jsonMultiparts, MimePart mimePart, String subtype) throws OXException {
        try {
            MimeMultipart multipart = new MimeMultipart(subtype);
            int length = jsonMultiparts.length();
            for (int i = 0; i < length; ++i) {
                MimeBodyPart bodyPart = new MimeBodyPart();
                MIMEStructureParser.parsePart(jsonMultiparts.getJSONObject(i), (MimePart)bodyPart);
                multipart.addBodyPart((BodyPart)bodyPart);
            }
            MessageUtility.setContent((Multipart)multipart, (Part)mimePart);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    private static void parseSimpleBodyText(JSONObject jsonBody, MimePart mimePart, ContentType contentType) throws OXException {
        try {
            if (MIMEStructureParser.isText(contentType.getBaseType())) {
                MessageUtility.setText(jsonBody.getString("data"), "UTF-8", contentType.getSubType(), (Part)mimePart);
                mimePart.setHeader("Content-Type", contentType.toString(true));
            } else {
                byte[] bytes = jsonBody.getString("data").toString().getBytes(Charsets.UTF_8);
                mimePart.setDataHandler(new DataHandler((DataSource)new MessageDataSource(bytes, contentType.toString(true))));
                mimePart.setHeader("Content-Type", contentType.toString(true));
            }
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    private static void parseSimpleBodyBinary(JSONObject jsonBody, MimePart mimePart, ContentType contentType) throws OXException {
        try {
            mimePart.setDataHandler(new DataHandler((DataSource)new MessageDataSource(Base64.decodeBase64((byte[])jsonBody.getString("data").getBytes("US-ASCII")), contentType.getBaseType())));
            mimePart.setHeader("Content-Transfer-Encoding", "base64");
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
        }
    }

    private static void parseHeaders(JSONObject jsonHeaders, MimePart mimePart, ContentType contentType) throws OXException {
        try {
            StringBuilder headerNameBuilder = new StringBuilder(16);
            for (Map.Entry entry : jsonHeaders.entrySet()) {
                int i;
                String name = ((String)entry.getKey()).toLowerCase(Locale.ENGLISH);
                if (HEADERS_ADDRESS.contains(name)) {
                    JSONArray jsonAddresses = (JSONArray)entry.getValue();
                    int length = jsonAddresses.length();
                    StringAllocator builder = new StringAllocator(32 * length);
                    String delim = ", ";
                    for (i = length - 1; i >= 0; --i) {
                        JSONObject jsonAddress = jsonAddresses.getJSONObject(i);
                        String address = jsonAddress.getString("address");
                        String personal = jsonAddress.hasAndNotNull("personal") ? jsonAddress.getString("personal") : null;
                        QuotedInternetAddress qia = new QuotedInternetAddress(address, personal, "UTF-8");
                        builder.insert(0, qia.toString()).insert(0, ", ");
                    }
                    mimePart.setHeader(MIMEStructureParser.toHeaderCase(name, headerNameBuilder), builder.delete(0, ", ".length()).toString());
                    continue;
                }
                if (HEADERS_DATE.contains(name)) {
                    JSONObject jsonDate = (JSONObject)entry.getValue();
                    mimePart.setHeader(MIMEStructureParser.toHeaderCase(name, headerNameBuilder), jsonDate.getString("date"));
                    continue;
                }
                if ("content-type".equals(name)) {
                    JSONObject jsonContentType = (JSONObject)entry.getValue();
                    contentType.reset();
                    contentType.setBaseType(jsonContentType.getString("type"));
                    MIMEStructureParser.parseParameterList(jsonContentType.getJSONObject("params"), contentType);
                    mimePart.setHeader(MIMEStructureParser.toHeaderCase(name, headerNameBuilder), contentType.toString(true));
                    continue;
                }
                if ("content-disposition".equals(name)) {
                    JSONObject jsonContentDisposition = (JSONObject)entry.getValue();
                    ContentDisposition contentDisposition = new ContentDisposition();
                    contentDisposition.setDisposition(jsonContentDisposition.getString("type"));
                    MIMEStructureParser.parseParameterList(jsonContentDisposition.getJSONObject("params"), contentDisposition);
                    mimePart.setHeader(MIMEStructureParser.toHeaderCase(name, headerNameBuilder), contentDisposition.toString(true));
                    continue;
                }
                Object value = entry.getValue();
                if (value instanceof JSONArray) {
                    JSONArray jsonHeader = (JSONArray)value;
                    int length = jsonHeader.length();
                    String headerName = MIMEStructureParser.toHeaderCase(name, headerNameBuilder);
                    for (i = length - 1; i >= 0; --i) {
                        mimePart.addHeader(headerName, jsonHeader.getString(i));
                    }
                    continue;
                }
                mimePart.setHeader(MIMEStructureParser.toHeaderCase(name, headerNameBuilder), (String)value);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private static void parseParameterList(JSONObject jsonParameters, ParameterizedHeader parameterizedHeader) throws JSONException {
        for (Map.Entry entry : jsonParameters.entrySet()) {
            String name = ((String)entry.getKey()).toLowerCase(Locale.ENGLISH);
            if ("read-date".equals(name)) {
                JSONObject jsonDate = (JSONObject)entry.getValue();
                parameterizedHeader.addParameter(name, jsonDate.getString("date"));
                continue;
            }
            parameterizedHeader.addParameter(name, (String)entry.getValue());
        }
    }

    private static boolean isText(String contentType) {
        if (contentType.startsWith(PRIMARY_TEXT, 0)) {
            int off = PRIMARY_TEXT.length();
            for (String subtype : SUB_TEXT) {
                if (!contentType.startsWith(subtype, off)) continue;
                return true;
            }
        }
        return false;
    }

    private static String toHeaderCase(String name, StringBuilder builder) {
        StringBuilder sb;
        if (null == name) {
            return null;
        }
        if ("mime-version".equals(name)) {
            return "MIME-Version";
        }
        if ("message-id".equals(name)) {
            return "Message-ID";
        }
        int len = name.length();
        if (len <= 0) {
            return "";
        }
        if (builder == null) {
            sb = new StringBuilder(len);
        } else {
            sb = builder;
            sb.setLength(0);
        }
        sb.append(Character.toUpperCase(name.charAt(0)));
        int i = 1;
        while (i < len) {
            char c;
            if ('-' == (c = name.charAt(i++)) && i < len) {
                sb.append(c).append(Character.toUpperCase(name.charAt(i++)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

