/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.java.Java7ConcurrentLinkedQueue;
import com.openexchange.java.Streams;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.MimeCleanUp;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Queue;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.util.SharedByteArrayInputStream;
import javax.mail.util.SharedFileInputStream;

public final class ManagedMimeMessage
extends MimeMessage
implements MimeCleanUp {
    private static volatile Boolean managedCloneEnabled;
    private static final int DEFAULT_MAX_INMEMORY_SIZE = 0x100000;
    private static final int DEFAULT_BUFFER_SIZE = 131072;
    private final Queue<Closeable> closeables;
    private volatile ManagedFile managedFile;
    private volatile File file;
    private static final byte[] DOUBLE_CRLF;
    private static final byte[] DOUBLE_LF;
    private static final int[] COMPUTED_FAILURE_DOUBLE_CRLF;
    private static final int[] COMPUTED_FAILURE_DOUBL_LF;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean managedCloneEnabled() {
        Boolean tmp = managedCloneEnabled;
        if (null != tmp) return tmp;
        Class<ManagedMimeMessage> clazz = ManagedMimeMessage.class;
        synchronized (ManagedMimeMessage.class) {
            tmp = managedCloneEnabled;
            if (null != tmp) return tmp;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            managedCloneEnabled = tmp = Boolean.valueOf(service != null && service.getBoolProperty("com.openexchange.mail.mime.managedCloneEnabled", false));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    public static MailMessage[] clone(MailMessage[] originals) throws OXException {
        if (null == originals) {
            return null;
        }
        if (!ManagedMimeMessage.managedCloneEnabled()) {
            return originals;
        }
        int length = originals.length;
        if (length <= 0) {
            return new MailMessage[0];
        }
        MailMessage[] ret = new MailMessage[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = ManagedMimeMessage.clone(originals[i]);
        }
        return ret;
    }

    public static MailMessage clone(MailMessage original) throws OXException {
        if (null == original) {
            return null;
        }
        if (!ManagedMimeMessage.managedCloneEnabled()) {
            return original;
        }
        try {
            String mailId;
            ManagedMimeMessage mimeMessage = new ManagedMimeMessage(original);
            MimeMessageConverter.parseMimeFlags(original.getFlags(), (Message)mimeMessage);
            Flags flags = null;
            if (original.containsColorLabel()) {
                flags = new Flags();
                flags.add(MailMessage.getColorLabelStringValue(original.getColorLabel()));
            }
            if (original.containsUserFlags()) {
                String[] userFlags;
                if (null == flags) {
                    flags = new Flags();
                }
                for (String userFlag : userFlags = original.getUserFlags()) {
                    flags.add(userFlag);
                }
            }
            if (null != flags) {
                mimeMessage.setFlags(flags, true);
            }
            MailMessage retval = MimeMessageConverter.convertMessage(mimeMessage, false);
            if (original.containsFolder()) {
                retval.setFolder(original.getFolder());
            }
            if ((mailId = original.getMailId()) != null) {
                retval.setMailId(mailId);
            }
            if (original.containsMsgref()) {
                retval.setMsgref(original.getMsgref());
            }
            if (null != mimeMessage.file) {
                MailAccess.rememberMimeCleanUp(mimeMessage);
            }
            return retval;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    private ManagedMimeMessage(MailMessage original) throws MessagingException, OXException, IOException {
        super(MimeDefaultSession.getDefaultSession());
        File[] files = new File[1];
        InputStream in = ManagedMimeMessage.getInputStreamFor(original, files);
        this.parse(in);
        this.closeables = new Java7ConcurrentLinkedQueue();
        this.closeables.add(in);
        this.managedFile = null;
        this.file = files[0];
    }

    public ManagedMimeMessage(Session session, File file) throws MessagingException, IOException {
        this(session, file, (InputStream)new SharedFileInputStream(file, 131072));
    }

    private ManagedMimeMessage(Session session, File file, InputStream in) throws MessagingException {
        super(session, in);
        this.closeables = new Java7ConcurrentLinkedQueue();
        this.closeables.add(in);
        this.managedFile = null;
        this.file = file;
    }

    public File getFile() {
        File file = this.file;
        return null == file ? this.managedFile.getFile() : file;
    }

    protected void finalize() throws Throwable {
        this.cleanUp();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp() {
        File file;
        Closeable closeable;
        while ((closeable = this.closeables.poll()) != null) {
            Streams.close((Closeable)closeable);
        }
        ManagedFile managedFile = this.managedFile;
        if (null != managedFile) {
            try {
                ManagedFileManagement management = ManagedMimeMessage.getFileManagement();
                if (null != management) {
                    try {
                        management.removeByID(managedFile.getID());
                    }
                    catch (OXException e) {
                        // empty catch block
                    }
                }
            }
            finally {
                this.managedFile = null;
            }
        }
        if (null != (file = this.file)) {
            try {
                file.delete();
            }
            catch (Exception exception) {
            }
            finally {
                this.file = null;
            }
        }
    }

    private static ManagedFileManagement getFileManagement() {
        return ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream getInputStreamFor(MailMessage mail, File[] files) throws OXException, IOException {
        File file;
        long size = mail.getSize();
        if (size > 0L && size <= 0x100000L) {
            UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(131072);
            mail.writeTo((OutputStream)out);
            out.flush();
            files[0] = null;
            return new SharedByteArrayInputStream(out.toByteArray());
        }
        ManagedFileManagement service = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class, true);
        files[0] = file = service.newTempFile();
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            mail.writeTo(out);
            out.flush();
        }
        catch (Throwable throwable) {
            Streams.close(out);
            throw throwable;
        }
        Streams.close((Closeable)out);
        return new SharedFileInputStream(file, 131072);
    }

    private static final byte[][] split(byte[] sourceBytes) {
        if (null == sourceBytes) {
            return new byte[][]{new byte[0], new byte[0]};
        }
        byte[] pattern = DOUBLE_CRLF;
        int pos = ManagedMimeMessage.indexOf(sourceBytes, pattern, 0, COMPUTED_FAILURE_DOUBLE_CRLF);
        if (pos >= 0) {
            byte[] a = new byte[pos];
            int endPos = pos + DOUBLE_CRLF.length;
            byte[] b = new byte[sourceBytes.length - endPos];
            System.arraycopy(sourceBytes, 0, a, 0, a.length);
            System.arraycopy(sourceBytes, endPos, b, 0, b.length);
            return new byte[][]{a, b};
        }
        pattern = DOUBLE_LF;
        pos = ManagedMimeMessage.indexOf(sourceBytes, pattern, 0, COMPUTED_FAILURE_DOUBL_LF);
        if (pos >= 0) {
            byte[] a = new byte[pos];
            int endPos = pos + DOUBLE_LF.length;
            byte[] b = new byte[sourceBytes.length - endPos];
            System.arraycopy(sourceBytes, 0, a, 0, a.length);
            System.arraycopy(sourceBytes, endPos, b, 0, b.length);
            return new byte[][]{a, b};
        }
        return new byte[][]{new byte[0], sourceBytes};
    }

    private static int indexOf(byte[] data, byte[] pattern, int beginIndex, int[] failure) {
        int length = data.length;
        if (beginIndex < 0 || beginIndex > length) {
            throw new IndexOutOfBoundsException(String.valueOf(beginIndex));
        }
        int j = 0;
        if (length == 0) {
            return -1;
        }
        for (int i = beginIndex; i < length; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i - pattern.length + 1;
        }
        return -1;
    }

    static {
        DOUBLE_CRLF = new byte[]{13, 10, 13, 10};
        DOUBLE_LF = new byte[]{10, 10};
        class TMP {
            TMP() {
            }

            int[] computeFailure(byte[] pattern) {
                if (pattern == null) {
                    return null;
                }
                int[] failure = new int[pattern.length];
                int j = 0;
                for (int i = 1; i < pattern.length; ++i) {
                    while (j > 0 && pattern[j] != pattern[i]) {
                        j = failure[j - 1];
                    }
                    if (pattern[j] == pattern[i]) {
                        // empty if block
                    }
                    failure[i] = ++j;
                }
                return failure;
            }
        }
        TMP tmp = new TMP();
        COMPUTED_FAILURE_DOUBLE_CRLF = tmp.computeFailure(DOUBLE_CRLF);
        COMPUTED_FAILURE_DOUBL_LF = tmp.computeFailure(DOUBLE_LF);
    }
}

