/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.api;

import com.javacodegeeks.concurrent.ConcurrentLinkedHashMap;
import com.javacodegeeks.concurrent.EvictionPolicy;
import com.javacodegeeks.concurrent.LRUPolicy;
import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.api.IMailProperties;
import com.openexchange.mail.api.MailCapabilities;
import com.openexchange.mail.config.MailConfigException;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.partmodifier.DummyPartModifier;
import com.openexchange.mail.partmodifier.PartModifier;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mail.utils.MailPasswordUtil;
import com.openexchange.mail.utils.ProviderUtility;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.threadpool.ThreadPools;
import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.mail.internet.AddressException;
import javax.mail.internet.idn.IDNA;
import org.slf4j.LoggerFactory;

public abstract class MailConfig {
    private static volatile Boolean usePartModifier;
    protected static final Class<?>[] CONSTRUCTOR_ARGS;
    protected static final Object[] INIT_ARGS;
    private static final ConcurrentMap<UserID, Future<int[]>> USER_ID_CACHE;
    private static final int LENGTH = 6;
    protected int accountId;
    protected Session session;
    protected String login;
    protected String password;
    protected final String[] standardNames;
    protected final String[] standardFullNames = new String[6];

    public static final <C extends MailConfig> C getConfig(C mailConfig, Session session, int accountId) throws OXException {
        int userId = session.getUserId();
        int contextId = session.getContextId();
        MailAccount mailAccount = ServerServiceRegistry.getServize(MailAccountStorageService.class, true).getMailAccount(accountId, userId, contextId);
        mailConfig.accountId = accountId;
        mailConfig.session = session;
        mailConfig.applyStandardNames(mailAccount);
        MailConfig.fillLoginAndPassword(mailConfig, session, UserStorage.getInstance().getUser(userId, contextId).getLoginInfo(), mailAccount);
        String serverURL = MailConfig.getMailServerURL(mailAccount);
        if (serverURL == null) {
            if (ServerSource.GLOBAL.equals((Object)MailProperties.getInstance().getMailServerSource())) {
                throw MailConfigException.create(new StringAllocator(64).append("Property \"").append("com.openexchange.mail.mailServer").append("\" not set in mail properties").toString());
            }
            throw MailConfigException.create(new StringAllocator(64).append("Cannot determine mail server URL for user ").append(userId).append(" in context ").append(contextId).toString());
        }
        int lastPos = serverURL.length() - 1;
        if (serverURL.charAt(lastPos) == '/') {
            serverURL = serverURL.substring(0, lastPos);
        }
        mailConfig.parseServerURL(serverURL);
        return mailConfig;
    }

    public static final String getMailLogin(MailAccount mailAccount, String userLoginInfo) {
        return MailConfig.saneLogin(MailConfig.getMailLogin0(mailAccount, userLoginInfo));
    }

    private static final String getMailLogin0(MailAccount mailAccount, String userLoginInfo) {
        if (!mailAccount.isDefaultAccount()) {
            return mailAccount.getLogin();
        }
        LoginSource loginSource = MailProperties.getInstance().getLoginSource();
        if (LoginSource.USER_IMAPLOGIN.equals((Object)loginSource)) {
            return mailAccount.getLogin();
        }
        if (LoginSource.PRIMARY_EMAIL.equals((Object)loginSource)) {
            try {
                return QuotedInternetAddress.toACE(mailAccount.getPrimaryAddress());
            }
            catch (AddressException e) {
                String primaryAddress = mailAccount.getPrimaryAddress();
                LoggerFactory.getLogger(MailConfig.class).warn("Login source primary email address \"" + primaryAddress + "\" could not be converted to ASCII. Using unicode representation.", (Throwable)e);
                return primaryAddress;
            }
        }
        return userLoginInfo;
    }

    public static final String getMailServerURL(MailAccount mailAccount) {
        if (!mailAccount.isDefaultAccount()) {
            return mailAccount.generateMailServerURL();
        }
        if (ServerSource.GLOBAL.equals((Object)MailProperties.getInstance().getMailServerSource())) {
            return IDNA.toASCII((String)MailProperties.getInstance().getMailServer());
        }
        return mailAccount.generateMailServerURL();
    }

    public static final String getMailServerURL(Session session, int accountId) throws OXException {
        if (0 == accountId && ServerSource.GLOBAL.equals((Object)MailProperties.getInstance().getMailServerSource())) {
            return IDNA.toASCII((String)MailProperties.getInstance().getMailServer());
        }
        MailAccountStorageService storage = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        return storage.getMailAccount(accountId, session.getUserId(), session.getContextId()).generateMailServerURL();
    }

    public static final PartModifier getPartModifier() {
        return PartModifier.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getUserIDsByMailLogin(final String pattern, boolean isDefaultAccount, final String serverUrl, final Context ctx) throws OXException {
        final MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        if (isDefaultAccount) {
            FutureTask<int[]> ft;
            UserID userID = new UserID(pattern, serverUrl, ctx.getContextId());
            FutureTask<int[]> f = (FutureTask<int[]>)USER_ID_CACHE.get(userID);
            if (null == f && null == (f = (Future)USER_ID_CACHE.putIfAbsent(userID, ft = new FutureTask<int[]>(new Callable<int[]>(){

                @Override
                public int[] call() throws OXException {
                    return MailConfig.forDefaultAccount(pattern, serverUrl, ctx, storageService);
                }
            })))) {
                f = ft;
                ft.run();
            }
            boolean remove = true;
            try {
                int[] retval = (int[])f.get();
                remove = false;
                int[] nArray = retval;
                return nArray;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw MailExceptionCode.INTERRUPT_ERROR.create(e, e.getMessage());
            }
            catch (ExecutionException e) {
                ThreadPools.launderThrowable((ExecutionException)e, OXException.class);
            }
            finally {
                if (remove) {
                    USER_ID_CACHE.remove(userID);
                }
            }
        }
        MailAccount[] accounts = storageService.resolveLogin(pattern, serverUrl, ctx.getContextId());
        int[] retval = new int[accounts.length];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = accounts[i].getUserId();
        }
        return retval;
    }

    protected static int[] forDefaultAccount(String pattern, String serverUrl, Context ctx, MailAccountStorageService storageService) throws OXException {
        switch (MailProperties.getInstance().getLoginSource()) {
            case USER_IMAPLOGIN: 
            case PRIMARY_EMAIL: {
                TIntHashSet userIds;
                MailAccount[] accounts;
                switch (MailProperties.getInstance().getLoginSource()) {
                    case USER_IMAPLOGIN: {
                        accounts = storageService.resolveLogin(pattern, ctx.getContextId());
                        break;
                    }
                    case PRIMARY_EMAIL: {
                        accounts = storageService.resolvePrimaryAddr(pattern, ctx.getContextId());
                        break;
                    }
                    default: {
                        throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create("Unimplemented mail login source.");
                    }
                }
                if (accounts.length == 1) {
                    userIds = new TIntHashSet(1);
                    userIds.add(accounts[0].getUserId());
                } else {
                    userIds = new TIntHashSet(accounts.length);
                    for (MailAccount candidate : accounts) {
                        String shouldMatch;
                        switch (MailProperties.getInstance().getMailServerSource()) {
                            case USER: {
                                shouldMatch = ProviderUtility.toSocketAddrString(candidate.generateMailServerURL(), 143);
                                break;
                            }
                            case GLOBAL: {
                                shouldMatch = ProviderUtility.toSocketAddrString(MailProperties.getInstance().getMailServer(), 143);
                                break;
                            }
                            default: {
                                throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create("Unimplemented mail server source.");
                            }
                        }
                        if (!serverUrl.equals(shouldMatch)) continue;
                        userIds.add(candidate.getUserId());
                    }
                }
                int size = userIds.size();
                TIntHashSet notDefaultAccount = new TIntHashSet(size);
                if (size > 0) {
                    TIntIterator iter = userIds.iterator();
                    int i = size;
                    while (i-- > 0) {
                        int userId = iter.next();
                        for (MailAccount candidate : accounts) {
                            if (candidate.getUserId() != userId || candidate.isDefaultAccount()) continue;
                            notDefaultAccount.add(userId);
                        }
                    }
                }
                if (notDefaultAccount.size() < size) {
                    userIds.removeAll((TIntCollection)notDefaultAccount);
                }
                return userIds.toArray();
            }
            case USER_NAME: {
                return new int[]{UserStorage.getInstance().getUserId(pattern, ctx)};
            }
        }
        throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create("Unimplemented mail login source.");
    }

    public static final String[] parseProtocol(String server) {
        int len = server.length();
        char c = '\u0000';
        for (int i = 0; i < len && (c = server.charAt(i)) != '/'; ++i) {
            if (c != ':' || (c = server.charAt(i + 1)) != '/' || (c = server.charAt(i + 2)) != '/') continue;
            String s = server.substring(0, i).toLowerCase(Locale.ENGLISH);
            if (!MailConfig.isValidProtocol(s)) break;
            int start = i + 1;
            while (server.charAt(start) == '/') {
                ++start;
            }
            return new String[]{s, server.substring(start)};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean usePartModifier() {
        Boolean tmp = usePartModifier;
        if (tmp != null) return tmp;
        Class<MailConfig> clazz = MailConfig.class;
        synchronized (MailConfig.class) {
            tmp = usePartModifier;
            if (tmp != null) return tmp;
            PartModifier pm = PartModifier.getInstance();
            tmp = usePartModifier = Boolean.valueOf(pm != null && !DummyPartModifier.class.isInstance(pm));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    private static final boolean isValidProtocol(String protocol) {
        int len = protocol.length();
        if (len < 1) {
            return false;
        }
        char c = protocol.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            c = protocol.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '+' || c == '-') continue;
            return false;
        }
        return true;
    }

    private static final String saneLogin(String login) {
        ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        if (null != service && !service.getBoolProperty("com.openexchange.mail.saneLogin", true)) {
            return login;
        }
        try {
            return IDNA.toACE((String)login);
        }
        catch (Exception e) {
            return login;
        }
    }

    protected static final void fillLoginAndPassword(MailConfig mailConfig, Session session, String userLoginInfo, MailAccount mailAccount) throws OXException {
        String proxyDelimiter = mailAccount.isDefaultAccount() ? MailProperties.getInstance().getAuthProxyDelimiter() : null;
        String slogin = session.getLoginName();
        mailConfig.login = proxyDelimiter != null && slogin.contains(proxyDelimiter) ? MailConfig.saneLogin(slogin) : MailConfig.getMailLogin(mailAccount, userLoginInfo);
        if (mailAccount.isDefaultAccount()) {
            PasswordSource cur = MailProperties.getInstance().getPasswordSource();
            if (PasswordSource.GLOBAL.equals((Object)cur)) {
                String masterPw = MailProperties.getInstance().getMasterPassword();
                if (masterPw == null) {
                    throw MailConfigException.create(new StringAllocator().append("Property \"masterPassword\" not set").toString());
                }
                mailConfig.password = masterPw;
            } else {
                mailConfig.password = session.getPassword();
            }
        } else {
            String mailAccountPassword = mailAccount.getPassword();
            mailConfig.password = null == mailAccountPassword || mailAccountPassword.length() == 0 ? "" : MailPasswordUtil.decrypt(mailAccountPassword, session, mailAccount.getId(), mailAccount.getLogin(), mailAccount.getMailServer());
        }
        mailConfig.doCustomParsing(mailAccount, session);
    }

    protected MailConfig() {
        this.standardNames = new String[6];
    }

    public String[] getStandardNames() {
        String[] ret = new String[6];
        System.arraycopy(this.standardNames, 0, ret, 0, 6);
        return ret;
    }

    public String[] getStandardFullNames() {
        String[] ret = new String[6];
        System.arraycopy(this.standardFullNames, 0, ret, 0, 6);
        return ret;
    }

    public void applyStandardNames(MailAccount mailAccount) {
        if (null == mailAccount) {
            return;
        }
        MailConfig.put(5, mailAccount.getConfirmedHam(), this.standardNames);
        MailConfig.put(4, mailAccount.getConfirmedSpam(), this.standardNames);
        MailConfig.put(0, mailAccount.getDrafts(), this.standardNames);
        MailConfig.put(1, mailAccount.getSent(), this.standardNames);
        MailConfig.put(2, mailAccount.getSpam(), this.standardNames);
        MailConfig.put(3, mailAccount.getTrash(), this.standardNames);
        MailConfig.put(5, mailAccount.getConfirmedHamFullname(), this.standardFullNames);
        MailConfig.put(4, mailAccount.getConfirmedSpamFullname(), this.standardFullNames);
        MailConfig.put(0, mailAccount.getDraftsFullname(), this.standardFullNames);
        MailConfig.put(1, mailAccount.getSentFullname(), this.standardFullNames);
        MailConfig.put(2, mailAccount.getSpamFullname(), this.standardFullNames);
        MailConfig.put(3, mailAccount.getTrashFullname(), this.standardFullNames);
    }

    private static void put(int index, String value, String[] arr) {
        if (Strings.isEmpty((String)value)) {
            return;
        }
        arr[index] = MailFolderUtility.prepareMailFolderParam(value).getFullname();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MailConfig other = (MailConfig)obj;
        if (this.login == null ? other.login != null : !this.login.equals(other.login)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        return !(this.getServer() == null ? other.getServer() != null : !this.getServer().equals(other.getServer()));
    }

    public int getAccountId() {
        return this.accountId;
    }

    public Session getSession() {
        return this.session;
    }

    public abstract MailCapabilities getCapabilities();

    public final String getLogin() {
        return this.login;
    }

    public final String getPassword() {
        return this.password;
    }

    public abstract int getPort();

    public abstract String getServer();

    public String toString() {
        StringAllocator builder = new StringAllocator();
        builder.append("{ MailConfig [accountId=").append(this.accountId).append(", ");
        if (this.login != null) {
            builder.append("login=").append(this.login).append(", ");
        }
        if (this.password != null) {
            // empty if block
        }
        builder.append("getPort()=").append(this.getPort()).append(", ");
        if (this.getServer() != null) {
            builder.append("getServer()=").append(this.getServer()).append(", ");
        }
        builder.append("isSecure()=").append(this.isSecure()).append("] }");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.login == null ? 0 : this.login.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + this.getPort();
        String server = this.getServer();
        result = 31 * result + (server == null ? 0 : server.hashCode());
        return result;
    }

    public abstract boolean isSecure();

    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setLogin(String login) {
        this.login = MailConfig.saneLogin(login);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected boolean doCustomParsing(MailAccount account, Session session) throws OXException {
        return false;
    }

    public abstract void setPort(int var1);

    public abstract void setSecure(boolean var1);

    public abstract void setServer(String var1);

    public abstract IMailProperties getMailProperties();

    public abstract void setMailProperties(IMailProperties var1);

    protected abstract void parseServerURL(String var1) throws OXException;

    static {
        CONSTRUCTOR_ARGS = new Class[0];
        INIT_ARGS = new Object[0];
        USER_ID_CACHE = new ConcurrentLinkedHashMap(8192, 0.75f, 16, 131072, (EvictionPolicy)new LRUPolicy());
    }

    private static final class UserID {
        private final int contextId;
        private final String pattern;
        private final String serverUrl;
        private final int hash;

        protected UserID(String pattern, String serverUrl, int contextId) {
            this.pattern = pattern;
            this.serverUrl = serverUrl;
            this.contextId = contextId;
            int prime = 31;
            int result = 1;
            result = 31 * result + contextId;
            result = 31 * result + (pattern == null ? 0 : pattern.hashCode());
            this.hash = result = 31 * result + (serverUrl == null ? 0 : serverUrl.hashCode());
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof UserID)) {
                return false;
            }
            UserID other = (UserID)obj;
            if (this.contextId != other.contextId) {
                return false;
            }
            if (this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern)) {
                return false;
            }
            return !(this.serverUrl == null ? other.serverUrl != null : !this.serverUrl.equals(other.serverUrl));
        }
    }

    public static enum ServerSource {
        GLOBAL("global"),
        USER("user");

        private final String str;

        public static final ServerSource parse(String serverSourceStr) {
            ServerSource[] values;
            for (ServerSource serverSource : values = ServerSource.values()) {
                if (!serverSource.str.equalsIgnoreCase(serverSourceStr)) continue;
                return serverSource;
            }
            return null;
        }

        private ServerSource(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }

    public static enum PasswordSource {
        GLOBAL("global"),
        SESSION("session");

        private final String str;

        public static final PasswordSource parse(String passwordSourceStr) {
            PasswordSource[] values;
            for (PasswordSource passwordSource : values = PasswordSource.values()) {
                if (!passwordSource.str.equalsIgnoreCase(passwordSourceStr)) continue;
                return passwordSource;
            }
            return null;
        }

        private PasswordSource(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }

    public static enum LoginSource {
        PRIMARY_EMAIL("mail"),
        USER_IMAPLOGIN("login"),
        USER_NAME("name");

        private final String str;

        public static final LoginSource parse(String loginSourceStr) {
            LoginSource[] values;
            for (LoginSource loginSource : values = LoginSource.values()) {
                if (!loginSource.str.equalsIgnoreCase(loginSourceStr)) continue;
                return loginSource;
            }
            return null;
        }

        private LoginSource(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }

    public static enum BoolCapVal {
        AUTO("auto"),
        FALSE("false"),
        TRUE("true");

        private final String str;

        public static final BoolCapVal parseBoolCapVal(String capVal) {
            if (BoolCapVal.TRUE.str.equalsIgnoreCase(capVal)) {
                return TRUE;
            }
            if (BoolCapVal.AUTO.str.equalsIgnoreCase(capVal)) {
                return AUTO;
            }
            return FALSE;
        }

        private BoolCapVal(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

