/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.DelDateExternalDropForeignKeyUpdateTask;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public class DelDatesPrimaryKeyUpdateTask
extends UpdateTaskAdapter {
    private static final String DEL_DATES = "del_dates";
    private static final String DEL_DATE_EXTERNAL = "delDateExternal";

    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        Connection con = Database.getNoTimeout(cid, true);
        try {
            con.setAutoCommit(false);
            String foreignKey = Tools.existsForeignKey(con, DEL_DATES, new String[]{"cid", "intfield01"}, DEL_DATE_EXTERNAL, new String[]{"cid", "objectId"});
            if (null != foreignKey && !foreignKey.equals("")) {
                Tools.dropForeignKey(con, DEL_DATE_EXTERNAL, foreignKey);
            }
            if (Tools.hasPrimaryKey(con, DEL_DATES)) {
                Tools.dropPrimaryKey(con, DEL_DATES);
            }
            Tools.createPrimaryKey(con, DEL_DATES, new String[]{"cid", "intfield01", "fid"});
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(cid, true, con);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[]{DelDateExternalDropForeignKeyUpdateTask.class.getName()};
    }
}

