/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorrectIndexes
implements UpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(CorrectIndexes.class);

    @Override
    public int addedWithVersion() {
        return 30;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        Connection con = Database.getNoTimeout(contextId, true);
        try {
            con.setAutoCommit(false);
            this.correctAppointmentIndexes(con);
            this.correctGroupIndexes(con);
            this.correctResourceIndexes(con);
            this.correctSettingsIndexes(con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(contextId, true, con);
        }
    }

    private void correctAppointmentIndexes(Connection con) {
        String index2Create;
        String table = "prg_dates";
        String[] oldcolumns1 = new String[]{"timestampfield01"};
        String[] newcolumns1 = new String[]{"cid", "timestampfield01"};
        try {
            String index2Create2;
            String index2Drop = Tools.existsIndex(con, "prg_dates", oldcolumns1);
            if (null != index2Drop) {
                LOG.info("Dropping old index {} on table {}.", (Object)index2Drop, (Object)"prg_dates");
                Tools.dropIndex(con, "prg_dates", index2Drop);
            }
            if (null == (index2Create2 = Tools.existsIndex(con, "prg_dates", newcolumns1))) {
                LOG.info("Creating new index (cid,timestampfield01) on table {}.", (Object)"prg_dates");
                Tools.createIndex(con, "prg_dates", newcolumns1);
            }
        }
        catch (SQLException e) {
            LOG.error("Problem correcting indexes on table {}.", (Object)"prg_dates", (Object)e);
        }
        String[] oldcolumns2 = new String[]{"timestampfield02"};
        String[] newcolumns2 = new String[]{"cid", "timestampfield02"};
        try {
            String index2Drop = Tools.existsIndex(con, "prg_dates", oldcolumns2);
            if (null != index2Drop) {
                LOG.info("Dropping old index {} on table {}.", (Object)index2Drop, (Object)"prg_dates");
                Tools.dropIndex(con, "prg_dates", index2Drop);
            }
            if (null == (index2Create = Tools.existsIndex(con, "prg_dates", newcolumns2))) {
                LOG.info("Creating new index (cid,timestampfield02) on table {}.", (Object)"prg_dates");
                Tools.createIndex(con, "prg_dates", newcolumns2);
            }
        }
        catch (SQLException e) {
            LOG.error("Problem correcting indexes on table {}.", (Object)"prg_dates", (Object)e);
        }
        String[] newcolumns3 = new String[]{"cid", "intfield02"};
        try {
            index2Create = Tools.existsIndex(con, "prg_dates", newcolumns3);
            if (null == index2Create) {
                LOG.info("Creating new index (cid,intfield02) on table {}.", (Object)"prg_dates");
                Tools.createIndex(con, "prg_dates", newcolumns3);
            }
        }
        catch (SQLException e) {
            LOG.error("Problem correcting indexes on table {}.", (Object)"prg_dates", (Object)e);
        }
    }

    private void correctSettingsIndexes(Connection con) {
        String table = "user_setting_mail_signature";
        String[] oldcolumns = new String[]{"cid", "user"};
        try {
            String index2Drop = Tools.existsIndex(con, "user_setting_mail_signature", oldcolumns);
            if (null != index2Drop) {
                LOG.info("Dropping old index {} on table {}.", (Object)index2Drop, (Object)"user_setting_mail_signature");
                Tools.dropIndex(con, "user_setting_mail_signature", index2Drop);
            }
        }
        catch (SQLException e) {
            LOG.error("Problem correcting indexes on table {}.", (Object)"user_setting_mail_signature", (Object)e);
        }
    }

    private void correctGroupIndexes(Connection con) {
        String table1 = "groups";
        String[] oldcolumns1 = new String[]{"identifier"};
        try {
            String index2Drop = Tools.existsIndex(con, "groups", oldcolumns1);
            if (null != index2Drop) {
                LOG.info("Dropping old index {} on table {}.", (Object)index2Drop, (Object)"groups");
                Tools.dropIndex(con, "groups", index2Drop);
            }
        }
        catch (SQLException e) {
            LOG.error("Problem correcting indexes on table {}.", (Object)"groups", (Object)e);
        }
        String table2 = "groups_member";
        String[] oldcolumns2 = new String[]{"cid", "id"};
        try {
            String index2Drop = Tools.existsIndex(con, "groups_member", oldcolumns2);
            if (null != index2Drop) {
                LOG.info("Dropping old index {} on table {}.", (Object)index2Drop, (Object)"groups_member");
                Tools.dropIndex(con, "groups_member", index2Drop);
            }
        }
        catch (SQLException e) {
            LOG.error("Problem correcting indexes on table {}.", (Object)"groups_member", (Object)e);
        }
    }

    private void correctResourceIndexes(Connection con) {
        String table = "resource";
        String[] oldcolumns = new String[]{"identifier"};
        try {
            String index2Drop = Tools.existsIndex(con, "resource", oldcolumns);
            if (null != index2Drop) {
                LOG.info("Dropping old index {} on table {}.", (Object)index2Drop, (Object)"resource");
                Tools.dropIndex(con, "resource", index2Drop);
            }
        }
        catch (SQLException e) {
            LOG.error("Problem correcting indexes on table {}.", (Object)"resource", (Object)e);
        }
    }
}

