/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.java.Autoboxing;
import com.openexchange.tools.file.FileStorage;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearLeftoverAttachmentsUpdateTask
implements UpdateTask {
    private final ThreadLocal<Map<Integer, FileStorage>> filestorages = new ThreadLocal();
    private static final Logger LOG = LoggerFactory.getLogger(ClearLeftoverAttachmentsUpdateTask.class);

    @Override
    public int addedWithVersion() {
        return 11;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        try {
            this.filestorages.set(new HashMap());
            for (LeftoverAttachment att : this.getLeftoverAttachmentsInSchema(contextId)) {
                this.removeFile(att.getFileId(), att.getContextId());
                try {
                    this.removeDatabaseEntry(att.getId(), att.getContextId());
                }
                catch (SQLException e) {
                    throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
                    return;
                }
            }
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            this.filestorages.set(null);
        }
    }

    private void removeDatabaseEntry(int id, int contextId) throws OXException, SQLException {
        this.update(contextId, "DELETE FROM prg_attachment WHERE id = ? and cid = ?", Autoboxing.I((int)id), Autoboxing.I((int)contextId));
    }

    private void update(int contextId, String sql, Object ... args) throws OXException, SQLException {
        Connection writeCon = null;
        Statement stmt = null;
        try {
            writeCon = Database.get(contextId, true);
            writeCon.setAutoCommit(false);
            stmt = writeCon.prepareStatement(sql);
            for (int i = 0; i < args.length; ++i) {
                stmt.setObject(i + 1, args[i]);
            }
            stmt.executeUpdate();
        }
        catch (SQLException x) {
            try {
                writeCon.rollback();
            }
            catch (SQLException x2) {
                LOG.error("Can't execute rollback.", (Throwable)x2);
            }
            throw x;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException x) {
                    LOG.warn("Couldn't close statement", (Throwable)x);
                }
            }
            if (writeCon != null) {
                try {
                    writeCon.setAutoCommit(true);
                }
                catch (SQLException x) {
                    LOG.warn("Can't reset auto commit", (Throwable)x);
                }
                Database.back(contextId, true, writeCon);
            }
        }
    }

    private void removeFile(String fileId, int ctx_id) throws SQLException, OXException, OXException, OXException {
        FileStorage fs = this.filestorages.get().get(Autoboxing.I((int)ctx_id));
        if (fs == null) {
            URI uri = this.createURI(ctx_id);
            if (uri == null) {
                throw UpdateExceptionCodes.OTHER_PROBLEM.create("Can not determine filestore for context " + ctx_id + ".");
            }
            fs = FileStorage.getInstance(uri);
            this.filestorages.get().put(Autoboxing.I((int)ctx_id), fs);
        }
        try {
            fs.deleteFile(fileId);
        }
        catch (OXException x) {
            LOG.warn("Could not delete {}in context {}. The file might be gone already.", (Object)fileId, (Object)ctx_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI createURI(int ctx_id) throws OXException, SQLException {
        Connection readCon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readCon = Database.get(false);
            stmt = readCon.prepareStatement("SELECT filestore_id, filestore_name FROM context WHERE cid = ?");
            stmt.setInt(1, ctx_id);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                LOG.error("Context {} doesn''t seem to have a proper filestore", (Object)ctx_id);
                URI uRI = null;
                return uRI;
            }
            String filestore_name = rs.getString(2);
            int filestore_id = rs.getInt(1);
            rs.close();
            stmt.close();
            stmt = readCon.prepareStatement("SELECT uri FROM filestore WHERE id = ?");
            stmt.setInt(1, filestore_id);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                LOG.error("Context {} doesn''t seem to have a proper filestore", (Object)ctx_id);
                URI uRI = null;
                return uRI;
            }
            String uri_string = rs.getString(1);
            URI uri = new URI(uri_string);
            URI uRI = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath() + '/' + filestore_name, uri.getQuery(), uri.getFragment());
            return uRI;
        }
        catch (URISyntaxException e) {
            LOG.error("", (Throwable)e);
            URI uRI = null;
            return uRI;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException x) {
                    LOG.warn("Couldn't close statement", (Throwable)x);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException x) {
                    LOG.warn("Couldn't close result set");
                }
            }
            if (readCon != null && readCon != null) {
                Database.back(false, readCon);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LeftoverAttachment> getLeftoverAttachmentsInSchema(int contextId) throws SQLException, OXException {
        String query = "SELECT prg_attachment.cid, prg_attachment.id, prg_attachment.file_id FROM prg_attachment JOIN sequence_attachment ON prg_attachment.cid = sequence_attachment.cid  WHERE prg_attachment.id > sequence_attachment.id";
        ArrayList<LeftoverAttachment> attachments2 = new ArrayList<LeftoverAttachment>();
        Connection readCon = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            readCon = Database.get(contextId, false);
            stmt = readCon.prepareStatement("SELECT prg_attachment.cid, prg_attachment.id, prg_attachment.file_id FROM prg_attachment JOIN sequence_attachment ON prg_attachment.cid = sequence_attachment.cid  WHERE prg_attachment.id > sequence_attachment.id");
            rs = stmt.executeQuery();
            while (rs.next()) {
                attachments2.add(new LeftoverAttachment(rs.getString(3), rs.getInt(2), rs.getInt(1)));
            }
            ArrayList<LeftoverAttachment> arrayList = attachments2;
            return arrayList;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException x) {
                    LOG.warn("Couldn't close statement", (Throwable)x);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException x) {
                    LOG.warn("Couldn't close result set");
                }
            }
            if (readCon != null) {
                Database.back(contextId, false, readCon);
            }
        }
    }

    private class LeftoverAttachment {
        String fileId;
        int id;
        int contextId;

        LeftoverAttachment(String fileId, int id, int contextId) {
            this.fileId = fileId;
            this.id = id;
            this.contextId = contextId;
        }

        public String getFileId() {
            return this.fileId;
        }

        public int getId() {
            return this.id;
        }

        public int getContextId() {
            return this.contextId;
        }
    }
}

