/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.links;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum LinkExceptionCodes implements DisplayableOXExceptionCode
{
    NO_LINK_ACCESS_PERMISSION("Unable to access the link between these two objects. Insufficient rights. First object %1$d folder %2$d. Second object %3$d folder %4$d context %5$d.", "You do not have appropriate permissions to access this link.", CATEGORY_PERMISSION_DENIED, 100),
    ALREADY_LINKED("Unable to create a link between these two objects. This link already exists. First object %1$d folder %2$d. Second object %3$d folder %4$d context %5$d.", "This link already exists.", CATEGORY_USER_INPUT, 101),
    SQL_PROBLEM("Invalid SQL query: %s", "Error while reading/writing data from/to the database.", CATEGORY_ERROR, 103);

    private String message;
    private String displayMessage;
    private Category category;
    private int number;

    private LinkExceptionCodes(String message, String displayMessage, Category category, int number) {
        this.message = message;
        this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
        this.category = category;
        this.number = number;
    }

    public String getPrefix() {
        return "LNK";
    }

    public int getNumber() {
        return this.number;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public Category getCategory() {
        return this.category;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

