/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.filestore;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.contexts.impl.RdbContextStorage;
import com.openexchange.groupware.filestore.CachingFilestoreStorage;
import com.openexchange.groupware.filestore.Filestore;
import com.openexchange.groupware.filestore.FilestoreTools;
import com.openexchange.groupware.filestore.RdbFilestoreStorage;
import java.net.URI;
import java.sql.Connection;

public abstract class FilestoreStorage {
    private static final FilestoreStorage INSTANCE = new CachingFilestoreStorage(new RdbFilestoreStorage());

    public static FilestoreStorage getInstance() {
        return INSTANCE;
    }

    public abstract Filestore getFilestore(int var1) throws OXException;

    public abstract Filestore getFilestore(Connection var1, int var2) throws OXException;

    public static URI createURI(Context ctx) throws OXException {
        Filestore store = FilestoreStorage.getInstance().getFilestore(ctx.getFilestoreId());
        return FilestoreTools.createLocation(store, ctx);
    }

    public static URI createURI(Connection con, Context ctx) throws OXException {
        FilestoreStorage storage = FilestoreStorage.getInstance();
        Filestore store = storage.getFilestore(con, ctx.getFilestoreId());
        return FilestoreTools.createLocation(store, ctx);
    }

    public static URI createURI(Connection con, int contextId) throws OXException {
        RdbContextStorage ctxStorage = new RdbContextStorage();
        ContextImpl ctx = ctxStorage.loadContextData(con, contextId);
        FilestoreStorage storage = FilestoreStorage.getInstance();
        Filestore store = storage.getFilestore(con, ctx.getFilestoreId());
        return FilestoreTools.createLocation(store, ctx);
    }
}

