/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.virtual.sql;

import com.openexchange.config.ConfigurationService;
import com.openexchange.database.DatabaseService;
import com.openexchange.event.impl.EventClient;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.internal.Tools;
import com.openexchange.folderstorage.mail.MailFolderType;
import com.openexchange.folderstorage.virtual.VirtualServiceRegistry;
import com.openexchange.folderstorage.virtual.sql.Delete;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.event.EventPool;
import com.openexchange.mail.event.PooledEvent;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Insert {
    private static final String SQL_INSERT = "INSERT INTO virtualTree (cid, tree, user, folderId, parentId, name, modifiedBy, lastModified, shadow) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_INSERT_PERM = "INSERT INTO virtualPermission (cid, tree, user, folderId, entity, groupFlag, fp, orp, owp, odp, adminFlag, system) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_INSERT_SUBS = "INSERT INTO virtualSubscription (cid, tree, user, folderId, subscribed) VALUES (?, ?, ?, ?, ?)";

    private Insert() {
    }

    public static void insertFolder(int cid, int tree, int user, Folder folder, String shadow, Session session) throws OXException {
        DatabaseService databaseService = (DatabaseService)VirtualServiceRegistry.getServiceRegistry().getService(DatabaseService.class, true);
        Connection con = databaseService.getWritable(cid);
        try {
            con.setAutoCommit(false);
            Insert.insertFolder(cid, tree, user, folder, shadow, session, con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        catch (Exception e) {
            DBUtils.rollback(con);
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            databaseService.backWritable(cid, con);
        }
    }

    public static void insertFolder(int cid, int tree, int user, Folder folder, String shadow, Session session, Connection con) throws OXException {
        if (null == con) {
            Insert.insertFolder(cid, tree, user, folder, shadow, session);
            return;
        }
        String folderId = folder.getID();
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(SQL_INSERT);
            int pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos++, folderId);
            stmt.setString(pos++, folder.getParentID());
            stmt.setString(pos++, folder.getName());
            int modifiedBy = folder.getModifiedBy();
            if (modifiedBy == -1) {
                stmt.setNull(pos++, 4);
            } else {
                stmt.setInt(pos++, modifiedBy);
            }
            Date lastModified = folder.getLastModified();
            if (lastModified == null) {
                stmt.setNull(pos++, -5);
            } else {
                stmt.setLong(pos++, lastModified.getTime());
            }
            stmt.setString(pos, null == shadow ? "" : shadow);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
        if (null != session) {
            boolean postEvent;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            boolean bl = postEvent = null == service ? true : service.getBoolProperty("com.openexchange.folderstorage.postEASFolderEvents", true);
            if (postEvent) {
                try {
                    if (MailFolderType.getInstance().servesFolderId(folderId)) {
                        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folder.getParentID());
                        Insert.postEvent(argument.getAccountId(), argument.getFullname(), false, false, session);
                    } else {
                        ServerSession serverSession = ServerSessionAdapter.valueOf(session);
                        new EventClient(serverSession).create(new OXFolderAccess(con, serverSession.getContext()).getFolderObject(Insert.unsignedInt(folderId)));
                    }
                }
                catch (Exception e) {
                    Logger log = LoggerFactory.getLogger(Delete.class);
                    log.error("", (Throwable)e);
                }
            }
        }
    }

    private static void postEvent(int accountId, String fullname, boolean contentRelated, boolean immediateDelivery, Session session) {
        if (0 != accountId) {
            return;
        }
        EventPool.getInstance().put(new PooledEvent(session.getContextId(), session.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullname), contentRelated, immediateDelivery, session));
    }

    private static int unsignedInt(String sInteger) {
        return Tools.getUnsignedInteger(sInteger);
    }
}

