/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.filestorage.osgi;

import com.openexchange.file.storage.composition.IDBasedFolderAccessFactory;
import com.openexchange.file.storage.registry.FileStorageServiceRegistry;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.filestorage.FileStorageFolderStorage;
import com.openexchange.folderstorage.filestorage.FileStorageFolderStorageServiceRegistry;
import com.openexchange.osgi.DeferredActivator;
import com.openexchange.osgi.ServiceRegistry;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileStorageFolderStorageActivator
extends DeferredActivator {
    private static final Logger LOG = LoggerFactory.getLogger(FileStorageFolderStorageActivator.class);
    private ServiceRegistration<FolderStorage> folderStorageRegistration;
    private List<ServiceTracker<?, ?>> trackers;

    protected Class<?>[] getNeededServices() {
        return new Class[]{FileStorageServiceRegistry.class, IDBasedFolderAccessFactory.class};
    }

    protected void handleAvailability(Class<?> clazz) {
        LOG.info("Re-available service: {}", (Object)clazz.getName());
        FileStorageFolderStorageServiceRegistry.getServiceRegistry().addService(clazz, this.getService(clazz));
    }

    protected void handleUnavailability(Class<?> clazz) {
        LOG.warn("Absent service: {}", (Object)clazz.getName());
        FileStorageFolderStorageServiceRegistry.getServiceRegistry().removeService(clazz);
    }

    protected void startBundle() throws Exception {
        try {
            Class<?>[] classes;
            ServiceRegistry registry = FileStorageFolderStorageServiceRegistry.getServiceRegistry();
            registry.clearRegistry();
            for (Class<?> classe : classes = this.getNeededServices()) {
                Object service = this.getService(classe);
                if (null == service) continue;
                registry.addService(classe, service);
            }
            this.trackers = new ArrayList(4);
            for (ServiceTracker<?, ?> tracker : this.trackers) {
                tracker.open();
            }
            Hashtable<String, String> dictionary = new Hashtable<String, String>();
            ((Dictionary)dictionary).put("tree", FolderStorage.REAL_TREE_ID);
            this.folderStorageRegistration = this.context.registerService(FolderStorage.class, (Object)new FileStorageFolderStorage(), dictionary);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }

    protected void stopBundle() throws Exception {
        try {
            if (null != this.trackers) {
                while (!this.trackers.isEmpty()) {
                    this.trackers.remove(0).close();
                }
                this.trackers = null;
            }
            if (null != this.folderStorageRegistration) {
                this.folderStorageRegistration.unregister();
                this.folderStorageRegistration = null;
            }
            FileStorageFolderStorageServiceRegistry.getServiceRegistry().clearRegistry();
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            throw e;
        }
    }
}

