/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.cache;

import com.openexchange.ajax.requesthandler.cache.ResourceCacheMetadata;
import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.preview.PreviewExceptionCodes;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ResourceCacheMetadataStore {
    private static final ResourceCacheMetadataStore INSTANCE = new ResourceCacheMetadataStore();

    private ResourceCacheMetadataStore() {
    }

    public static ResourceCacheMetadataStore getInstance() {
        return INSTANCE;
    }

    public void store(ResourceCacheMetadata metadata) throws OXException {
        DatabaseService dbService = this.getDBService();
        Connection con = dbService.getWritable(metadata.getContextId());
        try {
            this.store(con, metadata);
        }
        catch (SQLException e) {
            throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            dbService.backWritable(metadata.getContextId(), con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Connection con, ResourceCacheMetadata metadata) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("INSERT INTO preview (cid, user, id, size, createdAt, refId, fileName, fileType) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            int pos = 1;
            stmt.setInt(pos++, metadata.getContextId());
            stmt.setInt(pos++, metadata.getUserId() > 0 ? metadata.getUserId() : 0);
            stmt.setString(pos++, metadata.getResourceId());
            stmt.setLong(pos++, metadata.getSize());
            stmt.setLong(pos++, metadata.getCreatedAt());
            if (metadata.getRefId() == null) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, metadata.getRefId());
            }
            if (null == metadata.getFileName()) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, metadata.getFileName());
            }
            if (null == metadata.getFileType()) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, metadata.getFileType());
            }
            stmt.executeUpdate();
        }
        finally {
            Databases.closeSQLStuff((Statement)stmt);
        }
    }

    public boolean update(ResourceCacheMetadata metadata) throws OXException {
        DatabaseService dbService = this.getDBService();
        Connection con = dbService.getWritable(metadata.getContextId());
        try {
            boolean bl = this.update(con, metadata);
            return bl;
        }
        catch (SQLException e) {
            throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            dbService.backWritable(metadata.getContextId(), con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(Connection con, ResourceCacheMetadata metadata) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE preview SET size = ?, createdAt = ?, refId = ?, fileName = ?, fileType = ? WHERE cid = ? AND user = ? AND id = ?");
            int pos = 1;
            stmt.setLong(pos++, metadata.getSize());
            stmt.setLong(pos++, metadata.getCreatedAt());
            if (metadata.getRefId() == null) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, metadata.getRefId());
            }
            if (null == metadata.getFileName()) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, metadata.getFileName());
            }
            if (null == metadata.getFileType()) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, metadata.getFileType());
            }
            stmt.setInt(pos++, metadata.getContextId());
            stmt.setInt(pos++, metadata.getUserId() > 0 ? metadata.getUserId() : 0);
            stmt.setString(pos++, metadata.getResourceId());
            int rows = stmt.executeUpdate();
            boolean bl = rows > 0;
            return bl;
        }
        finally {
            Databases.closeSQLStuff((Statement)stmt);
        }
    }

    public ResourceCacheMetadata load(int contextId, int userId, String resourceId) throws OXException {
        DatabaseService dbService = this.getDBService();
        Connection con = dbService.getReadOnly(contextId);
        try {
            ResourceCacheMetadata resourceCacheMetadata = this.load(con, contextId, userId, resourceId);
            return resourceCacheMetadata;
        }
        catch (SQLException e) {
            throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            dbService.backReadOnly(contextId, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceCacheMetadata load(Connection con, int contextId, int userId, String resourceId) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block5: {
            ResourceCacheMetadata resourceCacheMetadata;
            stmt = null;
            rs = null;
            try {
                if (userId > 0) {
                    stmt = con.prepareStatement("SELECT refId, fileName, fileType, size, createdAt FROM preview WHERE cid = ? AND user = ? AND id = ?");
                    stmt.setInt(1, contextId);
                    stmt.setInt(2, userId);
                    stmt.setString(3, resourceId);
                } else {
                    stmt = con.prepareStatement("SELECT refId, fileName, fileType, size, createdAt FROM preview WHERE cid = ? AND id = ?");
                    stmt.setInt(1, contextId);
                    stmt.setString(2, resourceId);
                }
                rs = stmt.executeQuery();
                if (rs.next()) break block5;
                resourceCacheMetadata = null;
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, stmt);
                throw throwable;
            }
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return resourceCacheMetadata;
        }
        ResourceCacheMetadata metadata = new ResourceCacheMetadata();
        metadata.setContextId(contextId);
        metadata.setUserId(userId);
        metadata.setResourceId(resourceId);
        metadata.setRefId(rs.getString(1));
        metadata.setFileName(rs.getString(2));
        metadata.setFileType(rs.getString(3));
        metadata.setSize(rs.getLong(4));
        metadata.setCreatedAt(rs.getLong(5));
        ResourceCacheMetadata resourceCacheMetadata = metadata;
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return resourceCacheMetadata;
    }

    public Set<String> loadRefIds(int contextId) throws OXException {
        HashSet<String> refIds = new HashSet<String>();
        DatabaseService dbService = this.getDBService();
        Connection con = dbService.getReadOnly(contextId);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT refId FROM preview WHERE cid=? AND refId IS NOT NULL");
            stmt.setInt(1, contextId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                refIds.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, (Statement)stmt);
                dbService.backReadOnly(contextId, con);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        dbService.backReadOnly(contextId, con);
        return refIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceCacheMetadata load(Connection con, String refId) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block3: {
            ResourceCacheMetadata resourceCacheMetadata;
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareStatement("SELECT cid, user, id, fileName, fileType, size, createdAt FROM preview WHERE refId = ?");
                stmt.setString(1, refId);
                rs = stmt.executeQuery();
                if (rs.next()) break block3;
                resourceCacheMetadata = null;
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, (Statement)stmt);
                throw throwable;
            }
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return resourceCacheMetadata;
        }
        ResourceCacheMetadata metadata = new ResourceCacheMetadata();
        metadata.setContextId(rs.getInt(1));
        metadata.setUserId(rs.getInt(2));
        metadata.setResourceId(rs.getString(3));
        metadata.setFileName(rs.getString(4));
        metadata.setFileType(rs.getString(5));
        metadata.setSize(rs.getLong(6));
        metadata.setCreatedAt(rs.getLong(7));
        metadata.setRefId(refId);
        ResourceCacheMetadata resourceCacheMetadata = metadata;
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return resourceCacheMetadata;
    }

    public boolean remove(int contextId, int userId, String resourceId) throws OXException {
        DatabaseService dbService = this.getDBService();
        Connection con = dbService.getWritable(contextId);
        try {
            boolean bl = this.remove(con, contextId, userId, resourceId);
            return bl;
        }
        catch (SQLException e) {
            throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            dbService.backWritable(contextId, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Connection con, int contextId, int userId, String resourceId) throws SQLException {
        boolean bl;
        PreparedStatement stmt = null;
        try {
            if (userId > 0) {
                stmt = con.prepareStatement("DELETE FROM preview WHERE cid = ? AND user = ? AND id = ?");
                stmt.setInt(1, contextId);
                stmt.setInt(2, userId > 0 ? userId : 0);
                stmt.setString(3, resourceId);
            } else {
                stmt = con.prepareStatement("DELETE FROM preview WHERE cid = ? AND id = ?");
                stmt.setInt(1, contextId);
                stmt.setString(2, resourceId);
            }
            int rows = stmt.executeUpdate();
            bl = rows > 0;
        }
        catch (Throwable throwable) {
            Databases.closeSQLStuff(stmt);
            throw throwable;
        }
        Databases.closeSQLStuff((Statement)stmt);
        return bl;
    }

    public List<ResourceCacheMetadata> removeAll(int contextId, int userId, String resourceIdPrefix) throws OXException {
        DatabaseService dbService = this.getDBService();
        Connection con = dbService.getWritable(contextId);
        boolean commited = false;
        try {
            Databases.startTransaction((Connection)con);
            List<ResourceCacheMetadata> result = this.removeAll(con, contextId, userId, resourceIdPrefix);
            con.commit();
            List<ResourceCacheMetadata> list = result;
            return list;
        }
        catch (SQLException e) {
            throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            if (!commited) {
                Databases.rollback((Connection)con);
            }
            Databases.autocommit((Connection)con);
            dbService.backWritable(contextId, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceCacheMetadata> removeAll(Connection con, int contextId, int userId, String resourceIdPrefix) throws SQLException {
        ArrayList<ResourceCacheMetadata> result = new ArrayList<ResourceCacheMetadata>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (userId < 0) {
                stmt = con.prepareStatement("SELECT user, id, fileName, fileType, size, createdAt, refId FROM preview WHERE cid = ? AND id LIKE ? FOR UPDATE");
                stmt.setInt(1, contextId);
                stmt.setString(2, resourceIdPrefix + "%");
            } else {
                stmt = con.prepareStatement("SELECT id, fileName, fileType, size, createdAt, refId FROM preview WHERE cid = ? AND user = ? AND id LIKE ? FOR UPDATE");
                stmt.setInt(1, contextId);
                stmt.setInt(2, userId);
                stmt.setString(3, resourceIdPrefix + "%");
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                int i = 1;
                ResourceCacheMetadata metadata = new ResourceCacheMetadata();
                metadata.setContextId(contextId);
                metadata.setUserId(userId < 0 ? rs.getInt(i++) : userId);
                metadata.setResourceId(rs.getString(i++));
                metadata.setFileName(rs.getString(i++));
                metadata.setFileType(rs.getString(i++));
                metadata.setSize(rs.getLong(i++));
                metadata.setCreatedAt(rs.getLong(i++));
                metadata.setRefId(rs.getString(i++));
                result.add(metadata);
            }
        }
        catch (Throwable throwable) {
            Databases.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        try {
            if (userId < 0) {
                stmt = con.prepareStatement("DELETE FROM preview WHERE cid = ? AND id LIKE ?");
                stmt.setInt(1, contextId);
                stmt.setString(2, resourceIdPrefix + "%");
            } else {
                stmt = con.prepareStatement("DELETE FROM preview WHERE cid = ? AND user = ? AND id LIKE ?");
                stmt.setInt(1, contextId);
                stmt.setInt(2, userId);
                stmt.setString(3, resourceIdPrefix + "%");
            }
            stmt.executeUpdate();
        }
        finally {
            Databases.closeSQLStuff((Statement)stmt);
        }
        return result;
    }

    public List<ResourceCacheMetadata> removeAll(int contextId, int userId) throws OXException {
        DatabaseService dbService = this.getDBService();
        Connection con = dbService.getWritable(contextId);
        boolean commited = false;
        try {
            Databases.startTransaction((Connection)con);
            List<ResourceCacheMetadata> result = this.removeAll(con, contextId, userId);
            con.commit();
            List<ResourceCacheMetadata> list = result;
            return list;
        }
        catch (SQLException e) {
            throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            if (!commited) {
                Databases.rollback((Connection)con);
            }
            Databases.autocommit((Connection)con);
            dbService.backWritable(contextId, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceCacheMetadata> removeAll(Connection con, int contextId, int userId) throws SQLException {
        ArrayList<ResourceCacheMetadata> result = new ArrayList<ResourceCacheMetadata>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (userId < 0) {
                stmt = con.prepareStatement("SELECT user, id, fileName, fileType, size, createdAt, refId FROM preview WHERE cid = ? FOR UPDATE");
                stmt.setInt(1, contextId);
            } else {
                stmt = con.prepareStatement("SELECT id, fileName, fileType, size, createdAt, refId FROM preview WHERE cid = ? AND user = ? FOR UPDATE");
                stmt.setInt(1, contextId);
                stmt.setInt(2, userId);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                int i = 1;
                ResourceCacheMetadata metadata = new ResourceCacheMetadata();
                metadata.setContextId(contextId);
                metadata.setUserId(userId < 0 ? rs.getInt(i++) : userId);
                metadata.setResourceId(rs.getString(i++));
                metadata.setFileName(rs.getString(i++));
                metadata.setFileType(rs.getString(i++));
                metadata.setSize(rs.getLong(i++));
                metadata.setCreatedAt(rs.getLong(i++));
                metadata.setRefId(rs.getString(i++));
                result.add(metadata);
            }
        }
        catch (Throwable throwable) {
            Databases.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        try {
            if (userId < 0) {
                stmt = con.prepareStatement("DELETE FROM preview WHERE cid = ?");
                stmt.setInt(1, contextId);
            } else {
                stmt = con.prepareStatement("DELETE FROM preview WHERE cid = ? AND user = ?");
                stmt.setInt(1, contextId);
                stmt.setInt(2, userId);
            }
            stmt.executeUpdate();
        }
        finally {
            Databases.closeSQLStuff((Statement)stmt);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceCacheMetadata removeOldest(Connection con, int contextId) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ResourceCacheMetadata metadata = null;
        try {
            stmt = con.prepareStatement("SELECT user, id, size, createdAt, fileName, fileType, refId FROM preview WHERE createdAt = (SELECT MIN(createdAt) FROM preview WHERE cid = ?) FOR UPDATE");
            stmt.setInt(1, contextId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                metadata = new ResourceCacheMetadata();
                metadata.setContextId(contextId);
                metadata.setUserId(rs.getInt(1));
                metadata.setResourceId(rs.getString(2));
                metadata.setSize(rs.getLong(3));
                metadata.setCreatedAt(rs.getLong(4));
                metadata.setFileName(rs.getString(5));
                metadata.setFileType(rs.getString(6));
                metadata.setRefId(rs.getString(7));
            }
        }
        catch (Throwable throwable) {
            Databases.closeSQLStuff(rs, (Statement)stmt);
            throw throwable;
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        if (metadata != null) {
            this.remove(con, contextId, metadata.getUserId(), metadata.getResourceId());
        }
        return metadata;
    }

    public void removeByRefId(int contextId, Set<String> refIds) throws OXException {
        DatabaseService dbService = this.getDBService();
        Connection con = dbService.getWritable(contextId);
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("DELETE FROM preview WHERE cid = ? AND refId = ?");
            stmt.setInt(1, contextId);
            for (String refId : refIds) {
                stmt.setString(2, refId);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            Databases.closeSQLStuff((Statement)stmt);
            dbService.backWritable(contextId, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUsedSize(Connection con, int contextId) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block5: {
            block4: {
                long l;
                stmt = null;
                rs = null;
                try {
                    stmt = con.prepareStatement("SELECT SUM(size) FROM preview WHERE cid = ?");
                    stmt.setLong(1, contextId);
                    rs = stmt.executeQuery();
                    if (rs.next()) break block4;
                    l = 0L;
                }
                catch (Throwable throwable) {
                    Databases.closeSQLStuff(rs, (Statement)stmt);
                    throw throwable;
                }
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                return l;
            }
            if (!rs.wasNull()) break block5;
            long l = 0L;
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return l;
        }
        long l = rs.getLong(1);
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return l;
    }

    private DatabaseService getDBService() throws OXException {
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        if (dbService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
        }
        return dbService;
    }
}

