/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.SessionServlet;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.AJAXState;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.requesthandler.ResponseRenderer;
import com.openexchange.ajax.requesthandler.responseRenderers.APIResponseRenderer;
import com.openexchange.exception.LogLevel;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import com.openexchange.log.LogProperties;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.session.SessionSecretChecker;
import com.openexchange.sessiond.SessionExceptionCodes;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherServlet
extends SessionServlet {
    private static final long serialVersionUID = -8060034833311074781L;
    private static final Logger LOG = LoggerFactory.getLogger(DispatcherServlet.class);
    private static final Session NO_SESSION = new SessionObject(Dispatcher.class.getSimpleName() + "-Fake-Session");
    private static final EnumSet<LogProperties.Name> PROPS_TO_IGNORE = EnumSet.of(LogProperties.Name.SESSION_CONTEXT_ID);
    private static final AtomicReference<Dispatcher> DISPATCHER = new AtomicReference();
    private static final AtomicReference<List<ResponseRenderer>> RESPONSE_RENDERERS = new AtomicReference(Collections.emptyList());
    protected final AJAXRequestDataTools defaultRequestDataTools = AJAXRequestDataTools.getInstance();
    protected final String lineSeparator = System.getProperty("line.separator");
    private static final Set<OXExceptionCode> IGNOREES = Collections.unmodifiableSet(new HashSet<OXExceptionCode>(Arrays.asList(new OXExceptionCode[]{OXFolderExceptionCode.NOT_EXISTS, MailExceptionCode.MAIL_NOT_FOUND})));

    public static void setDispatcher(Dispatcher dispatcher) {
        DISPATCHER.set(dispatcher);
    }

    public static Dispatcher getDispatcher() {
        return DISPATCHER.get();
    }

    public static void setPrefix(String prefix) {
        Dispatcher.PREFIX.set(prefix);
    }

    public static String getPrefix() {
        return Dispatcher.PREFIX.get();
    }

    protected AJAXRequestDataTools getAjaxRequestDataTools() {
        return this.defaultRequestDataTools;
    }

    public static void registerRenderer(ResponseRenderer renderer) {
        ArrayList<ResponseRenderer> update;
        List<ResponseRenderer> expect;
        do {
            expect = RESPONSE_RENDERERS.get();
            update = new ArrayList<ResponseRenderer>(expect);
            update.add(renderer);
            Collections.sort(update, new Comparator<ResponseRenderer>(){

                @Override
                public int compare(ResponseRenderer responseRenderer, ResponseRenderer anotherResponseRenderer) {
                    int anotherRanking;
                    int thisRanking = responseRenderer.getRanking();
                    return thisRanking < (anotherRanking = anotherResponseRenderer.getRanking()) ? 1 : (thisRanking == anotherRanking ? 0 : -1);
                }
            });
        } while (!RESPONSE_RENDERERS.compareAndSet(expect, update));
    }

    public static synchronized void unregisterRenderer(ResponseRenderer renderer) {
        ArrayList<ResponseRenderer> update;
        List<ResponseRenderer> expect;
        do {
            expect = RESPONSE_RENDERERS.get();
            update = new ArrayList<ResponseRenderer>(expect);
            update.remove(renderer);
            Collections.sort(update, new Comparator<ResponseRenderer>(){

                @Override
                public int compare(ResponseRenderer responseRenderer, ResponseRenderer anotherResponseRenderer) {
                    int anotherRanking;
                    int thisRanking = responseRenderer.getRanking();
                    return thisRanking < (anotherRanking = anotherResponseRenderer.getRanking()) ? 1 : (thisRanking == anotherRanking ? 0 : -1);
                }
            });
        } while (!RESPONSE_RENDERERS.compareAndSet(expect, update));
    }

    public static void clearRenderer() {
        RESPONSE_RENDERERS.set(Collections.emptyList());
    }

    @Override
    protected void initializeSession(HttpServletRequest req, HttpServletResponse resp) throws OXException {
        boolean sessionParamFound;
        ServerSession session;
        if (null != DispatcherServlet.getSessionObject((ServletRequest)req, true)) {
            return;
        }
        SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
        if (sessiondService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SessiondService.class.getName()});
        }
        String sessionId = req.getParameter("session");
        if (sessionId != null && sessionId.length() > 0) {
            try {
                session = this.getSession(req, sessionId, sessiondService);
            }
            catch (OXException e) {
                if (!SessionExceptionCodes.WRONG_SESSION_SECRET.equals(e)) {
                    throw e;
                }
                String wrongSecret = e.getProperty(SessionExceptionCodes.WRONG_SESSION_SECRET.name());
                if (!"null".equals(wrongSecret)) {
                    throw e;
                }
                session = DispatcherServlet.getSession(hashSource, req, sessionId, sessiondService, new NoSecretCallbackChecker(DISPATCHER.get(), e, this.getAjaxRequestDataTools()));
            }
            this.verifySession(req, sessiondService, sessionId, session);
            DispatcherServlet.rememberSession(req, session);
            DispatcherServlet.checkPublicSessionCookie(req, resp, session, sessiondService);
            sessionParamFound = true;
        } else {
            session = null;
            sessionParamFound = false;
        }
        boolean mayOmitSession = false;
        boolean mayUseFallbackSession = false;
        if (!sessionParamFound) {
            AJAXRequestDataTools requestDataTools = this.getAjaxRequestDataTools();
            String module = requestDataTools.getModule(Dispatcher.PREFIX.get(), req);
            String action = requestDataTools.getAction(req);
            Dispatcher dispatcher = DISPATCHER.get();
            mayOmitSession = dispatcher.mayOmitSession(module, action);
            mayUseFallbackSession = dispatcher.mayUseFallbackSession(module, action);
        }
        if (!mayOmitSession) {
            this.findPublicSessionId(req, session, sessiondService, mayUseFallbackSession);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp, false);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp, false);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp, true);
    }

    private static boolean ignore(OXException e) {
        for (OXExceptionCode code : IGNOREES) {
            if (!code.equals(e)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(HttpServletRequest httpRequest, HttpServletResponse httpResponse, boolean preferStream) throws IOException {
        AJAXRequestResult result;
        AJAXRequestData requestData;
        Dispatcher dispatcher;
        AJAXState state;
        block22: {
            block21: {
                block20: {
                    httpResponse.setStatus(200);
                    httpResponse.setContentType("text/javascript; charset=UTF-8");
                    Tools.disableCaching(httpResponse);
                    state = null;
                    dispatcher = DISPATCHER.get();
                    AJAXRequestDataTools requestDataTools = this.getAjaxRequestDataTools();
                    String module = requestDataTools.getModule(Dispatcher.PREFIX.get(), httpRequest);
                    String action = requestDataTools.getAction(httpRequest);
                    ServerSession session = this.getSession(httpRequest, dispatcher, module, action);
                    requestData = requestDataTools.parseRequest(httpRequest, preferStream, Tools.isMultipartContent(httpRequest), session, Dispatcher.PREFIX.get(), httpResponse);
                    requestData.setSession(session);
                    state = dispatcher.begin();
                    result = dispatcher.perform(requestData, state, session);
                    if (!AJAXRequestResult.ResultType.ETAG.equals((Object)result.getType())) break block20;
                    httpResponse.setStatus(304);
                    long expires = result.getExpires();
                    Tools.setETag(requestData.getETag(), expires > 0L ? expires : -1L, httpResponse);
                    if (null == state) return;
                    dispatcher.end(state);
                    return;
                }
                if (!AJAXRequestResult.ResultType.HTTP_ERROR.equals((Object)result.getType())) break block21;
                this.handleError(result, httpResponse);
                if (null == state) return;
                dispatcher.end(state);
                return;
            }
            if (!AJAXRequestResult.ResultType.DIRECT.equals((Object)result.getType())) break block22;
            if (null == state) return;
            dispatcher.end(state);
            return;
        }
        try {
            this.logException((Exception)((Object)result.getException()), LogLevel.DEBUG);
            this.sendResponse(requestData, result, httpRequest, httpResponse);
            if (null == state) return;
        }
        catch (OXException e) {
            block25: {
                block24: {
                    block23: {
                        if (!AjaxExceptionCodes.MISSING_PARAMETER.equals(e)) break block23;
                        this.sendErrorAndPage(400, e.getMessage(), httpResponse);
                        this.logException((Exception)((Object)e), LogLevel.DEBUG, 400);
                        if (null == state) return;
                        dispatcher.end(state);
                        return;
                    }
                    if (!AjaxExceptionCodes.BAD_REQUEST.equals(e)) break block24;
                    this.sendErrorAndPage(400, e.getMessage(), httpResponse);
                    this.logException((Exception)((Object)e), LogLevel.DEBUG, 400);
                    if (null == state) return;
                    dispatcher.end(state);
                    return;
                }
                if (!AjaxExceptionCodes.HTTP_ERROR.equals(e)) break block25;
                Object[] logArgs = e.getLogArgs();
                Object statusMsg = logArgs.length > 1 ? logArgs[1] : null;
                int sc = (Integer)logArgs[0];
                this.sendErrorAndPage(sc, null == statusMsg ? null : statusMsg.toString(), httpResponse);
                this.logException((Exception)((Object)e), LogLevel.DEBUG, sc);
                if (null == state) return;
                dispatcher.end(state);
                return;
            }
            if (AjaxExceptionCodes.UNEXPECTED_ERROR.equals(e)) {
                Throwable cause = e.getCause();
                LOG.error("Unexpected error", null == cause ? e : cause);
            } else if (DispatcherServlet.ignore(e)) {
                this.logException((Exception)((Object)e), LogLevel.DEBUG, -1);
            } else {
                this.logException((Exception)((Object)e));
            }
            if (APIResponseRenderer.expectsJsCallback(httpRequest)) {
                this.writeErrorAsJsCallback(e, httpRequest, httpResponse);
            } else {
                this.handleOXException(e, httpRequest, httpResponse);
            }
            if (null == state) return;
            dispatcher.end(state);
            return;
        }
        catch (RuntimeException e) {
            this.logException(e);
            this.handleOXException(AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage()), httpRequest, httpResponse);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            finally {
                if (null != state) {
                    dispatcher.end(state);
                }
            }
        }
        dispatcher.end(state);
        return;
    }

    private void handleError(AJAXRequestResult result, HttpServletResponse httpServletResponse) throws IOException {
        int httpStatusCode = result.getHttpStatusCode();
        switch (httpStatusCode) {
            case 202: {
                httpServletResponse.setContentType(null);
                String retry_after = result.getHeader("Retry-After");
                if (Strings.isEmpty((String)retry_after)) break;
                httpServletResponse.addHeader("Retry-After", retry_after);
            }
        }
        httpServletResponse.sendError(result.getHttpStatusCode());
    }

    private void sendErrorAndPage(int statusCode, String statusMsg, HttpServletResponse httpResponse) throws IOException {
        try {
            httpResponse.setStatus(statusCode);
            this.writeErrorPage(statusCode, statusMsg, httpResponse);
        }
        catch (Exception x) {
            httpResponse.sendError(statusCode, null == statusMsg ? null : statusMsg.toString());
            this.flushSafe(httpResponse);
        }
    }

    private void logException(Exception e) {
        this.logException(e, null, -1);
    }

    private void logException(Exception e, LogLevel logLevel) {
        this.logException(e, logLevel, -1);
    }

    private void logException(Exception e, LogLevel logLevel, int statusCode) {
        String msg;
        if (null == e) {
            return;
        }
        String string = msg = statusCode > 0 ? "Error processing request. Signaling HTTP error " + statusCode : "Error processing request.";
        if (null == logLevel) {
            LOG.error(msg, (Throwable)e);
            return;
        }
        switch (logLevel) {
            case TRACE: {
                LOG.trace(msg, (Throwable)e);
                break;
            }
            case DEBUG: {
                LOG.debug(msg, (Throwable)e);
                break;
            }
            case INFO: {
                LOG.info(msg, (Throwable)e);
                break;
            }
            case WARNING: {
                LOG.warn(msg, (Throwable)e);
                break;
            }
            default: {
                LOG.error(msg, (Throwable)e);
            }
        }
    }

    private ServerSession getSession(HttpServletRequest httpRequest, Dispatcher dispatcher, String module, String action) throws OXException {
        ServerSession session = DispatcherServlet.getSessionObject((ServletRequest)httpRequest, dispatcher.mayUseFallbackSession(module, action));
        if (session == null) {
            if (!dispatcher.mayOmitSession(module, action)) {
                if (dispatcher.mayUseFallbackSession(module, action)) {
                    String name = LoginServlet.getPublicSessionCookieName(httpRequest);
                    throw httpRequest.getCookies() == null ? AjaxExceptionCodes.MISSING_COOKIES.create(name) : AjaxExceptionCodes.MISSING_COOKIE.create(name);
                }
                throw AjaxExceptionCodes.MISSING_PARAMETER.create("session");
            }
            session = this.fakeSession();
        }
        return session;
    }

    private ServerSession fakeSession() {
        UserImpl user = new UserImpl();
        user.setAttributes(new HashMap<String, Set<String>>(1));
        return new ServerSessionAdapter(NO_SESSION, new ContextImpl(-1), user);
    }

    protected void sendResponse(AJAXRequestData requestData, AJAXRequestResult result, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        List<ResponseRenderer> responseRenderers = RESPONSE_RENDERERS.get();
        Iterator<ResponseRenderer> iter = responseRenderers.iterator();
        int i = responseRenderers.size();
        while (i-- > 0) {
            ResponseRenderer renderer = iter.next();
            if (!renderer.handles(requestData, result)) continue;
            renderer.write(requestData, result, httpRequest, httpResponse);
            return;
        }
        throw new IllegalStateException("No appropriate " + ResponseRenderer.class.getSimpleName() + " for request data/result pair.");
    }

    private void flushSafe(HttpServletResponse httpResponse) {
        try {
            try {
                Streams.flush((Flushable)httpResponse.getWriter());
            }
            catch (IllegalStateException e) {
                Streams.flush((Flushable)httpResponse.getOutputStream());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String toUpperCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'a' && c <= 'z' ? (char)(c & 0x5F) : c);
        }
        return builder.toString();
    }

    private static final class NoSecretCallbackChecker
    implements SessionSecretChecker {
        private static final String PARAM_TOKEN = Session.PARAM_TOKEN;
        private final Dispatcher dispatcher;
        private final OXException e;
        private final AJAXRequestDataTools requestDataTools;

        protected NoSecretCallbackChecker(Dispatcher dispatcher, OXException e, AJAXRequestDataTools requestDataTools) {
            this.requestDataTools = requestDataTools;
            this.dispatcher = dispatcher;
            this.e = e;
        }

        public void checkSecret(Session session, HttpServletRequest req, String cookieHashSource) throws OXException {
            String action;
            String module = this.requestDataTools.getModule(Dispatcher.PREFIX.get(), req);
            boolean noSecretCallback = this.dispatcher.noSecretCallback(module, action = this.requestDataTools.getAction(req));
            if (!noSecretCallback) {
                throw this.e;
            }
            String paramToken = PARAM_TOKEN;
            String token = (String)session.getParameter(paramToken);
            session.setParameter(paramToken, null);
            if (null == token || !token.equals(req.getParameter(paramToken))) {
                throw this.e;
            }
        }
    }
}

