/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.parser;

import com.openexchange.ajax.parser.ContactSearchTermConverter;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.contact.sqlinjectors.SQLInjector;
import com.openexchange.groupware.contact.sqlinjectors.StringSQLInjector;
import com.openexchange.java.StringAllocator;
import com.openexchange.search.CompositeSearchTerm;
import com.openexchange.search.Operand;
import com.openexchange.search.Operation;
import com.openexchange.search.SearchTerm;
import com.openexchange.search.SingleSearchTerm;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactSearchtermSqlConverter
implements ContactSearchTermConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ContactSearchtermSqlConverter.class);
    private static final String FOLDER_AJAXNAME = ContactField.FOLDER_ID.getAjaxName();
    private StringBuilder bob;
    private List<SQLInjector> injectors;
    private List<String> folders;
    private boolean nextIsFolder;
    private String charset;

    public ContactSearchtermSqlConverter() {
        this.initialize();
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    @Override
    public <T> void parse(SearchTerm<T> term) {
        this.traverseViaInOrder(term);
    }

    protected void initialize() {
        this.bob = new StringBuilder();
        this.injectors = new LinkedList<SQLInjector>();
        this.folders = new LinkedList<String>();
        this.nextIsFolder = false;
    }

    public String getPreparedWhereString() {
        return this.bob.toString().replaceAll("\\s+", " ").trim();
    }

    public List<SQLInjector> getInjectors() {
        return this.injectors;
    }

    @Override
    public List<String> getFolders() {
        return this.folders;
    }

    public boolean hasFolders() {
        return this.folders.size() != 0;
    }

    protected <T> void traverseViaInOrder(SearchTerm<T> term) {
        if (term instanceof SingleSearchTerm) {
            this.traverseViaInorder((SingleSearchTerm)term);
        } else if (term instanceof CompositeSearchTerm) {
            this.traverseViaInorder((CompositeSearchTerm)term);
        } else {
            LOG.error("Got a search term that was neither Composite nor Single. How? {}{}", (Object)System.getProperty("line.separator"), term);
        }
    }

    protected void traverseViaInorder(SingleSearchTerm term) {
        Operand<?>[] operands = term.getOperands();
        Operation operation = term.getOperation();
        this.bob.append(" ( ");
        for (int i = 0; i < operands.length; ++i) {
            String value;
            Operand<?> o = operands[i];
            if (operation.getSqlPosition() == SearchTerm.OperationPosition.BEFORE) {
                this.bob.append(operation.getSqlRepresentation());
            }
            if (o.getType() == Operand.Type.COLUMN) {
                value = (String)o.getValue();
                this.handleFolder(o);
                String field = this.translateFromJSONtoDB(value);
                field = this.handlePrefix(field);
                field = this.handleCharset(field);
                this.bob.append(field);
            }
            if (o.getType() == Operand.Type.CONSTANT) {
                value = (String)o.getValue();
                this.handleFolder(o);
                value = this.handlePatternMatching(value);
                this.injectors.add(new StringSQLInjector(value));
                this.bob.append(this.handleCharset("?"));
            }
            if (operation.getSqlPosition() == SearchTerm.OperationPosition.AFTER) {
                this.bob.append(' ').append(operation.getSqlRepresentation());
            }
            if (operation.getSqlPosition() != SearchTerm.OperationPosition.BETWEEN || i + 1 >= operands.length) continue;
            this.bob.append(' ').append(operation.getSqlRepresentation()).append(' ');
        }
        this.bob.append(" ) ");
    }

    protected void traverseViaInorder(CompositeSearchTerm term) {
        Operation operation = term.getOperation();
        SearchTerm<?>[] operands = term.getOperands();
        this.bob.append(" ( ");
        if (operation.getSqlPosition() == SearchTerm.OperationPosition.BEFORE) {
            this.bob.append(operation.getSqlRepresentation());
        }
        for (int i = 0; i < operands.length; ++i) {
            this.traverseViaInOrder(operands[i]);
            if (operation.getSqlPosition() == SearchTerm.OperationPosition.AFTER) {
                this.bob.append(' ').append(operation.getSqlRepresentation());
            }
            if (operation.getSqlPosition() != SearchTerm.OperationPosition.BETWEEN || i + 1 >= operands.length) continue;
            this.bob.append(' ').append(operation.getSqlRepresentation()).append("    ");
        }
        this.bob.append(" ) ");
    }

    protected void handleFolder(Operand<?> o) {
        if (o.getType() == Operand.Type.COLUMN && o.getValue().equals(FOLDER_AJAXNAME)) {
            this.nextIsFolder = true;
        }
        if (o.getType() == Operand.Type.CONSTANT && this.nextIsFolder) {
            this.folders.add((String)o.getValue());
            this.nextIsFolder = false;
        }
    }

    protected String handlePatternMatching(String value) {
        if (value.indexOf(42) < 0) {
            return value;
        }
        value = value.replaceAll("\\*", "%");
        int index = this.bob.lastIndexOf("=");
        this.bob.replace(index, index + 1, "LIKE");
        return value;
    }

    protected String handleCharset(String field) {
        if (this.charset == null) {
            return field;
        }
        return new StringAllocator("CONVERT(").append(field).append(" USING ").append(this.getCharset()).append(')').toString();
    }

    protected String handlePrefix(String field) {
        if (this.getPrefix() == null) {
            return field;
        }
        return new StringAllocator(this.getPrefix()).append('.').append(field).toString();
    }

    public String translateFromJSONtoDB(String fieldname) {
        ContactField field = ContactField.getByAjaxName(fieldname);
        if (field != null && field.getDbName() != null) {
            return field.getDbName();
        }
        return fieldname;
    }

    protected String getPrefix() {
        return "co";
    }
}

