/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.SessionServlet;
import com.openexchange.exception.OXException;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PermissionServlet
extends SessionServlet {
    private static final Logger LOG = LoggerFactory.getLogger(PermissionServlet.class);
    private static final long serialVersionUID = -1496492688713194989L;

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Tools.disableCaching(resp);
        try {
            this.initializeSession(req, resp);
            ServerSession session = PermissionServlet.getSessionObject((ServletRequest)req);
            if (null != session && !this.hasModulePermission(session)) {
                LOG.info("Status code 403 (FORBIDDEN): No permission to access module.");
                resp.sendError(403, "No Permission");
                return;
            }
            super.service(req, resp);
        }
        catch (OXException e) {
            this.handleOXException(e, req, resp);
        }
    }

    protected abstract boolean hasModulePermission(ServerSession var1);
}

