/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.cli;

import com.openexchange.auth.mbean.AuthenticatorMBean;
import com.openexchange.cli.JMXAuthenticatorImpl;
import com.openexchange.cli.ReservedOptions;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public abstract class AbstractMBeanCLI<R> {
    protected AbstractMBeanCLI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R execute(String[] args) {
        ReservedOptions options = new ReservedOptions();
        boolean error = true;
        try {
            HashMap<String, JMXAuthenticatorImpl> environment;
            options.addOption("h", "help", false, "Prints a help text");
            options.addOption("p", "port", true, "The optional JMX port (default:9999)");
            options.addOption("l", "login", true, "The optional JMX login (if JMX authentication is enabled)");
            options.addOption("s", "password", true, "The optional JMX password (if JMX authentication is enabled)");
            boolean requiresAdministrativePermission = this.requiresAdministrativePermission();
            if (requiresAdministrativePermission) {
                options.addOption("A", "adminuser", true, "Admin username");
                options.addOption("P", "adminpass", true, "Admin password");
            }
            this.addOptions(options);
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse((Options)options, args);
            if (cmd.hasOption('h')) {
                this.printHelp(options);
                System.exit(0);
                R r = null;
                return r;
            }
            int port = this.parsePort('p', 9999, cmd, options);
            String jmxLogin = null;
            if (cmd.hasOption('l')) {
                jmxLogin = cmd.getOptionValue('l');
            }
            String jmxPassword = null;
            if (cmd.hasOption('s')) {
                jmxPassword = cmd.getOptionValue('s');
            }
            if (requiresAdministrativePermission && !cmd.hasOption('A')) {
                System.out.println("You must provide administrative credentials to proceed.");
                this.printHelp(options);
                System.exit(-1);
                R r = null;
                return r;
            }
            if (requiresAdministrativePermission && !cmd.hasOption('P')) {
                System.out.println("You must provide administrative credentials to proceed.");
                this.printHelp(options);
                System.exit(-1);
                R r = null;
                return r;
            }
            String adminLogin = cmd.getOptionValue('A');
            String adminPassword = cmd.getOptionValue('P');
            this.checkOptions(cmd);
            if (jmxLogin == null || jmxPassword == null) {
                environment = null;
            } else {
                environment = new HashMap<String, JMXAuthenticatorImpl>(1);
                environment.put("jmx.remote.authenticator", new JMXAuthenticatorImpl(jmxLogin, jmxPassword));
            }
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/server");
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url, environment);
            R retval = null;
            try {
                MBeanServerConnection mbsc = jmxConnector.getMBeanServerConnection();
                try {
                    if (requiresAdministrativePermission) {
                        AuthenticatorMBean authenticator = this.authenticatorMBean(mbsc);
                        this.administrativeAuth(adminLogin, adminPassword, cmd, authenticator);
                    }
                    retval = this.invoke(options, cmd, mbsc);
                }
                catch (Exception e) {
                    Throwable t = e.getCause();
                    String message = null == t ? e.getMessage() : t.getMessage();
                    System.err.println(null == message ? "An error occurred." : message);
                }
            }
            finally {
                try {
                    jmxConnector.close();
                }
                catch (Exception e) {}
            }
            error = false;
            R r = retval;
            return r;
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line: " + e.getMessage());
            this.printHelp(options);
        }
        catch (MalformedURLException e) {
            System.err.println("URL to connect to server is invalid: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("Unable to communicate with the server: " + e.getMessage());
        }
        catch (RuntimeException e) {
            System.err.println("Problem in runtime: " + e.getMessage());
        }
        finally {
            if (error) {
                System.exit(1);
            }
        }
        return null;
    }

    protected int parsePort(char opt, int defaultValue, CommandLine cmd, Options options) {
        int port = defaultValue;
        String sPort = cmd.getOptionValue(opt);
        if (null != sPort) {
            try {
                port = Integer.parseInt(sPort.trim());
            }
            catch (NumberFormatException e) {
                System.err.println("Port parameter is not a number: " + sPort);
                this.printHelp(options);
                System.exit(1);
            }
        }
        if (port < 1 || port > 65535) {
            System.err.println("Port parameter is out of range: " + sPort + ". Valid range is from 1 to 65535.");
            this.printHelp(options);
            System.exit(1);
        }
        return port;
    }

    protected void printHelp(Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(74, this.getName(), null, options, this.getFooter(), false);
    }

    protected AuthenticatorMBean authenticatorMBean(MBeanServerConnection mbsc) throws MalformedObjectNameException {
        return AbstractMBeanCLI.getMBean(mbsc, AuthenticatorMBean.class);
    }

    protected abstract void checkOptions(CommandLine var1);

    protected abstract boolean requiresAdministrativePermission();

    protected abstract void administrativeAuth(String var1, String var2, CommandLine var3, AuthenticatorMBean var4) throws MBeanException;

    protected abstract String getFooter();

    protected abstract String getName();

    protected abstract void addOptions(Options var1);

    protected abstract R invoke(Options var1, CommandLine var2, MBeanServerConnection var3) throws Exception;

    protected static <MBean> MBean getMBean(MBeanServerConnection mbsc, Class<? extends MBean> clazz) throws MalformedObjectNameException {
        return MBeanServerInvocationHandler.newProxyInstance(mbsc, AbstractMBeanCLI.getObjectName(clazz.getName(), "com.openexchange.auth"), clazz, false);
    }

    protected static ObjectName getObjectName(String className, String domain) throws MalformedObjectNameException {
        int pos = className.lastIndexOf(46);
        return new ObjectName(domain, "name", pos == -1 ? className : className.substring(pos + 1));
    }
}

