/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action.ifheader;

import com.openexchange.webdav.action.ifheader.IfHeaderEntity;
import com.openexchange.webdav.action.ifheader.StandardIfHeaderApply;
import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavCollection;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavMethod;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;

public class StandardIfHeaderApplyTest
extends TestCase {
    public void testETagMustMatch() throws WebdavProtocolException {
        StandardIfHeaderApply apply = this.getApply();
        IfHeaderEntity.ETag entity = new IfHeaderEntity.ETag("1234567");
        entity.setMatches(true);
        WebdavResource resource = this.resourceWithETag("1234567");
        StandardIfHeaderApplyTest.assertTrue((boolean)apply.matches((IfHeaderEntity)entity, resource));
        resource = this.resourceWithETag("654321");
        StandardIfHeaderApplyTest.assertFalse((boolean)apply.matches((IfHeaderEntity)entity, resource));
    }

    protected StandardIfHeaderApply getApply() {
        return new StandardIfHeaderApply();
    }

    public void testETagMustNotMatch() throws WebdavProtocolException {
        StandardIfHeaderApply apply = this.getApply();
        IfHeaderEntity.ETag entity = new IfHeaderEntity.ETag("1234567");
        entity.setMatches(false);
        WebdavResource resource = this.resourceWithETag("1234567");
        StandardIfHeaderApplyTest.assertFalse((boolean)apply.matches((IfHeaderEntity)entity, resource));
        resource = this.resourceWithETag("654321");
        StandardIfHeaderApplyTest.assertTrue((boolean)apply.matches((IfHeaderEntity)entity, resource));
    }

    public void testLockMustMatch() throws WebdavProtocolException {
        StandardIfHeaderApply apply = this.getApply();
        IfHeaderEntity.LockToken entity = new IfHeaderEntity.LockToken("1234567");
        entity.setMatches(true);
        WebdavResource resource = this.resourceWithLock("1234567");
        StandardIfHeaderApplyTest.assertTrue((boolean)apply.matches((IfHeaderEntity)entity, resource));
        resource = this.resourceWithLock("654321");
        StandardIfHeaderApplyTest.assertFalse((boolean)apply.matches((IfHeaderEntity)entity, resource));
    }

    public void testLockMustNotMatch() throws WebdavProtocolException {
        StandardIfHeaderApply apply = this.getApply();
        IfHeaderEntity.LockToken entity = new IfHeaderEntity.LockToken("1234567");
        entity.setMatches(false);
        WebdavResource resource = this.resourceWithLock("1234567");
        StandardIfHeaderApplyTest.assertFalse((boolean)apply.matches((IfHeaderEntity)entity, resource));
        resource = this.resourceWithLock("654321");
        StandardIfHeaderApplyTest.assertTrue((boolean)apply.matches((IfHeaderEntity)entity, resource));
    }

    protected WebdavResource resourceWithETag(final String eTag) {
        return new WebdavResource(){

            public String getETag() throws WebdavProtocolException {
                return eTag;
            }

            public WebdavResource copy(WebdavPath string) throws WebdavProtocolException {
                return null;
            }

            public WebdavResource copy(WebdavPath string, boolean noroot, boolean overwrite) throws WebdavProtocolException {
                return null;
            }

            public void create() throws WebdavProtocolException {
            }

            public void delete() throws WebdavProtocolException {
            }

            public boolean exists() throws WebdavProtocolException {
                return false;
            }

            public List<WebdavProperty> getAllProps() throws WebdavProtocolException {
                return null;
            }

            public InputStream getBody() throws WebdavProtocolException {
                return null;
            }

            public String getContentType() throws WebdavProtocolException {
                return null;
            }

            public Date getCreationDate() throws WebdavProtocolException {
                return null;
            }

            public String getDisplayName() throws WebdavProtocolException {
                return null;
            }

            public String getLanguage() throws WebdavProtocolException {
                return null;
            }

            public Date getLastModified() throws WebdavProtocolException {
                return null;
            }

            public Long getLength() throws WebdavProtocolException {
                return null;
            }

            public WebdavLock getLock(String token) throws WebdavProtocolException {
                return null;
            }

            public List<WebdavLock> getLocks() throws WebdavProtocolException {
                return null;
            }

            public WebdavMethod[] getOptions() throws WebdavProtocolException {
                return null;
            }

            public WebdavLock getOwnLock(String token) throws WebdavProtocolException {
                return null;
            }

            public List<WebdavLock> getOwnLocks() throws WebdavProtocolException {
                return null;
            }

            public WebdavProperty getProperty(String namespace, String name) throws WebdavProtocolException {
                return null;
            }

            public String getResourceType() throws WebdavProtocolException {
                return null;
            }

            public String getSource() throws WebdavProtocolException {
                return null;
            }

            public WebdavPath getUrl() {
                return null;
            }

            public boolean isCollection() {
                return false;
            }

            public boolean isLockNull() {
                return false;
            }

            public void lock(WebdavLock lock) throws WebdavProtocolException {
            }

            public WebdavResource move(WebdavPath newUri) throws WebdavProtocolException {
                return null;
            }

            public WebdavResource move(WebdavPath string, boolean noroot, boolean overwrite) throws WebdavProtocolException {
                return null;
            }

            public void putBody(InputStream data) throws WebdavProtocolException {
            }

            public void putBodyAndGuessLength(InputStream body) throws WebdavProtocolException {
            }

            public void putProperty(WebdavProperty prop) throws WebdavProtocolException {
            }

            public WebdavResource reload() throws WebdavProtocolException {
                return null;
            }

            public void removeProperty(String namespace, String name) throws WebdavProtocolException {
            }

            public void save() throws WebdavProtocolException {
            }

            public void setContentType(String type) throws WebdavProtocolException {
            }

            public void setDisplayName(String displayName) throws WebdavProtocolException {
            }

            public void setLanguage(String language) throws WebdavProtocolException {
            }

            public void setLength(Long length) throws WebdavProtocolException {
            }

            public void setSource(String source) throws WebdavProtocolException {
            }

            public WebdavCollection toCollection() {
                return null;
            }

            public void unlock(String token) throws WebdavProtocolException {
            }

            public Protocol getProtocol() {
                return null;
            }
        };
    }

    protected WebdavResource resourceWithLock(final String lock) {
        return new WebdavResource(){

            public WebdavLock getLock(String token) throws WebdavProtocolException {
                if (!lock.equals(token)) {
                    return null;
                }
                WebdavLock webdavLock = new WebdavLock();
                webdavLock.setToken(lock);
                return webdavLock;
            }

            public List<WebdavLock> getLocks() throws WebdavProtocolException {
                return Arrays.asList(this.getLock(lock));
            }

            public String getETag() throws WebdavProtocolException {
                return null;
            }

            public WebdavResource copy(WebdavPath string) throws WebdavProtocolException {
                return null;
            }

            public WebdavResource copy(WebdavPath string, boolean noroot, boolean overwrite) throws WebdavProtocolException {
                return null;
            }

            public void create() throws WebdavProtocolException {
            }

            public void delete() throws WebdavProtocolException {
            }

            public boolean exists() throws WebdavProtocolException {
                return false;
            }

            public List<WebdavProperty> getAllProps() throws WebdavProtocolException {
                return null;
            }

            public InputStream getBody() throws WebdavProtocolException {
                return null;
            }

            public String getContentType() throws WebdavProtocolException {
                return null;
            }

            public Date getCreationDate() throws WebdavProtocolException {
                return null;
            }

            public String getDisplayName() throws WebdavProtocolException {
                return null;
            }

            public String getLanguage() throws WebdavProtocolException {
                return null;
            }

            public Date getLastModified() throws WebdavProtocolException {
                return null;
            }

            public Long getLength() throws WebdavProtocolException {
                return null;
            }

            public WebdavMethod[] getOptions() throws WebdavProtocolException {
                return null;
            }

            public WebdavLock getOwnLock(String token) throws WebdavProtocolException {
                return null;
            }

            public List<WebdavLock> getOwnLocks() throws WebdavProtocolException {
                return null;
            }

            public WebdavProperty getProperty(String namespace, String name) throws WebdavProtocolException {
                return null;
            }

            public String getResourceType() throws WebdavProtocolException {
                return null;
            }

            public String getSource() throws WebdavProtocolException {
                return null;
            }

            public WebdavPath getUrl() {
                return null;
            }

            public boolean isCollection() {
                return false;
            }

            public boolean isLockNull() {
                return false;
            }

            public void lock(WebdavLock lock2) throws WebdavProtocolException {
            }

            public WebdavResource move(WebdavPath newUri) throws WebdavProtocolException {
                return null;
            }

            public WebdavResource move(WebdavPath string, boolean noroot, boolean overwrite) throws WebdavProtocolException {
                return null;
            }

            public void putBody(InputStream data) throws WebdavProtocolException {
            }

            public void putBodyAndGuessLength(InputStream body) throws WebdavProtocolException {
            }

            public void putProperty(WebdavProperty prop) throws WebdavProtocolException {
            }

            public WebdavResource reload() throws WebdavProtocolException {
                return null;
            }

            public void removeProperty(String namespace, String name) throws WebdavProtocolException {
            }

            public void save() throws WebdavProtocolException {
            }

            public void setContentType(String type) throws WebdavProtocolException {
            }

            public void setDisplayName(String displayName) throws WebdavProtocolException {
            }

            public void setLanguage(String language) throws WebdavProtocolException {
            }

            public void setLength(Long length) throws WebdavProtocolException {
            }

            public void setSource(String source) throws WebdavProtocolException {
            }

            public WebdavCollection toCollection() {
                return null;
            }

            public void unlock(String token) throws WebdavProtocolException {
            }

            public Protocol getProtocol() {
                return null;
            }
        };
    }
}

