/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.service;

import com.openexchange.tools.service.ServicePriorityConflictException;
import com.openexchange.tools.service.SpecificServiceChooser;
import junit.framework.TestCase;

public class SpecificServiceChooserTest
extends TestCase {
    private SpecificServiceChooser<TestService> specificServiceChooser;

    public void setUp() {
        this.specificServiceChooser = new SpecificServiceChooser();
    }

    public void testChooseMostSpecificService() throws ServicePriorityConflictException {
        this.specificServiceChooser.registerForEverything((Object)new TestServiceImpl(1), 1);
        this.specificServiceChooser.registerForEverything((Object)new TestServiceImpl(80), 0);
        this.specificServiceChooser.registerForContext((Object)new TestServiceImpl(2), 0, 1337);
        this.specificServiceChooser.registerForContextAndFolder((Object)new TestServiceImpl(3), 0, 1337, 12);
        this.specificServiceChooser.registerForFolder((Object)new TestServiceImpl(4), 2, 13);
        this.assertChooses(1, 1338, 2);
        this.assertChooses(2, 1337, 2);
        this.assertChooses(3, 1337, 12);
        this.assertChooses(4, 1338, 13);
        this.assertChooses(4, 1337, 13);
    }

    public void testChooseMostSpecificServiceWithStringIDs() throws ServicePriorityConflictException {
        this.specificServiceChooser.registerForEverything((Object)new TestServiceImpl(1), 1);
        this.specificServiceChooser.registerForEverything((Object)new TestServiceImpl(80), 0);
        this.specificServiceChooser.registerForContext((Object)new TestServiceImpl(2), 0, 1337);
        this.specificServiceChooser.registerForContextAndFolder((Object)new TestServiceImpl(3), 0, 1337, "gnitz");
        this.specificServiceChooser.registerForFolder((Object)new TestServiceImpl(4), 2, "batz");
        this.assertChooses(1, 1338, "2");
        this.assertChooses(2, 1337, "2");
        this.assertChooses(3, 1337, "gnitz");
        this.assertChooses(4, 1338, "batz");
        this.assertChooses(4, 1337, "batz");
    }

    public void testRemovingServices() throws ServicePriorityConflictException {
        TestServiceImpl serviceInstance = new TestServiceImpl(1);
        this.specificServiceChooser.registerForEverything((Object)serviceInstance, 1);
        this.specificServiceChooser.registerForEverything((Object)new TestServiceImpl(80), 0);
        this.specificServiceChooser.removeForEverything((Object)serviceInstance);
        this.assertChooses(80, 1338, "2");
        this.specificServiceChooser = new SpecificServiceChooser();
        this.specificServiceChooser.registerForContext((Object)new TestServiceImpl(2), 2, 1337);
        this.specificServiceChooser.registerForContext((Object)new TestServiceImpl(82), 0, 1337);
        this.specificServiceChooser.removeForContext((Object)new TestServiceImpl(2), 1337);
        this.assertChooses(82, 1337, "bla");
        this.specificServiceChooser = new SpecificServiceChooser();
        this.specificServiceChooser.registerForContextAndFolder((Object)new TestServiceImpl(2), 2, 1337, 12);
        this.specificServiceChooser.registerForContextAndFolder((Object)new TestServiceImpl(84), 0, 1337, 12);
        this.specificServiceChooser.removeForContextAndFolder((Object)new TestServiceImpl(2), 1337, 12);
        this.assertChooses(84, 1337, 12);
        this.specificServiceChooser = new SpecificServiceChooser();
        this.specificServiceChooser.registerForFolder((Object)new TestServiceImpl(2), 2, 12);
        this.specificServiceChooser.registerForFolder((Object)new TestServiceImpl(84), 0, 12);
        this.specificServiceChooser.removeForFolder((Object)new TestServiceImpl(2), 12);
        this.assertChooses(84, 1337, 12);
    }

    public void testConflictingServices() throws ServicePriorityConflictException {
        this.specificServiceChooser.registerForContext((Object)new TestServiceImpl(2), 0, 1337);
        this.specificServiceChooser.registerForFolder((Object)new TestServiceImpl(4), 0, 13);
        try {
            this.specificServiceChooser.choose(1337, 13);
            SpecificServiceChooserTest.fail((String)"Should have thrown Exception");
        }
        catch (ServicePriorityConflictException servicePriorityConflictException) {
            // empty catch block
        }
        try {
            this.specificServiceChooser.registerForFolder((Object)new TestServiceImpl(5), 0, 13);
            SpecificServiceChooserTest.fail((String)"Should have thrown Exception");
        }
        catch (ServicePriorityConflictException servicePriorityConflictException) {
            // empty catch block
        }
    }

    private void assertChooses(int expected, int cid, int folderId) throws ServicePriorityConflictException {
        TestService chosen = (TestService)this.specificServiceChooser.choose(cid, folderId);
        SpecificServiceChooserTest.assertEquals((String)("Wrong service chosen for " + cid + " : " + folderId), (int)expected, (int)chosen.getId());
    }

    private void assertChooses(int expected, int cid, String folderId) throws ServicePriorityConflictException {
        TestService chosen = (TestService)this.specificServiceChooser.choose(cid, folderId);
        SpecificServiceChooserTest.assertEquals((String)("Wrong service chosen for " + cid + " : " + folderId), (int)expected, (int)chosen.getId());
    }

    private static final class TestServiceImpl
    implements TestService {
        private final int id;

        public TestServiceImpl(int id) {
            this.id = id;
        }

        @Override
        public int getId() {
            return this.id;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object obj) {
            return this.id == ((TestServiceImpl)obj).id;
        }
    }

    private static interface TestService {
        public int getId();
    }
}

