/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.osgi;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.LoginTest;
import com.openexchange.test.osgi.AbstractBundleTest;
import com.openexchange.tools.URLParameter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class BundleTestCache
extends AbstractBundleTest {
    private static final Logger LOG = LoggerFactory.getLogger(BundleTestCache.class);
    private static final String BUNDLE_ID = "com.openexchange.caching";
    private static final String USER_URL = "/ajax/contacts";
    private static final int[] CONTACT_FIELDS = new int[]{1, 524, 555};

    public BundleTestCache(String name) {
        super(name);
    }

    public void testCacheAbsence() {
        try {
            LoginTest loginTest = new LoginTest("LoginTest");
            JSONObject jsonObject = BundleTestCache.login(this.getWebConversation(), loginTest.getHostName(), loginTest.getLogin(), loginTest.getPassword());
            BundleTestCache.assertTrue((String)"Error contained in returned JSON object", (!jsonObject.has("error") || jsonObject.isNull("error") ? 1 : 0) != 0);
            BundleTestCache.assertTrue((String)"Missing session ID", (jsonObject.has("session") && !jsonObject.isNull("session") ? 1 : 0) != 0);
            String sessionId = jsonObject.getString("session");
            JSONObject userObject = BundleTestCache.searchUser(this.getWebConversation(), "*", loginTest.getHostName(), sessionId);
            BundleTestCache.assertTrue((String)"Error contained in returned JSON object", (!userObject.has("error") || userObject.isNull("error") ? 1 : 0) != 0);
            JSONObject infostoreObject = BundleTestCache.allInfostoreItems(this.getWebConversation(), loginTest.getHostName(), sessionId, BundleTestCache.getStandardInfostoreFolder(this.getWebConversation(), loginTest.getHostName(), sessionId), new int[]{1, 700, 706, 701, 20});
            BundleTestCache.assertTrue((String)"Error contained in returned JSON object", (!infostoreObject.has("error") || infostoreObject.isNull("error") ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            BundleTestCache.fail((String)e.getMessage());
        }
    }

    private static JSONObject searchUser(WebConversation webCon, String searchpattern, String host, String session) throws Exception {
        JSONObject json;
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", session);
        parameter.setParameter("action", "search");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CONTACT_FIELDS[0]);
        for (int a = 1; a < CONTACT_FIELDS.length; ++a) {
            stringBuilder.append(',').append(CONTACT_FIELDS[a]);
        }
        parameter.setParameter("columns", stringBuilder.toString());
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("pattern", (Object)searchpattern);
        ByteArrayInputStream bais = new ByteArrayInputStream(jsonObj.toString().getBytes());
        PutMethodWebRequest req = new PutMethodWebRequest("http://" + host + USER_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript");
        WebResponse resp = webCon.getResponse((WebRequest)req);
        BundleTestCache.assertEquals((String)"Response code is not okay.", (int)200, (int)resp.getResponseCode());
        String body = resp.getText();
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            LOG.error("Can't parse this body to JSON: \"" + body + '\"');
            throw e;
        }
        return json;
    }

    private static StringBuffer getUrl(String sessionId, String action, String hostname) {
        StringBuffer url = new StringBuffer("http://");
        url.append(hostname);
        url.append("/ajax/infostore?session=");
        url.append(sessionId);
        url.append("&action=");
        url.append(action);
        return url;
    }

    private static JSONObject allInfostoreItems(WebConversation webConv, String hostname, String sessionId, int folderId, int[] columns) throws MalformedURLException, JSONException, IOException, SAXException {
        JSONObject json;
        StringBuffer url = BundleTestCache.getUrl(sessionId, "all", hostname);
        url.append("&folder=");
        url.append(folderId);
        url.append("&columns=");
        for (int col : columns) {
            url.append(col);
            url.append(',');
        }
        url.deleteCharAt(url.length() - 1);
        GetMethodWebRequest m = new GetMethodWebRequest(url.toString());
        WebResponse resp = webConv.getResponse((WebRequest)m);
        BundleTestCache.assertEquals((String)"Response code is not okay.", (int)200, (int)resp.getResponseCode());
        String body = resp.getText();
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            LOG.error("Can't parse this body to JSON: \"" + body + '\"');
            throw e;
        }
        return json;
    }

    @Override
    protected String getBundleName() {
        return BUNDLE_ID;
    }
}

