/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.rmi.filestore;

import com.openexchange.admin.rmi.OXContextInterface;
import com.openexchange.admin.rmi.OXUserInterface;
import com.openexchange.admin.rmi.OXUtilInterface;
import com.openexchange.admin.rmi.dataobjects.Context;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.dataobjects.Filestore;
import com.openexchange.admin.rmi.dataobjects.User;
import java.io.File;
import java.rmi.Naming;
import java.util.HashSet;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestBug41727 {
    private static final String RMI_HOST = "rmi://localhost:1099/";
    private Filestore filestore;
    private Context context;

    @After
    public void Cleanup() {
        try {
            long start;
            if (this.context != null && this.context.getId() > 0) {
                OXContextInterface oxctx = (OXContextInterface)Naming.lookup("rmi://localhost:1099/OXContext_V2");
                start = System.currentTimeMillis();
                oxctx.delete(this.context, this.getMasterCredentials());
                System.out.println("Context '" + this.context.getId() + "' was successfully deleted in " + (System.currentTimeMillis() - start) + " msec.");
            }
            if (this.filestore != null) {
                OXUtilInterface oxutil = (OXUtilInterface)Naming.lookup("rmi://localhost:1099/OXUtil_V2");
                start = System.currentTimeMillis();
                oxutil.unregisterFilestore(this.filestore, this.getMasterCredentials());
                System.out.println("Filestore '" + this.filestore.getId() + "' was successfully unregistered in " + (System.currentTimeMillis() - start) + " msec.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unable to delete context with identifier '" + this.context.getId() + "' : " + e.getMessage()));
        }
    }

    @Test
    public void testBug41727() {
        this.context = new Context();
        HashSet<String> set = new HashSet<String>();
        set.add("bug41727");
        this.context.setLoginMappings(set);
        this.context.setMaxQuota(Long.valueOf(1000000L));
        OXContextInterface oxctx = null;
        try {
            oxctx = (OXContextInterface)Naming.lookup("rmi://localhost:1099/OXContext_V2");
            long start = System.currentTimeMillis();
            this.context = oxctx.create(this.context, this.getContextAdmin(), this.getMasterCredentials());
            System.out.println("Context '" + this.context.getId() + "' was successfully created in " + (System.currentTimeMillis() - start) + " msec.");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unable to create context: " + e.getMessage()));
        }
        User someUser = null;
        User masterUser = null;
        OXUserInterface oxuser = null;
        try {
            oxuser = (OXUserInterface)Naming.lookup("rmi://localhost:1099/OXUser_V2");
            long start = System.currentTimeMillis();
            someUser = oxuser.create(this.context, this.createUser(), this.getContextAdminCredentials());
            System.out.println("User A '" + someUser.getImapLogin() + "' was successfully created in " + (System.currentTimeMillis() - start) + " msec.");
            start = System.currentTimeMillis();
            masterUser = oxuser.create(this.context, this.createUser(), this.getContextAdminCredentials());
            System.out.println("Master user '" + masterUser.getImapLogin() + "' was successfully created in " + (System.currentTimeMillis() - start) + " msec.");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unable to create users: " + e.getMessage()));
        }
        File path = new File("/tmp/bug41727");
        if (!path.exists() && path.getParentFile().canWrite()) {
            File masterFilestore;
            path.deleteOnExit();
            boolean created = path.mkdir();
            if (!created) {
                Assert.fail((String)("Unable to create physical filestore '" + path.getAbsolutePath() + "'."));
            }
            System.out.println("Created physical filestore under '" + path.getAbsolutePath() + "'");
            File userFilestore = new File("/tmp/bug41727/" + this.context.getId() + "_ctx_" + someUser.getId() + "_user_store");
            created = userFilestore.mkdir();
            if (!created) {
                Assert.fail((String)("Unable to create physical filestore '" + path.getAbsolutePath() + "' for user '" + someUser.getId() + "'"));
            }
            if (!(created = (masterFilestore = new File("/tmp/bug41727/" + this.context.getId() + "_ctx_" + masterUser.getId() + "_user_store")).mkdir())) {
                Assert.fail((String)("Unable to create physical filestore '" + path.getAbsolutePath() + "' for master user '" + masterUser.getId() + "'"));
            }
        }
        try {
            OXUtilInterface oxutil = (OXUtilInterface)Naming.lookup("rmi://localhost:1099/OXUtil_V2");
            long start = System.currentTimeMillis();
            this.filestore = oxutil.registerFilestore(this.getFilestore(path.getAbsolutePath()), this.getMasterCredentials());
            System.out.println("Filestore '" + this.filestore.getId() + "' was successfully registered in " + (System.currentTimeMillis() - start) + " msec.");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unable to register filestore: " + e.getMessage()));
        }
        try {
            long start = System.currentTimeMillis();
            oxuser.moveFromContextToUserFilestore(this.context, someUser, this.filestore, 500000L, this.getContextAdminCredentials());
            System.out.println("Moved user '" + someUser.getId() + "' to filestore '" + this.filestore.getId() + "' in " + (System.currentTimeMillis() - start) + " msec.");
            start = System.currentTimeMillis();
            oxuser.moveFromContextToUserFilestore(this.context, masterUser, this.filestore, 500000L, this.getContextAdminCredentials());
            System.out.println("Moved master user '" + masterUser.getId() + "' to filestore '" + this.filestore.getId() + "' in " + (System.currentTimeMillis() - start) + " msec.");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unable to move users from context to user filestores: " + e.getMessage()));
        }
        try {
            long start = System.currentTimeMillis();
            oxuser.moveFromUserFilestoreToMaster(this.context, someUser, masterUser, this.getContextAdminCredentials());
            System.out.println("Moved user '" + someUser.getId() + "' to filestore '" + this.filestore.getId() + "' of master user '" + masterUser.getId() + "' in " + (System.currentTimeMillis() - start) + " msec.");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unable to move user's filestore to master user's filestore: " + e.getMessage()));
        }
        try {
            long start = System.currentTimeMillis();
            oxuser.delete(this.context, masterUser, null, this.getContextAdminCredentials());
            System.out.println("Deleted master user '" + masterUser.getId() + "' in " + (System.currentTimeMillis() - start) + " msec.");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unable to delete master user '" + masterUser.getId() + "'"));
        }
        try {
            long start = System.currentTimeMillis();
            oxuser.delete(this.context, someUser, null, this.getContextAdminCredentials());
            System.out.println("Deleted user '" + someUser.getId() + "' in " + (System.currentTimeMillis() - start) + " msec.");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unable to delete user '" + someUser.getId() + "'"));
        }
    }

    private Credentials getContextAdminCredentials() {
        return new Credentials("oxadmin", "secret");
    }

    private Filestore getFilestore(String path) {
        Filestore filestore = new Filestore();
        filestore.setMaxContexts(Integer.valueOf(1000));
        filestore.setSize(Long.valueOf(1000000L));
        filestore.setUrl("file:" + path);
        return filestore;
    }

    private User createUser() {
        UUID random = UUID.randomUUID();
        User oxuser = new User();
        oxuser.setName(random.toString());
        oxuser.setDisplay_name("oxuser" + random);
        oxuser.setGiven_name("oxuser" + random);
        oxuser.setSur_name("oxuser" + random);
        oxuser.setPrimaryEmail("oxuser" + random + "@example.com");
        oxuser.setEmail1("oxuser" + random + "@example.com");
        oxuser.setPassword("secret");
        oxuser.setImapServer("dovecot.devel.open-xchange.com");
        oxuser.setImapLogin(random + "@" + random);
        return oxuser;
    }

    private Credentials getMasterCredentials() {
        Credentials credentials = new Credentials();
        credentials.setLogin("oxadminmaster");
        credentials.setPassword("secret");
        return credentials;
    }

    private User getContextAdmin() {
        User oxadmin = new User();
        oxadmin.setName("oxadmin");
        oxadmin.setDisplay_name("oxadmin");
        oxadmin.setGiven_name("oxadmin");
        oxadmin.setSur_name("oxadmin");
        oxadmin.setPrimaryEmail("oxadmin@example.com");
        oxadmin.setEmail1("oxadmin@example.com");
        oxadmin.setPassword("secret");
        return oxadmin;
    }
}

