/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure;

import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.structure.StructureHandler;
import com.openexchange.mail.structure.StructureMailMessageParser;
import com.openexchange.mail.structure.handler.MIMEStructureHandler;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MailNestedMessageStructureTest
extends AbstractMailTest {
    private static final byte[] MP_NESTED_MESSAGE = "Date: Sat, 14 Nov 2009 17:34:32 +0100 (CET)\nFrom: alice@foobar.com\nTo: bob@foobar.com\nMessage-ID: <1043855276.4621.1258216472739.JavaMail.foobar@foobar.com>\nSubject: Mail subject\nMIME-Version: 1.0\nContent-Type: multipart/mixed; boundary=\"----=_Part_4619_202988661.1258216472662\"\nX-Priority: 3\n\n------=_Part_4619_202988661.1258216472662\nContent-Type: multipart/alternative;  boundary=\"----=_Part_4620_1426393991.1258216472662\"\n\n------=_Part_4620_1426393991.1258216472662\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 7bit\n\nSome text here.\n\n------=_Part_4620_1426393991.1258216472662\nMIME-Version: 1.0\nContent-Type: text/html; charset=UTF-8\nContent-Transfer-Encoding: 7bit\n\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n  <head>\n    <meta content=\"text/html; charset=UTF-8\" http-equiv=\"Content-Type\" />\n    <title></title>\n  </head>\n\n  <body>\n    <p style=\"margin: 0px;\">Some text here.<span></span></p>\n\n    <p style=\"margin: 0px;\">&#160;</p>\n  </body>\n</html>\n\n------=_Part_4620_1426393991.1258216472662--\n\n------=_Part_4619_202988661.1258216472662\nContent-Type: message/rfc822; name=simple.eml\nContent-Transfer-Encoding: 7bit\nContent-Disposition: INLINE; filename=simple.eml\n\nDate: Sat, 14 Nov 2009 17:03:09 +0100 (CET)\nFrom: alice@foobar.com\nTo: bob@foobar.com\nMessage-ID: <1837640730.5.1258214590077.JavaMail.foobar@foobar>\nSubject: Simple mail subject\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nX-Priority: 3\n\nMail text.\n\nPeople have been asking for support for the IMAP IDLE command for quite\na few years and I think I've finally figured out how to provide such\nsupport safely. The difficulty isn't in executing the command, which\nis quite straightforward, the difficulty is in deciding how to expose\nit to applications, and inhandling the multithreading issues that\narise.\n\n------=_Part_4619_202988661.1258216472662--\n".getBytes();

    public MailNestedMessageStructureTest() {
    }

    public MailNestedMessageStructureTest(String name) {
        super(name);
    }

    public void testMIMEStructure() {
        try {
            this.getSession();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])MP_NESTED_MESSAGE);
            MIMEStructureHandler handler = new MIMEStructureHandler(-1L);
            new StructureMailMessageParser().parseMailMessage(mail, (StructureHandler)handler);
            JSONObject jsonMailObject = handler.getJSONMailObject();
            MailNestedMessageStructureTest.assertNotNull((String)"Structured JSON mail object is null.", (Object)jsonMailObject);
            Object bodyObject = jsonMailObject.opt("body");
            MailNestedMessageStructureTest.assertNotNull((String)"Missing mail body.", (Object)bodyObject);
            MailNestedMessageStructureTest.assertTrue((String)"Body object is not a JSON array.", (boolean)(bodyObject instanceof JSONArray));
            JSONArray bodyArray = (JSONArray)bodyObject;
            int length = bodyArray.length();
            MailNestedMessageStructureTest.assertEquals((String)"Expected two body parts.", (int)2, (int)length);
            for (int i = 0; i < length; ++i) {
                JSONObject bodyPartObject = bodyArray.getJSONObject(i);
                JSONObject contentType = bodyPartObject.getJSONObject("headers").getJSONObject("content-type");
                if (0 == i) {
                    MailNestedMessageStructureTest.assertTrue((String)"First body part is not multipart/alternative.", (boolean)contentType.getString("type").startsWith("multipart/alternative"));
                    MailNestedMessageStructureTest.checkMultipartAlternative(bodyPartObject);
                    continue;
                }
                MailNestedMessageStructureTest.assertTrue((String)"Second body part is not message/rfc822.", (boolean)contentType.getString("type").startsWith("message/rfc822"));
                MailNestedMessageStructureTest.checkNestedMessage(bodyPartObject.getJSONObject("body"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailNestedMessageStructureTest.fail((String)e.getMessage());
        }
    }

    private static void checkNestedMessage(JSONObject nestedMessageObject) throws JSONException {
        Object bodyObject = nestedMessageObject.opt("body");
        MailNestedMessageStructureTest.assertNotNull((String)"Missing mail body in nested message.", (Object)bodyObject);
        MailNestedMessageStructureTest.assertTrue((String)"Nested message's body object is not a JSON object.", (boolean)(bodyObject instanceof JSONObject));
        JSONObject jsonBodyObject = (JSONObject)bodyObject;
        String id = jsonBodyObject.getString("id");
        MailNestedMessageStructureTest.assertEquals((String)"Wring part ID.", (String)"2.1", (String)id);
    }

    private static void checkMultipartAlternative(JSONObject multipartAlternativeObject) throws JSONException {
        Object bodyObject = multipartAlternativeObject.opt("body");
        MailNestedMessageStructureTest.assertNotNull((String)"Missing mail body.", (Object)bodyObject);
        MailNestedMessageStructureTest.assertTrue((String)"Body object is not a JSON array.", (boolean)(bodyObject instanceof JSONArray));
        JSONArray bodyArray = (JSONArray)bodyObject;
        int length = bodyArray.length();
        MailNestedMessageStructureTest.assertEquals((String)"Expected two body parts.", (int)2, (int)length);
        for (int i = 0; i < length; ++i) {
            JSONObject bodyPartObject = bodyArray.getJSONObject(i);
            JSONObject contentType = bodyPartObject.getJSONObject("headers").getJSONObject("content-type");
            if (0 == i) {
                MailNestedMessageStructureTest.assertTrue((String)"First body part is not plain text.", (boolean)contentType.getString("type").startsWith("text/plain"));
                continue;
            }
            MailNestedMessageStructureTest.assertTrue((String)"Second body part is not HTML.", (boolean)contentType.getString("type").startsWith("text/htm"));
        }
    }
}

