/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure;

import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.structure.StructureHandler;
import com.openexchange.mail.structure.StructureMailMessageParser;
import com.openexchange.mail.structure.handler.MIMEStructureHandler;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MailMultipartMixedStructureTest
extends AbstractMailTest {
    private static final byte[] MP_MIXED = "Date: Sat, 14 Nov 2009 17:34:32 +0100 (CET)\nFrom: alice@foobar.com\nTo: bob@foobar.com\nMessage-ID: <1043855276.4621.1258216472739.JavaMail.foobar@foobar.com>\nSubject: Mail subject\nMIME-Version: 1.0\nContent-Type: multipart/mixed; boundary=\"----=_Part_4619_202988661.1258216472662\"\nX-Priority: 3\n\n------=_Part_4619_202988661.1258216472662\nContent-Type: multipart/alternative;  boundary=\"----=_Part_4620_1426393991.1258216472662\"\n\n------=_Part_4620_1426393991.1258216472662\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 7bit\n\nSome text here.\n\n------=_Part_4620_1426393991.1258216472662\nMIME-Version: 1.0\nContent-Type: text/html; charset=UTF-8\nContent-Transfer-Encoding: 7bit\n\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n  <head>\n    <meta content=\"text/html; charset=UTF-8\" http-equiv=\"Content-Type\" />\n    <title></title>\n  </head>\n\n  <body>\n    <p style=\"margin: 0px;\">Some text here.<span></span></p>\n\n    <p style=\"margin: 0px;\">&#160;</p>\n  </body>\n</html>\n\n------=_Part_4620_1426393991.1258216472662--\n\n------=_Part_4619_202988661.1258216472662\nContent-Type: text/plain; charset=US-ASCII; name=mobile-rewrite.txt\nContent-Transfer-Encoding: base64\nContent-Disposition: ATTACHMENT; filename=mobile-rewrite.txt\n\nIyBSZXdyaXRlIHJ1bGUgZm9yIG1vYmlsZSBkZXZpY2VzCjxJZk1vZHVsZSBtb2RfcmV3cml0ZS5j\nPgogIFJld3JpdGVFbmdpbmUgb24KICBSZXdyaXRlQ29uZCAle0hUVFBfVVNFUl9BR0VOVH0gXi4q\naVBob25lLiokIFtOQyxPUl0KICBSZXdyaXRlQ29uZCAle0hUVFBfVVNFUl9BR0VOVH0gXi4qQW5k\ncm9pZC4qJCBbTkMsT1JdCiAgUmV3cml0ZUNvbmQgJXtIVFRQX1VTRVJfQUdFTlR9IF4uKkJsYWNr\nQmVycnkuKiQgW05DLE9SXQogIFJld3JpdGVDb25kICV7SFRUUF9VU0VSX0FHRU5UfSAnXi4qV2lu\nZG93cyBDRS4qJCcgW05DLE9SXQogIFJld3JpdGVDb25kICV7SFRUUF9VU0VSX0FHRU5UfSBeLipz\neW1iaWFuLiokIFtOQyxPUl0KICBSZXdyaXRlQ29uZCAle0hUVFBfVVNFUl9BR0VOVH0gXi4qU21h\ncnRwaG9uZS4qJAogIFJld3JpdGVDb25kICV7SFRUUF9VU0VSX0FHRU5UfSAuKk1vYmlsZS4qU2Fm\nYXJpIFtOQ10KCiAgIyBObyByZXdyaXRlIGZvciBtb2JpbGUgYW5kIGFqYXgKICBSZXdyaXRlQ29u\nZCAle1JFUVVFU1RfVVJJfSAhXi9tb2JpbGUvCiAgUmV3cml0ZUNvbmQgJXtSRVFVRVNUX1VSSX0g\nIV4vYWpheC8KCiAgIyBSZWRpcmVjdCB0byBtb2JpbGUgc2l0ZQogIFJld3JpdGVSdWxlIF4oLiop\nJCAvbW9iaWxlLyQxIFtSXQo8L0lmTW9kdWxlPg==\n------=_Part_4619_202988661.1258216472662--\n".getBytes();

    public MailMultipartMixedStructureTest() {
    }

    public MailMultipartMixedStructureTest(String name) {
        super(name);
    }

    public void testMIMEStructure() {
        try {
            this.getSession();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])MP_MIXED);
            MIMEStructureHandler handler = new MIMEStructureHandler(-1L);
            new StructureMailMessageParser().parseMailMessage(mail, (StructureHandler)handler);
            JSONObject jsonMailObject = handler.getJSONMailObject();
            MailMultipartMixedStructureTest.assertNotNull((String)"Structured JSON mail object is null.", (Object)jsonMailObject);
            Object bodyObject = jsonMailObject.opt("body");
            MailMultipartMixedStructureTest.assertNotNull((String)"Missing mail body.", (Object)bodyObject);
            MailMultipartMixedStructureTest.assertTrue((String)"Body object is not a JSON array.", (boolean)(bodyObject instanceof JSONArray));
            JSONArray bodyArray = (JSONArray)bodyObject;
            int length = bodyArray.length();
            MailMultipartMixedStructureTest.assertEquals((String)"Expected two body parts.", (int)2, (int)length);
            for (int i = 0; i < length; ++i) {
                JSONObject bodyPartObject = bodyArray.getJSONObject(i);
                JSONObject contentType = bodyPartObject.getJSONObject("headers").getJSONObject("content-type");
                if (0 == i) {
                    MailMultipartMixedStructureTest.assertTrue((String)"First body part is not multipart/alternative.", (boolean)contentType.getString("type").startsWith("multipart/alternative"));
                    MailMultipartMixedStructureTest.checkMultipartAlternative(bodyPartObject);
                    continue;
                }
                MailMultipartMixedStructureTest.assertTrue((String)"Second body part is no text.", (boolean)contentType.getString("type").startsWith("text/"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailMultipartMixedStructureTest.fail((String)e.getMessage());
        }
    }

    private static void checkMultipartAlternative(JSONObject multipartAlternativeObject) throws JSONException {
        Object bodyObject = multipartAlternativeObject.opt("body");
        MailMultipartMixedStructureTest.assertNotNull((String)"Missing mail body.", (Object)bodyObject);
        MailMultipartMixedStructureTest.assertTrue((String)"Body object is not a JSON array.", (boolean)(bodyObject instanceof JSONArray));
        JSONArray bodyArray = (JSONArray)bodyObject;
        int length = bodyArray.length();
        MailMultipartMixedStructureTest.assertEquals((String)"Expected two body parts.", (int)2, (int)length);
        for (int i = 0; i < length; ++i) {
            JSONObject bodyPartObject = bodyArray.getJSONObject(i);
            JSONObject contentType = bodyPartObject.getJSONObject("headers").getJSONObject("content-type");
            if (0 == i) {
                MailMultipartMixedStructureTest.assertTrue((String)"First body part is not plain text.", (boolean)contentType.getString("type").startsWith("text/plain"));
                continue;
            }
            MailMultipartMixedStructureTest.assertTrue((String)"Second body part is not HTML.", (boolean)contentType.getString("type").startsWith("text/htm"));
        }
    }
}

