/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import java.util.List;
import java.util.Map;
import net.sourceforge.cardme.vcard.types.ExtendedType;
import org.junit.Assert;
import org.junit.Test;

public class Bug30449Test
extends CardDAVTest {
    @Test
    public void testDontIncludeX_OPEN_XCHANGE_CTYPE() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String folderName = "testfolder_" + Bug30449Test.randomUID();
        FolderObject subFolder = super.createFolder(folderName);
        super.rememberForCleanUp(subFolder);
        String uid = Bug30449Test.randomUID();
        String firstName = "gerd";
        String lastName = "gurke";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact, subFolder.getObjectID()));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource contactCard = Bug30449Test.assertContains(uid, addressData);
        List<ExtendedType> extendedTypes = contactCard.getExtendedTypes("X-OPEN-XCHANGE-CTYPE");
        Assert.assertTrue((String)"X-OPEN-XCHANGE-CTYPE found", (null == extendedTypes || 0 == extendedTypes.size() ? 1 : 0) != 0);
    }
}

