/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.groupware.container.Contact;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Bug21235Test
extends CardDAVTest {
    @Before
    public void setUserAgent() throws Exception {
        super.getWebDAVClient().setUserAgent("Address%20Book/883 CFNetwork/454.12.4 Darwin/10.8.0 (i386)");
    }

    @Test
    public void testUpdateContact() throws Exception {
        String uid = Bug21235Test.randomUID() + "-ABSPlugin";
        String pathUid = Bug21235Test.randomUID() + "-ABSPlugin";
        String firstName = "test";
        String lastName = "heinz";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:heinz;test;;;\r\nFN:test heinz\r\nCATEGORIES:Kontakte\r\nX-ABUID:A33920F3-656F-47B7-A335-2C603DA3F324\\:ABPerson\r\nUID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "END:VCARD" + "\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putVCard(pathUid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        Assert.assertEquals((String)"uid wrong", (Object)uid, (Object)contact.getUid());
        Assert.assertEquals((String)"firstname wrong", (Object)"test", (Object)contact.getGivenName());
        Assert.assertEquals((String)"lastname wrong", (Object)"heinz", (Object)contact.getSurName());
        String updatedFirstName = "test2";
        String updatedVCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:heinz;test2;;;\r\nFN:test2 heinz\r\nCATEGORIES:Kontakte\r\nX-ABUID:A33920F3-656F-47B7-A335-2C603DA3F324\\:ABPerson\r\nUID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "END:VCARD" + "\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putVCardUpdate(pathUid, updatedVCard));
        Contact updatedContact = super.getContact(uid);
        Assert.assertEquals((String)"uid wrong", (Object)uid, (Object)updatedContact.getUid());
        Assert.assertEquals((String)"firstname wrong", (Object)"test2", (Object)updatedContact.getGivenName());
        Assert.assertEquals((String)"lastname wrong", (Object)"heinz", (Object)updatedContact.getSurName());
    }
}

