/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.tests;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;

public class AlarmTestMacCalendar
extends CalDAVTest {
    @Test
    public void testAcknowledgeReminder() throws Exception {
        String uid = AlarmTestMacCalendar.randomUID();
        Date start = TimeTools.D("next sunday at 16:00");
        Date end = TimeTools.D("next sunday at 17:00");
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "SEQUENCE:2\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:ack\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "UID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "TRIGGER:-PT15M\r\n" + "DESCRIPTION:Ereignisbenachrichtigung\r\n" + "ACTION:DISPLAY\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "UID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Date initialAcknowledged = TimeTools.D("next sunday at 15:44");
        Date acknowledgedDate = TimeTools.D("next sunday at 15:47:32");
        iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "SEQUENCE:2\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:ack\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "UID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "TRIGGER:-PT15M\r\n" + "DESCRIPTION:Alarm\r\n" + "ACTION:DISPLAY\r\n" + "X-MOZ-LASTACK:" + AlarmTestMacCalendar.formatAsUTC(initialAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestMacCalendar.formatAsUTC(acknowledgedDate) + "\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "UID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertFalse((String)"reminder still found", (boolean)appointment.containsAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        AlarmTestMacCalendar.assertDummyAlarm(iCalResource.getVEvent());
    }

    @Test
    public void testSnoozeReminder() throws Exception {
        String uid = AlarmTestMacCalendar.randomUID();
        String relatedUID = AlarmTestMacCalendar.randomUID();
        Date start = TimeTools.D("next sunday at 16:00");
        Date end = TimeTools.D("next sunday at 17:00");
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "SEQUENCE:2\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:ack\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "UID:" + relatedUID + "\r\n" + "TRIGGER:-PT15M\r\n" + "DESCRIPTION:Ereignisbenachrichtigung\r\n" + "ACTION:DISPLAY\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "UID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Date initialAcknowledged = TimeTools.D("next sunday at 15:44");
        Date acknowledgedDate = TimeTools.D("next sunday at 15:47:32");
        Date nextTrigger = TimeTools.D("next sunday at 15:52:32");
        iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "SEQUENCE:2\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:ack\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "UID:" + relatedUID + "\r\n" + "TRIGGER:-PT15M\r\n" + "DESCRIPTION:Alarm\r\n" + "ACTION:DISPLAY\r\n" + "X-MOZ-LASTACK:" + AlarmTestMacCalendar.formatAsUTC(initialAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestMacCalendar.formatAsUTC(acknowledgedDate) + "\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "UID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "TRIGGER;VALUE=DATE-TIME:" + AlarmTestMacCalendar.formatAsUTC(nextTrigger) + "\r\n" + "DESCRIPTION:Alarm\r\n" + "RELATED-TO:" + relatedUID + "\r\n" + "ACTION:DISPLAY\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "UID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        List<SimpleICal.Component> vAlarms = iCalResource.getVEvent().getVAlarms();
        Assert.assertEquals((String)"Unexpected number of VALARMs found", (long)2L, (long)vAlarms.size());
        for (SimpleICal.Component vAlarm : vAlarms) {
            if (null != vAlarm.getProperty("RELATED-TO")) {
                Assert.assertEquals((String)"ALARM wrong", (Object)AlarmTestMacCalendar.formatAsUTC(nextTrigger), (Object)vAlarm.getPropertyValue("TRIGGER"));
                continue;
            }
            Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)vAlarm.getPropertyValue("TRIGGER"));
        }
    }

    @Test
    public void testEditReminder() throws Exception {
        String uid = AlarmTestMacCalendar.randomUID();
        Date start = TimeTools.D("next sunday at 16:00");
        Date end = TimeTools.D("next sunday at 17:00");
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "SEQUENCE:2\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:ack\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "UID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "TRIGGER:-PT15M\r\n" + "DESCRIPTION:Ereignisbenachrichtigung\r\n" + "ACTION:DISPLAY\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "UID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Date initialAcknowledged = TimeTools.D("next sunday at 15:44");
        iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "SEQUENCE:2\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:ack\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "BEGIN:VALARM\r\n" + "X-MOZ-LASTACK:" + AlarmTestMacCalendar.formatAsUTC(initialAcknowledged) + "\r\n" + "X-WR-ALARMUID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "UID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "TRIGGER:-PT20M\r\n" + "DESCRIPTION:Alarm\r\n" + "ACTION:DISPLAY\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "UID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)20L, (long)appointment.getAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT20M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
    }

    @Test
    public void testAcknowledgeRecurringReminder() throws Exception {
        String uid = AlarmTestMacCalendar.randomUID();
        Date start = TimeTools.D("next saturday at 15:30");
        Date end = TimeTools.D("next saturday at 17:15");
        Date initialAcknowledged = TimeTools.D("next saturday at 15:14");
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:RecurringReminder\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "RRULE:FREQ=DAILY;INTERVAL=1\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:7B669A77-E205-4B03-A1AF-40FB146C4A3F\r\n" + "UID:7B669A77-E205-4B03-A1AF-40FB146C4A3F\r\n" + "TRIGGER:-PT15M\r\n" + "DESCRIPTION:Ereignisbenachrichtigung\r\n" + "ACTION:DISPLAY\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "UID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        calendar.setTime(initialAcknowledged);
        calendar.add(5, 1);
        Date nextAcknowledged = calendar.getTime();
        calendar.setTime(initialAcknowledged);
        calendar.add(12, 3);
        calendar.add(13, 17);
        Date acknowledgedDate = calendar.getTime();
        iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:RecurringReminder\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "RRULE:FREQ=DAILY;INTERVAL=1\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "UID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "X-MOZ-LASTACK:" + AlarmTestMacCalendar.formatAsUTC(initialAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestMacCalendar.formatAsUTC(acknowledgedDate) + "\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "UID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestMacCalendar.formatAsUTC(nextAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("ACKNOWLEDGED"));
    }

    public void noTestSnoozeRecurringReminder() throws Exception {
        String uid = AlarmTestMacCalendar.randomUID();
        Date start = TimeTools.D("next saturday at 15:30");
        Date end = TimeTools.D("next saturday at 17:15");
        Date initialAcknowledged = TimeTools.D("next saturday at 15:14");
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:RecurringReminder\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "RRULE:FREQ=DAILY;INTERVAL=1\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:7B669A77-E205-4B03-A1AF-40FB146C4A3F\r\n" + "UID:7B669A77-E205-4B03-A1AF-40FB146C4A3F\r\n" + "TRIGGER:-PT15M\r\n" + "DESCRIPTION:Ereignisbenachrichtigung\r\n" + "ACTION:DISPLAY\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "UID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        calendar.setTime(start);
        calendar.add(5, 2);
        Date exceptionStart = calendar.getTime();
        calendar.setTime(end);
        calendar.add(5, 2);
        Date exceptionEnd = calendar.getTime();
        calendar.setTime(exceptionStart);
        calendar.add(12, -14);
        calendar.add(13, 17);
        Date acknowledgedDate = calendar.getTime();
        calendar.add(12, 5);
        Date nextTrigger = calendar.getTime();
        String relatedUID = AlarmTestMacCalendar.randomUID();
        iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:RecurringReminder\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "RRULE:FREQ=DAILY;INTERVAL=1\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "UID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "X-MOZ-LASTACK:" + AlarmTestMacCalendar.formatAsUTC(initialAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestMacCalendar.formatAsUTC(acknowledgedDate) + "\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "UID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(exceptionStart, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:RecurringReminder\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "RECURRENCE-ID:" + AlarmTestMacCalendar.formatAsUTC(exceptionStart) + "\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "UID:" + relatedUID + "\r\n" + "TRIGGER:-PT15M\r\n" + "DESCRIPTION:Alarm\r\n" + "ACTION:DISPLAY\r\n" + "ACKNOWLEDGED:" + AlarmTestMacCalendar.formatAsUTC(acknowledgedDate) + "\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "UID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "TRIGGER;VALUE=DATE-TIME:" + AlarmTestMacCalendar.formatAsUTC(nextTrigger) + "\r\n" + "DESCRIPTION:Alarm\r\n" + "RELATED-TO:" + relatedUID + "\r\n" + "ACTION:DISPLAY\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "UID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        Assert.assertNotNull((String)"No change exceptions found on server", (Object)appointment.getChangeException());
        Assert.assertEquals((String)"Unexpected number of change excpetions", (long)1L, (long)appointment.getChangeException().length);
        Appointment changeExcpetion = this.getChangeExcpetions(appointment).get(0);
        this.rememberForCleanUp(changeExcpetion);
        Assert.assertTrue((String)"no reminder found", (boolean)changeExcpetion.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)changeExcpetion.getAlarm());
        calendar.setTime(exceptionStart);
        calendar.add(5, 1);
        calendar.add(12, -16);
        Date seriesAcknowledged = calendar.getTime();
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestMacCalendar.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("ACKNOWLEDGED"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestMacCalendar.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("X-MOZ-LASTACK"));
        Assert.assertEquals((String)"Not all VEVENTs in iCal found", (long)2L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvents().get(1).getUID());
        List<SimpleICal.Component> vAlarms = iCalResource.getVEvents().get(1).getVAlarms();
        Assert.assertEquals((String)"Unexpected number of VALARMs found", (long)2L, (long)vAlarms.size());
        for (SimpleICal.Component vAlarm : vAlarms) {
            if (null != vAlarm.getProperty("RELATED-TO")) {
                Assert.assertEquals((String)"ALARM wrong", (Object)AlarmTestMacCalendar.formatAsUTC(nextTrigger), (Object)vAlarm.getPropertyValue("TRIGGER"));
                continue;
            }
            Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)vAlarm.getPropertyValue("TRIGGER"));
        }
    }

    @Test
    public void testSnoozeRecurringReminder() throws Exception {
        String uid = AlarmTestMacCalendar.randomUID();
        Date start = TimeTools.D("next saturday at 15:30");
        Date end = TimeTools.D("next saturday at 17:15");
        Date initialAcknowledged = TimeTools.D("next saturday at 15:14");
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:RecurringReminder\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "RRULE:FREQ=DAILY;INTERVAL=1\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:7B669A77-E205-4B03-A1AF-40FB146C4A3F\r\n" + "UID:7B669A77-E205-4B03-A1AF-40FB146C4A3F\r\n" + "TRIGGER:-PT15M\r\n" + "DESCRIPTION:Ereignisbenachrichtigung\r\n" + "ACTION:DISPLAY\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "UID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        calendar.setTime(start);
        calendar.add(5, 2);
        Date exceptionStart = calendar.getTime();
        calendar.setTime(end);
        calendar.add(5, 2);
        Date exceptionEnd = calendar.getTime();
        calendar.setTime(exceptionStart);
        calendar.add(12, -14);
        calendar.add(13, 17);
        Date acknowledgedDate = calendar.getTime();
        calendar.add(12, 5);
        Date nextTrigger = calendar.getTime();
        calendar.add(12, -1);
        Date nextAcknowledged = calendar.getTime();
        String relatedUID = AlarmTestMacCalendar.randomUID();
        iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:RecurringReminder\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "RRULE:FREQ=DAILY;INTERVAL=1\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "UID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "X-MOZ-LASTACK:" + AlarmTestMacCalendar.formatAsUTC(initialAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestMacCalendar.formatAsUTC(acknowledgedDate) + "\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "UID:56C5C265-7442-44E6-8F9C-17C71DCF932A\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(exceptionStart, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:RecurringReminder\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "RECURRENCE-ID:" + AlarmTestMacCalendar.formatAsUTC(exceptionStart) + "\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "UID:" + relatedUID + "\r\n" + "TRIGGER:-PT15M\r\n" + "DESCRIPTION:Alarm\r\n" + "ACTION:DISPLAY\r\n" + "ACKNOWLEDGED:" + AlarmTestMacCalendar.formatAsUTC(acknowledgedDate) + "\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "UID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "TRIGGER;VALUE=DATE-TIME:" + AlarmTestMacCalendar.formatAsUTC(nextTrigger) + "\r\n" + "DESCRIPTION:Alarm\r\n" + "RELATED-TO:" + relatedUID + "\r\n" + "ACTION:DISPLAY\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "UID:" + AlarmTestMacCalendar.randomUID() + "\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        Assert.assertTrue((String)"change exceptions found on server", (null == appointment.getChangeException() || 0 == appointment.getChangeException().length ? 1 : 0) != 0);
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"More than one VEVENT in iCal found", (long)1L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        List<SimpleICal.Component> vAlarms = iCalResource.getVEvent().getVAlarms();
        Assert.assertEquals((String)"Unexpected number of VALARMs found", (long)2L, (long)vAlarms.size());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)vAlarms.get(0).getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestMacCalendar.formatAsUTC(nextAcknowledged), (Object)vAlarms.get(0).getPropertyValue("ACKNOWLEDGED"));
        Assert.assertNotNull((String)"No RELATED-TO found", (Object)vAlarms.get(1).getProperty("RELATED-TO"));
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT8M43S", (Object)vAlarms.get(1).getPropertyValue("TRIGGER"));
    }

    @Test
    public void testAcknowledgeExceptionReminder() throws Exception {
        String uid = AlarmTestMacCalendar.randomUID();
        Date start = TimeTools.D("next friday at 10:00");
        Date end = TimeTools.D("next friday at 11:00");
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        calendar.setTime(start);
        calendar.add(5, 2);
        Date exceptionStart = calendar.getTime();
        calendar.add(10, 1);
        Date exceptionEnd = calendar.getTime();
        calendar.setTime(exceptionStart);
        calendar.add(12, -16);
        calendar.add(5, 1);
        Date seriesAcknowledged = calendar.getTime();
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nRRULE:FREQ=DAILY;INTERVAL=1\r\nDTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "SEQUENCE:2\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:Neues Ereignis\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(start, "Europe/Berlin") + "\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:47B1F982-7DAE-4029-9FBD-88899D1577FB\r\n" + "UID:47B1F982-7DAE-4029-9FBD-88899D1577FB\r\n" + "TRIGGER:-PT15M\r\n" + "ACTION:DISPLAY\r\n" + "X-MOZ-LASTACK:" + AlarmTestMacCalendar.formatAsUTC(seriesAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestMacCalendar.formatAsUTC(seriesAcknowledged) + "\r\n" + "DESCRIPTION:Alarm\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:30C8AEDF-B12D-4DAE-8079-59A1FE218CA0\r\n" + "UID:30C8AEDF-B12D-4DAE-8079-59A1FE218CA0\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "SUMMARY:EXception\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(exceptionStart, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "SEQUENCE:3\r\n" + "RECURRENCE-ID:" + AlarmTestMacCalendar.formatAsUTC(exceptionStart) + "\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:3159E1B2-5778-41AB-B1C1-67B5514E7A9E\r\n" + "UID:3159E1B2-5778-41AB-B1C1-67B5514E7A9E\r\n" + "TRIGGER:-PT15M\r\n" + "DESCRIPTION:Alarm\r\n" + "ACTION:DISPLAY\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:4EA89B39-B283-439F-824F-194AD29DC41F\r\n" + "UID:4EA89B39-B283-439F-824F-194AD29DC41F\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        Assert.assertNotNull((String)"No change exceptions found on server", (Object)appointment.getChangeException());
        Assert.assertEquals((String)"Unexpected number of change excpetions", (long)1L, (long)appointment.getChangeException().length);
        Appointment changeExcpetion = this.getChangeExcpetions(appointment).get(0);
        this.rememberForCleanUp(changeExcpetion);
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)changeExcpetion.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestMacCalendar.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("ACKNOWLEDGED"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestMacCalendar.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("X-MOZ-LASTACK"));
        Assert.assertEquals((String)"Not all VEVENTs in iCal found", (long)2L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvents().get(1).getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)"EXception", (Object)iCalResource.getVEvents().get(1).getSummary());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvents().get(1).getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvents().get(1).getVAlarm().getPropertyValue("TRIGGER"));
        calendar.setTime(exceptionStart);
        calendar.add(12, -14);
        calendar.add(13, 52);
        Date exceptionAcknowledged = calendar.getTime();
        iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nRRULE:FREQ=DAILY;INTERVAL=1\r\nDTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "SEQUENCE:2\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:Neues Ereignis\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(start, "Europe/Berlin") + "\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:47B1F982-7DAE-4029-9FBD-88899D1577FB\r\n" + "UID:47B1F982-7DAE-4029-9FBD-88899D1577FB\r\n" + "TRIGGER:-PT15M\r\n" + "ACTION:DISPLAY\r\n" + "X-MOZ-LASTACK:" + AlarmTestMacCalendar.formatAsUTC(seriesAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestMacCalendar.formatAsUTC(seriesAcknowledged) + "\r\n" + "DESCRIPTION:Alarm\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:30C8AEDF-B12D-4DAE-8079-59A1FE218CA0\r\n" + "UID:30C8AEDF-B12D-4DAE-8079-59A1FE218CA0\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(exceptionStart, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:20151123T072538Z\r\n" + "SEQUENCE:2\r\n" + "CLASS:PUBLIC\r\n" + "RECURRENCE-ID:" + AlarmTestMacCalendar.formatAsUTC(exceptionStart) + "\r\n" + "SUMMARY:EXception\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:4BEE3916-2A02-463F-AA31-B9C90084F092\r\n" + "UID:4BEE3916-2A02-463F-AA31-B9C90084F092\r\n" + "TRIGGER:-PT15M\r\n" + "ACTION:DISPLAY\r\n" + "X-MOZ-LASTACK:" + AlarmTestMacCalendar.formatAsUTC(seriesAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestMacCalendar.formatAsUTC(exceptionAcknowledged) + "\r\n" + "DESCRIPTION:Alarm\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:4EA89B39-B283-439F-824F-194AD29DC41F\r\n" + "UID:4EA89B39-B283-439F-824F-194AD29DC41F\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        Assert.assertNotNull((String)"No change exceptions found on server", (Object)appointment.getChangeException());
        Assert.assertEquals((String)"Unexpected number of change excpetions", (long)1L, (long)appointment.getChangeException().length);
        changeExcpetion = this.getChangeExcpetions(appointment).get(0);
        this.rememberForCleanUp(changeExcpetion);
        Assert.assertFalse((String)"reminder still found", (boolean)changeExcpetion.containsAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestMacCalendar.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("ACKNOWLEDGED"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestMacCalendar.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("X-MOZ-LASTACK"));
        Assert.assertEquals((String)"Not all VEVENTs in iCal found", (long)2L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvents().get(1).getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)"EXception", (Object)iCalResource.getVEvents().get(1).getSummary());
        AlarmTestMacCalendar.assertDummyAlarm(iCalResource.getVEvents().get(1));
    }

    @Test
    public void testSnoozeExceptionReminder() throws Exception {
        String uid = AlarmTestMacCalendar.randomUID();
        Date start = TimeTools.D("next friday at 10:00");
        Date end = TimeTools.D("next friday at 11:00");
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        calendar.setTime(start);
        calendar.add(5, 2);
        Date exceptionStart = calendar.getTime();
        calendar.add(10, 1);
        Date exceptionEnd = calendar.getTime();
        calendar.setTime(exceptionStart);
        calendar.add(12, -16);
        calendar.add(5, 1);
        Date seriesAcknowledged = calendar.getTime();
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nRRULE:FREQ=DAILY;INTERVAL=1\r\nDTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "SEQUENCE:2\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:Neues Ereignis\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(start, "Europe/Berlin") + "\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:47B1F982-7DAE-4029-9FBD-88899D1577FB\r\n" + "UID:47B1F982-7DAE-4029-9FBD-88899D1577FB\r\n" + "TRIGGER:-PT15M\r\n" + "ACTION:DISPLAY\r\n" + "X-MOZ-LASTACK:" + AlarmTestMacCalendar.formatAsUTC(seriesAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestMacCalendar.formatAsUTC(seriesAcknowledged) + "\r\n" + "DESCRIPTION:Alarm\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:30C8AEDF-B12D-4DAE-8079-59A1FE218CA0\r\n" + "UID:30C8AEDF-B12D-4DAE-8079-59A1FE218CA0\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "SUMMARY:EXception\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(exceptionStart, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "SEQUENCE:3\r\n" + "RECURRENCE-ID:" + AlarmTestMacCalendar.formatAsUTC(exceptionStart) + "\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:3159E1B2-5778-41AB-B1C1-67B5514E7A9E\r\n" + "UID:3159E1B2-5778-41AB-B1C1-67B5514E7A9E\r\n" + "TRIGGER:-PT15M\r\n" + "DESCRIPTION:Alarm\r\n" + "ACTION:DISPLAY\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:4EA89B39-B283-439F-824F-194AD29DC41F\r\n" + "UID:4EA89B39-B283-439F-824F-194AD29DC41F\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        Assert.assertNotNull((String)"No change exceptions found on server", (Object)appointment.getChangeException());
        Assert.assertEquals((String)"Unexpected number of change excpetions", (long)1L, (long)appointment.getChangeException().length);
        Appointment changeExcpetion = this.getChangeExcpetions(appointment).get(0);
        this.rememberForCleanUp(changeExcpetion);
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)changeExcpetion.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestMacCalendar.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("ACKNOWLEDGED"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestMacCalendar.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("X-MOZ-LASTACK"));
        Assert.assertEquals((String)"Not all VEVENTs in iCal found", (long)2L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvents().get(1).getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)"EXception", (Object)iCalResource.getVEvents().get(1).getSummary());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvents().get(1).getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvents().get(1).getVAlarm().getPropertyValue("TRIGGER"));
        calendar.setTime(exceptionStart);
        calendar.add(12, -14);
        calendar.add(13, 52);
        Date exceptionAcknowledged = calendar.getTime();
        calendar.add(12, 5);
        Date nextTrigger = calendar.getTime();
        iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.5//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:MESZ\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:MEZ\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nRRULE:FREQ=DAILY;INTERVAL=1\r\nDTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "SEQUENCE:2\r\n" + "CLASS:PUBLIC\r\n" + "SUMMARY:Neues Ereignis\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(start, "Europe/Berlin") + "\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:47B1F982-7DAE-4029-9FBD-88899D1577FB\r\n" + "UID:47B1F982-7DAE-4029-9FBD-88899D1577FB\r\n" + "TRIGGER:-PT15M\r\n" + "ACTION:DISPLAY\r\n" + "X-MOZ-LASTACK:" + AlarmTestMacCalendar.formatAsUTC(seriesAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestMacCalendar.formatAsUTC(seriesAcknowledged) + "\r\n" + "DESCRIPTION:Alarm\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:30C8AEDF-B12D-4DAE-8079-59A1FE218CA0\r\n" + "UID:30C8AEDF-B12D-4DAE-8079-59A1FE218CA0\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "DTSTART;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(exceptionStart, "Europe/Berlin") + "\r\n" + "DTEND;TZID=Europe/Berlin:" + AlarmTestMacCalendar.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:20151123T072538Z\r\n" + "SEQUENCE:2\r\n" + "CLASS:PUBLIC\r\n" + "RECURRENCE-ID:" + AlarmTestMacCalendar.formatAsUTC(exceptionStart) + "\r\n" + "SUMMARY:EXception\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestMacCalendar.formatAsUTC(new Date()) + "\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:C5CD4D18-0448-43AB-8402-C401F0A38C8C\r\n" + "UID:C5CD4D18-0448-43AB-8402-C401F0A38C8C\r\n" + "TRIGGER;VALUE=DATE-TIME:" + AlarmTestMacCalendar.formatAsUTC(nextTrigger) + "\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "RELATED-TO:4BEE3916-2A02-463F-AA31-B9C90084F092\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:4BEE3916-2A02-463F-AA31-B9C90084F092\r\n" + "UID:4BEE3916-2A02-463F-AA31-B9C90084F092\r\n" + "TRIGGER:-PT15M\r\n" + "ACTION:DISPLAY\r\n" + "X-MOZ-LASTACK:" + AlarmTestMacCalendar.formatAsUTC(seriesAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestMacCalendar.formatAsUTC(exceptionAcknowledged) + "\r\n" + "DESCRIPTION:Alarm\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "X-WR-ALARMUID:4EA89B39-B283-439F-824F-194AD29DC41F\r\n" + "UID:4EA89B39-B283-439F-824F-194AD29DC41F\r\n" + "TRIGGER;VALUE=DATE-TIME:19760401T005545Z\r\n" + "X-APPLE-DEFAULT-ALARM:TRUE\r\n" + "ACTION:NONE\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        Assert.assertNotNull((String)"No change exceptions found on server", (Object)appointment.getChangeException());
        Assert.assertEquals((String)"Unexpected number of change excpetions", (long)1L, (long)appointment.getChangeException().length);
        changeExcpetion = this.getChangeExcpetions(appointment).get(0);
        this.rememberForCleanUp(changeExcpetion);
        Assert.assertTrue((String)"no reminder found", (boolean)changeExcpetion.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)changeExcpetion.getAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestMacCalendar.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("ACKNOWLEDGED"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestMacCalendar.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("X-MOZ-LASTACK"));
        Assert.assertEquals((String)"Not all VEVENTs in iCal found", (long)2L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvents().get(1).getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)"EXception", (Object)iCalResource.getVEvents().get(1).getSummary());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvents().get(1).getVAlarm());
        List<SimpleICal.Component> vAlarms = iCalResource.getVEvents().get(1).getVAlarms();
        Assert.assertEquals((String)"Unexpected number of VALARMs found", (long)2L, (long)vAlarms.size());
        for (SimpleICal.Component vAlarm : vAlarms) {
            if (null != vAlarm.getProperty("RELATED-TO")) {
                Assert.assertEquals((String)"ALARM wrong", (Object)AlarmTestMacCalendar.formatAsUTC(nextTrigger), (Object)vAlarm.getPropertyValue("TRIGGER"));
                continue;
            }
            Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)vAlarm.getPropertyValue("TRIGGER"));
        }
    }
}

