/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.tests;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;

public class AlarmTestEMClient
extends CalDAVTest {
    @Override
    protected String getDefaultUserAgent() {
        return "eM Client/6.0.24144.0";
    }

    @Test
    public void testAcknowledgeReminder() throws Exception {
        String uid = AlarmTestEMClient.randomUID();
        Date start = TimeTools.D("next friday at 08:00");
        Date end = TimeTools.D("next friday at 09:00");
        Date initialAcknowledged = TimeTools.D("next friday at 07:44");
        String iCal = "BEGIN:VCALENDAR\r\nPRODID:-//eM Client/6.0.23421.0\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:W. Europe Standard Time\r\nX-EM-DISPLAYNAME:(UTC+01:00) Amsterdam\\, Berlin\\, Bern\\, Rom\\, Stockholm\\, W\r\n ien\r\nBEGIN:STANDARD\r\nTZNAME:Mitteleurop\u00e4ische Zeit\r\nDTSTART:00010101T030000\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZNAME:Mitteleurop\u00e4ische Sommerzeit\r\nDTSTART:00010101T020000\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nUID:" + uid + "\r\n" + "DTSTART;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:20151116T121948Z\r\n" + "DTSTAMP:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "SUMMARY:test\r\n" + "CLASS:PUBLIC\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "X-MOZ-LASTACK:" + AlarmTestEMClient.formatAsUTC(initialAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestEMClient.formatAsUTC(initialAcknowledged) + "\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        iCal = "BEGIN:VCALENDAR\r\nPRODID:-//eM Client/6.0.23421.0\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:W. Europe Standard Time\r\nX-EM-DISPLAYNAME:(UTC+01:00) Amsterdam\\, Berlin\\, Bern\\, Rom\\, Stockholm\\, W\r\n ien\r\nBEGIN:STANDARD\r\nTZNAME:Mitteleurop\u00e4ische Zeit\r\nDTSTART:00010101T030000\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZNAME:Mitteleurop\u00e4ische Sommerzeit\r\nDTSTART:00010101T020000\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nUID:" + uid + "\r\n" + "DTSTART;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:20151116T121948Z\r\n" + "DTSTAMP:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "SUMMARY:test\r\n" + "CLASS:PUBLIC\r\n" + "BEGIN:VALARM\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Open-XChange\r\n" + "X-MOZ-LASTACK:99991231T235859Z\r\n" + "ACKNOWLEDGED:99991231T235859Z\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertFalse((String)"reminder still found", (boolean)appointment.containsAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNull((String)"ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
    }

    @Test
    public void testSnoozeReminder() throws Exception {
        String uid = AlarmTestEMClient.randomUID();
        Date start = TimeTools.D("next tuesday at 10:00");
        Date end = TimeTools.D("next tuesday at 11:00");
        Date initialAcknowledged = TimeTools.D("next tuesday at 09:44");
        String iCal = "BEGIN:VCALENDAR\r\nPRODID:-//eM Client/6.0.23421.0\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:W. Europe Standard Time\r\nX-EM-DISPLAYNAME:(UTC+01:00) Amsterdam\\, Berlin\\, Bern\\, Rom\\, Stockholm\\, W\r\n ien\r\nBEGIN:STANDARD\r\nTZNAME:Mitteleurop\u00e4ische Zeit\r\nDTSTART:00010101T030000\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZNAME:Mitteleurop\u00e4ische Sommerzeit\r\nDTSTART:00010101T020000\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nUID:" + uid + "\r\n" + "DTSTART;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:20151116T121948Z\r\n" + "DTSTAMP:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "SUMMARY:snooze\r\n" + "CLASS:PUBLIC\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "X-MOZ-LASTACK:" + AlarmTestEMClient.formatAsUTC(initialAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestEMClient.formatAsUTC(initialAcknowledged) + "\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Date nextTrigger = TimeTools.D("next tuesday at 09:51:24");
        Date nextAcknowledged = TimeTools.D("next tuesday at 09:50:24");
        iCal = "BEGIN:VCALENDAR\r\nPRODID:-//eM Client/6.0.23421.0\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:W. Europe Standard Time\r\nX-EM-DISPLAYNAME:(UTC+01:00) Amsterdam\\, Berlin\\, Bern\\, Rom\\, Stockholm\\, W\r\n ien\r\nBEGIN:STANDARD\r\nTZNAME:Mitteleurop\u00e4ische Zeit\r\nDTSTART:00010101T030000\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZNAME:Mitteleurop\u00e4ische Sommerzeit\r\nDTSTART:00010101T020000\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nUID:" + uid + "\r\n" + "DTSTART;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:20151116T121948Z\r\n" + "DTSTAMP:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "SUMMARY:snooze\r\n" + "CLASS:PUBLIC\r\n" + "X-MOZ-SNOOZE:" + AlarmTestEMClient.formatAsUTC(nextTrigger) + "\r\n" + "BEGIN:VALARM\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Open-XChange\r\n" + "X-MOZ-LASTACK:" + AlarmTestEMClient.formatAsUTC(nextAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestEMClient.formatAsUTC(nextAcknowledged) + "\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "TRIGGER;VALUE=DATE-TIME:" + AlarmTestEMClient.formatAsUTC(nextTrigger) + "\r\n" + "X-MOZ-LASTACK:" + AlarmTestEMClient.formatAsUTC(nextAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestEMClient.formatAsUTC(nextAcknowledged) + "\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        List<SimpleICal.Component> vAlarms = iCalResource.getVEvent().getVAlarms();
        Assert.assertEquals((String)"Unexpected number of VALARMs found", (long)2L, (long)vAlarms.size());
        for (SimpleICal.Component vAlarm : vAlarms) {
            if (null != vAlarm.getProperty("RELATED-TO")) {
                Assert.assertEquals((String)"ALARM wrong", (Object)AlarmTestEMClient.formatAsUTC(nextTrigger), (Object)vAlarm.getPropertyValue("TRIGGER"));
                continue;
            }
            Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)vAlarm.getPropertyValue("TRIGGER"));
        }
    }

    @Test
    public void testEditReminder() throws Exception {
        String uid = AlarmTestEMClient.randomUID();
        Date start = TimeTools.D("next tuesday at 10:00");
        Date end = TimeTools.D("next tuesday at 11:00");
        Date initialAcknowledged = TimeTools.D("next tuesday at 09:44");
        String iCal = "BEGIN:VCALENDAR\r\nPRODID:-//eM Client/6.0.23421.0\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:W. Europe Standard Time\r\nX-EM-DISPLAYNAME:(UTC+01:00) Amsterdam\\, Berlin\\, Bern\\, Rom\\, Stockholm\\, W\r\n ien\r\nBEGIN:STANDARD\r\nTZNAME:Mitteleurop\u00e4ische Zeit\r\nDTSTART:00010101T030000\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZNAME:Mitteleurop\u00e4ische Sommerzeit\r\nDTSTART:00010101T020000\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nUID:" + uid + "\r\n" + "DTSTART;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:20151116T121948Z\r\n" + "DTSTAMP:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "SUMMARY:snooze\r\n" + "CLASS:PUBLIC\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "X-MOZ-LASTACK:" + AlarmTestEMClient.formatAsUTC(initialAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestEMClient.formatAsUTC(initialAcknowledged) + "\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Date nextAcknowledged = TimeTools.D("next tuesday at 09:29:00");
        iCal = "BEGIN:VCALENDAR\r\nPRODID:-//eM Client/6.0.23421.0\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:W. Europe Standard Time\r\nX-EM-DISPLAYNAME:(UTC+01:00) Amsterdam\\, Berlin\\, Bern\\, Rom\\, Stockholm\\, W\r\n ien\r\nBEGIN:STANDARD\r\nTZNAME:Mitteleurop\u00e4ische Zeit\r\nDTSTART:00010101T030000\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZNAME:Mitteleurop\u00e4ische Sommerzeit\r\nDTSTART:00010101T020000\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nUID:" + uid + "\r\n" + "DTSTART;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:20151116T121948Z\r\n" + "DTSTAMP:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "SUMMARY:snooze\r\n" + "CLASS:PUBLIC\r\n" + "BEGIN:VALARM\r\n" + "TRIGGER;RELATED=START:-PT30M\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Open-XChange\r\n" + "X-MOZ-LASTACK:" + AlarmTestEMClient.formatAsUTC(nextAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestEMClient.formatAsUTC(nextAcknowledged) + "\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)30L, (long)appointment.getAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT30M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
    }

    @Test
    public void testAcknowledgeRecurringReminder() throws Exception {
        String uid = AlarmTestEMClient.randomUID();
        Date start = TimeTools.D("next friday at 10:00");
        Date end = TimeTools.D("next friday at 10:15");
        Date initialAcknowledged = TimeTools.D("next friday at 09:44");
        String iCal = "BEGIN:VCALENDAR\r\nPRODID:-//eM Client/6.0.23421.0\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:W. Europe Standard Time\r\nX-EM-DISPLAYNAME:(UTC+01:00) Amsterdam\\, Berlin\\, Bern\\, Rom\\, Stockholm\\, W\r\n ien\r\nBEGIN:STANDARD\r\nTZNAME:Mitteleurop\u00e4ische Zeit\r\nDTSTART:00010101T030000\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZNAME:Mitteleurop\u00e4ische Sommerzeit\r\nDTSTART:00010101T020000\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nUID:" + uid + "\r\n" + "DTSTART;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "SUMMARY:RecurringReminder\r\n" + "CLASS:PUBLIC\r\n" + "RRULE:FREQ=DAILY\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "X-MOZ-LASTACK:" + AlarmTestEMClient.formatAsUTC(initialAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestEMClient.formatAsUTC(initialAcknowledged) + "\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        calendar.setTime(initialAcknowledged);
        calendar.add(5, 1);
        Date nextAcknowledged = calendar.getTime();
        iCal = "BEGIN:VCALENDAR\r\nPRODID:-//eM Client/6.0.23421.0\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:W. Europe Standard Time\r\nX-EM-DISPLAYNAME:(UTC+01:00) Amsterdam\\, Berlin\\, Bern\\, Rom\\, Stockholm\\, W\r\n ien\r\nBEGIN:STANDARD\r\nTZNAME:Mitteleurop\u00e4ische Zeit\r\nDTSTART:00010101T030000\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZNAME:Mitteleurop\u00e4ische Sommerzeit\r\nDTSTART:00010101T020000\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nUID:" + uid + "\r\n" + "DTSTART;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "SUMMARY:RecurringReminder\r\n" + "CLASS:PUBLIC\r\n" + "RRULE:FREQ=DAILY\r\n" + "BEGIN:VALARM\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Open-XChange\r\n" + "X-MOZ-LASTACK:" + AlarmTestEMClient.formatAsUTC(nextAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestEMClient.formatAsUTC(nextAcknowledged) + "\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestEMClient.formatAsUTC(nextAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("ACKNOWLEDGED"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestEMClient.formatAsUTC(nextAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("X-MOZ-LASTACK"));
    }

    @Test
    public void testSnoozeRecurringReminder() throws Exception {
        String uid = AlarmTestEMClient.randomUID();
        Date start = TimeTools.D("next friday at 10:00");
        Date end = TimeTools.D("next friday at 10:15");
        Date initialAcknowledged = TimeTools.D("next friday at 09:44");
        String iCal = "BEGIN:VCALENDAR\r\nPRODID:-//eM Client/6.0.23421.0\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:W. Europe Standard Time\r\nX-EM-DISPLAYNAME:(UTC+01:00) Amsterdam\\, Berlin\\, Bern\\, Rom\\, Stockholm\\, W\r\n ien\r\nBEGIN:STANDARD\r\nTZNAME:Mitteleurop\u00e4ische Zeit\r\nDTSTART:00010101T030000\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZNAME:Mitteleurop\u00e4ische Sommerzeit\r\nDTSTART:00010101T020000\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nUID:" + uid + "\r\n" + "DTSTART;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "SUMMARY:RecurringReminder\r\n" + "CLASS:PUBLIC\r\n" + "RRULE:FREQ=DAILY\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "X-MOZ-LASTACK:" + AlarmTestEMClient.formatAsUTC(initialAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestEMClient.formatAsUTC(initialAcknowledged) + "\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Date nextTrigger = TimeTools.D("next friday at 09:51:24");
        Date nextAcknowledged = TimeTools.D("next friday at 09:50:24");
        iCal = "BEGIN:VCALENDAR\r\nPRODID:-//eM Client/6.0.23421.0\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:W. Europe Standard Time\r\nX-EM-DISPLAYNAME:(UTC+01:00) Amsterdam\\, Berlin\\, Bern\\, Rom\\, Stockholm\\, W\r\n ien\r\nBEGIN:STANDARD\r\nTZNAME:Mitteleurop\u00e4ische Zeit\r\nDTSTART:00010101T030000\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZNAME:Mitteleurop\u00e4ische Sommerzeit\r\nDTSTART:00010101T020000\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nUID:" + uid + "\r\n" + "DTSTART;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "X-MOZ-SNOOZE:" + AlarmTestEMClient.formatAsUTC(nextTrigger) + "\r\n" + "DTSTAMP:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "SUMMARY:RecurringReminder\r\n" + "CLASS:PUBLIC\r\n" + "RRULE:FREQ=DAILY\r\n" + "BEGIN:VALARM\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Open-XChange\r\n" + "X-MOZ-LASTACK:" + AlarmTestEMClient.formatAsUTC(nextAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestEMClient.formatAsUTC(nextAcknowledged) + "\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "TRIGGER;VALUE=DATE-TIME:" + AlarmTestEMClient.formatAsUTC(nextTrigger) + "\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "X-MOZ-LASTACK:" + AlarmTestEMClient.formatAsUTC(nextAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestEMClient.formatAsUTC(nextAcknowledged) + "\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        List<SimpleICal.Component> vAlarms = iCalResource.getVEvent().getVAlarms();
        Assert.assertEquals((String)"Unexpected number of VALARMs found", (long)2L, (long)vAlarms.size());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)vAlarms.get(0).getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestEMClient.formatAsUTC(nextAcknowledged), (Object)vAlarms.get(0).getPropertyValue("ACKNOWLEDGED"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestEMClient.formatAsUTC(nextAcknowledged), (Object)vAlarms.get(0).getPropertyValue("X-MOZ-LASTACK"));
        Assert.assertNotNull((String)"No RELATED-TO found", (Object)vAlarms.get(1).getProperty("RELATED-TO"));
        Assert.assertEquals((String)"ALARM wrong", (Object)AlarmTestEMClient.formatAsUTC(nextTrigger), (Object)vAlarms.get(1).getPropertyValue("TRIGGER"));
    }

    @Test
    public void testAcknowledgeExceptionReminder() throws Exception {
        String uid = AlarmTestEMClient.randomUID();
        Date start = TimeTools.D("next friday at 10:00");
        Date end = TimeTools.D("next friday at 11:00");
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        calendar.setTime(start);
        calendar.add(5, 2);
        Date exceptionStart = calendar.getTime();
        calendar.add(10, 1);
        Date exceptionEnd = calendar.getTime();
        calendar.setTime(exceptionStart);
        calendar.add(12, -16);
        Date exceptionAcknowledged = calendar.getTime();
        calendar.add(5, 1);
        Date seriesAcknowledged = calendar.getTime();
        String iCal = "BEGIN:VCALENDAR\r\nPRODID:-//eM Client/6.0.23421.0\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:W. Europe Standard Time\r\nX-EM-DISPLAYNAME:(UTC+01:00) Amsterdam\\, Berlin\\, Bern\\, Rom\\, Stockholm\\, W\r\n ien\r\nBEGIN:STANDARD\r\nTZNAME:Mitteleurop\u00e4ische Zeit\r\nDTSTART:00010101T030000\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZNAME:Mitteleurop\u00e4ische Sommerzeit\r\nDTSTART:00010101T020000\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nUID:" + uid + "\r\n" + "DTSTART;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "SUMMARY:daily\r\n" + "CLASS:PUBLIC\r\n" + "RRULE:FREQ=DAILY\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "X-MOZ-LASTACK:" + AlarmTestEMClient.formatAsUTC(seriesAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestEMClient.formatAsUTC(seriesAcknowledged) + "\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "DTSTAMP:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "SUMMARY:dailyEDIT\r\n" + "DTSTART;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(exceptionStart, "Europe/Berlin") + "\r\n" + "DTEND;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "CLASS:PUBLIC\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "TRANSP:OPAQUE\r\n" + "RECURRENCE-ID:" + AlarmTestEMClient.formatAsUTC(exceptionStart) + "\r\n" + "UID:" + uid + "\r\n" + "CREATED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "LAST-MODIFIED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "BEGIN:VALARM\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "X-MOZ-LASTACK:" + AlarmTestEMClient.formatAsUTC(exceptionAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestEMClient.formatAsUTC(exceptionAcknowledged) + "\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        Assert.assertNotNull((String)"No change exceptions found on server", (Object)appointment.getChangeException());
        Assert.assertEquals((String)"Unexpected number of change excpetions", (long)1L, (long)appointment.getChangeException().length);
        Appointment changeExcpetion = this.getChangeExcpetions(appointment).get(0);
        this.rememberForCleanUp(changeExcpetion);
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)changeExcpetion.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestEMClient.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("ACKNOWLEDGED"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestEMClient.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("X-MOZ-LASTACK"));
        Assert.assertEquals((String)"Not all VEVENTs in iCal found", (long)2L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvents().get(1).getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)"dailyEDIT", (Object)iCalResource.getVEvents().get(1).getSummary());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvents().get(1).getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvents().get(1).getVAlarm().getPropertyValue("TRIGGER"));
        iCal = "BEGIN:VCALENDAR\r\nPRODID:-//eM Client/6.0.23421.0\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:W. Europe Standard Time\r\nX-EM-DISPLAYNAME:(UTC+01:00) Amsterdam\\, Berlin\\, Bern\\, Rom\\, Stockholm\\, W\r\n ien\r\nBEGIN:STANDARD\r\nTZNAME:Mitteleurop\u00e4ische Zeit\r\nDTSTART:00010101T030000\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZNAME:Mitteleurop\u00e4ische Sommerzeit\r\nDTSTART:00010101T020000\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nUID:" + uid + "\r\n" + "DTSTART;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "SUMMARY:daily\r\n" + "CLASS:PUBLIC\r\n" + "RRULE:FREQ=DAILY\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "X-MOZ-LASTACK:" + AlarmTestEMClient.formatAsUTC(seriesAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestEMClient.formatAsUTC(seriesAcknowledged) + "\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "DTSTAMP:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "SUMMARY:dailyEDIT\r\n" + "DTSTART;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(exceptionStart, "Europe/Berlin") + "\r\n" + "DTEND;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "CLASS:PUBLIC\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "TRANSP:OPAQUE\r\n" + "RECURRENCE-ID:" + AlarmTestEMClient.formatAsUTC(exceptionStart) + "\r\n" + "UID:" + uid + "\r\n" + "CREATED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "LAST-MODIFIED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "BEGIN:VALARM\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "X-MOZ-LASTACK:99991231T235859Z\r\n" + "ACKNOWLEDGED:99991231T235859Z\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        Assert.assertNotNull((String)"No change exceptions found on server", (Object)appointment.getChangeException());
        Assert.assertEquals((String)"Unexpected number of change excpetions", (long)1L, (long)appointment.getChangeException().length);
        changeExcpetion = this.getChangeExcpetions(appointment).get(0);
        this.rememberForCleanUp(changeExcpetion);
        Assert.assertFalse((String)"reminder still found", (boolean)changeExcpetion.containsAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestEMClient.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("ACKNOWLEDGED"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestEMClient.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("X-MOZ-LASTACK"));
        Assert.assertEquals((String)"Not all VEVENTs in iCal found", (long)2L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvents().get(1).getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)"dailyEDIT", (Object)iCalResource.getVEvents().get(1).getSummary());
        Assert.assertNull((String)"ALARM in iCal exception found", (Object)iCalResource.getVEvents().get(1).getVAlarm());
    }

    @Test
    public void testSnoozeExceptionReminder() throws Exception {
        String uid = AlarmTestEMClient.randomUID();
        Date start = TimeTools.D("next friday at 10:00");
        Date end = TimeTools.D("next friday at 11:00");
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Berlin"));
        calendar.setTime(start);
        calendar.add(5, 2);
        Date exceptionStart = calendar.getTime();
        calendar.add(10, 1);
        Date exceptionEnd = calendar.getTime();
        calendar.setTime(exceptionStart);
        calendar.add(12, -16);
        Date exceptionAcknowledged = calendar.getTime();
        calendar.add(5, 1);
        Date seriesAcknowledged = calendar.getTime();
        String iCal = "BEGIN:VCALENDAR\r\nPRODID:-//eM Client/6.0.23421.0\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:W. Europe Standard Time\r\nX-EM-DISPLAYNAME:(UTC+01:00) Amsterdam\\, Berlin\\, Bern\\, Rom\\, Stockholm\\, W\r\n ien\r\nBEGIN:STANDARD\r\nTZNAME:Mitteleurop\u00e4ische Zeit\r\nDTSTART:00010101T030000\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZNAME:Mitteleurop\u00e4ische Sommerzeit\r\nDTSTART:00010101T020000\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nUID:" + uid + "\r\n" + "DTSTART;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "SUMMARY:daily\r\n" + "CLASS:PUBLIC\r\n" + "RRULE:FREQ=DAILY\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "X-MOZ-LASTACK:" + AlarmTestEMClient.formatAsUTC(seriesAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestEMClient.formatAsUTC(seriesAcknowledged) + "\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "DTSTAMP:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "SUMMARY:dailyEDIT\r\n" + "DTSTART;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(exceptionStart, "Europe/Berlin") + "\r\n" + "DTEND;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "CLASS:PUBLIC\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "TRANSP:OPAQUE\r\n" + "RECURRENCE-ID:" + AlarmTestEMClient.formatAsUTC(exceptionStart) + "\r\n" + "UID:" + uid + "\r\n" + "CREATED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "LAST-MODIFIED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "BEGIN:VALARM\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "X-MOZ-LASTACK:" + AlarmTestEMClient.formatAsUTC(exceptionAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestEMClient.formatAsUTC(exceptionAcknowledged) + "\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        Assert.assertNotNull((String)"No change exceptions found on server", (Object)appointment.getChangeException());
        Assert.assertEquals((String)"Unexpected number of change excpetions", (long)1L, (long)appointment.getChangeException().length);
        Appointment changeExcpetion = this.getChangeExcpetions(appointment).get(0);
        this.rememberForCleanUp(changeExcpetion);
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)changeExcpetion.getAlarm());
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestEMClient.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("ACKNOWLEDGED"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestEMClient.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("X-MOZ-LASTACK"));
        Assert.assertEquals((String)"Not all VEVENTs in iCal found", (long)2L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvents().get(1).getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)"dailyEDIT", (Object)iCalResource.getVEvents().get(1).getSummary());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvents().get(1).getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvents().get(1).getVAlarm().getPropertyValue("TRIGGER"));
        calendar.setTime(exceptionStart);
        calendar.add(12, -10);
        calendar.add(13, 24);
        Date nextTrigger = calendar.getTime();
        calendar.add(12, -1);
        Date nextAcknowledged = calendar.getTime();
        iCal = "BEGIN:VCALENDAR\r\nPRODID:-//eM Client/6.0.23421.0\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:W. Europe Standard Time\r\nX-EM-DISPLAYNAME:(UTC+01:00) Amsterdam\\, Berlin\\, Bern\\, Rom\\, Stockholm\\, W\r\n ien\r\nBEGIN:STANDARD\r\nTZNAME:Mitteleurop\u00e4ische Zeit\r\nDTSTART:00010101T030000\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZNAME:Mitteleurop\u00e4ische Sommerzeit\r\nDTSTART:00010101T020000\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nUID:" + uid + "\r\n" + "DTSTART;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(start, "Europe/Berlin") + "\r\n" + "DTEND;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "LAST-MODIFIED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "CREATED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "SUMMARY:daily\r\n" + "CLASS:PUBLIC\r\n" + "RRULE:FREQ=DAILY\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "X-MOZ-LASTACK:" + AlarmTestEMClient.formatAsUTC(seriesAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestEMClient.formatAsUTC(seriesAcknowledged) + "\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "BEGIN:VEVENT\r\n" + "DTSTAMP:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "SUMMARY:dailyEDIT\r\n" + "DTSTART;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(exceptionStart, "Europe/Berlin") + "\r\n" + "DTEND;TZID=\"W. Europe Standard Time\":" + AlarmTestEMClient.format(exceptionEnd, "Europe/Berlin") + "\r\n" + "CLASS:PUBLIC\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "TRANSP:OPAQUE\r\n" + "RECURRENCE-ID:" + AlarmTestEMClient.formatAsUTC(exceptionStart) + "\r\n" + "UID:" + uid + "\r\n" + "CREATED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "LAST-MODIFIED:" + AlarmTestEMClient.formatAsUTC(new Date()) + "\r\n" + "X-MOZ-SNOOZE:" + AlarmTestEMClient.formatAsUTC(nextTrigger) + "\r\n" + "BEGIN:VALARM\r\n" + "TRIGGER;RELATED=START:-PT15M\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "X-MOZ-LASTACK:" + AlarmTestEMClient.formatAsUTC(nextAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestEMClient.formatAsUTC(nextAcknowledged) + "\r\n" + "END:VALARM\r\n" + "BEGIN:VALARM\r\n" + "ACTION:DISPLAY\r\n" + "DESCRIPTION:Alarm\r\n" + "TRIGGER;VALUE=DATE-TIME:" + AlarmTestEMClient.formatAsUTC(nextTrigger) + "\r\n" + "X-MOZ-LASTACK:" + AlarmTestEMClient.formatAsUTC(nextAcknowledged) + "\r\n" + "ACKNOWLEDGED:" + AlarmTestEMClient.formatAsUTC(nextAcknowledged) + "\r\n" + "END:VALARM\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(uid, iCal, iCalResource.getETag()));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Assert.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)appointment.getAlarm());
        Assert.assertNotNull((String)"No change exceptions found on server", (Object)appointment.getChangeException());
        Assert.assertEquals((String)"Unexpected number of change excpetions", (long)1L, (long)appointment.getChangeException().length);
        changeExcpetion = this.getChangeExcpetions(appointment).get(0);
        this.rememberForCleanUp(changeExcpetion);
        Assert.assertTrue((String)"no reminder found", (boolean)changeExcpetion.containsAlarm());
        Assert.assertEquals((String)"reminder minutes wrong", (long)15L, (long)changeExcpetion.getAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        Assert.assertEquals((String)"ACKNOWLEDGED wrong", (Object)AlarmTestEMClient.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("ACKNOWLEDGED"));
        Assert.assertEquals((String)"X-MOZ-LASTACK wrong", (Object)AlarmTestEMClient.formatAsUTC(seriesAcknowledged), (Object)iCalResource.getVEvent().getVAlarm().getPropertyValue("X-MOZ-LASTACK"));
        Assert.assertEquals((String)"Not all VEVENTs in iCal found", (long)2L, (long)iCalResource.getVEvents().size());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvents().get(1).getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)"dailyEDIT", (Object)iCalResource.getVEvents().get(1).getSummary());
        Assert.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvents().get(1).getVAlarm());
        List<SimpleICal.Component> vAlarms = iCalResource.getVEvents().get(1).getVAlarms();
        Assert.assertEquals((String)"Unexpected number of VALARMs found", (long)2L, (long)vAlarms.size());
        for (SimpleICal.Component vAlarm : vAlarms) {
            if (null != vAlarm.getProperty("RELATED-TO")) {
                Assert.assertEquals((String)"ALARM wrong", (Object)AlarmTestEMClient.formatAsUTC(nextTrigger), (Object)vAlarm.getPropertyValue("TRIGGER"));
                continue;
            }
            Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)vAlarm.getPropertyValue("TRIGGER"));
        }
    }
}

