/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;

public class Bug28490Test
extends CalDAVTest {
    @Test
    public void testTimeZoneCET() throws Exception {
        String uid = Bug28490Test.randomUID();
        Appointment appointment = new Appointment();
        appointment.setUid(uid);
        appointment.setTitle(this.getClass().getCanonicalName());
        appointment.setIgnoreConflicts(true);
        appointment.setStartDate(TimeTools.D("last january on friday at 16:00", TimeZone.getTimeZone("CET")));
        appointment.setEndDate(TimeTools.D("last january on friday at 16:30", TimeZone.getTimeZone("CET")));
        appointment.setRecurrenceType(2);
        appointment.setDays(32);
        appointment.setInterval(1);
        appointment.setTimezone("CET");
        super.create(appointment);
        super.rememberForCleanUp(appointment);
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No TZID attribute found in DTSTART property", (Object)iCalResource.getVEvent().getProperty("DTSTART").getAttribute("TZID"));
        Assert.assertNotNull((String)"No TZID attribute found in DTEND property", (Object)iCalResource.getVEvent().getProperty("DTEND").getAttribute("TZID"));
    }
}

