/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.consistency;

import com.openexchange.consistency.Consistency;
import com.openexchange.consistency.ConsistencyMBean;
import com.openexchange.consistency.Entity;
import com.openexchange.consistency.EntityImpl;
import com.openexchange.consistency.MBeanEntity;
import com.openexchange.consistency.SimQuotaFileStorageService;
import com.openexchange.exception.OXException;
import com.openexchange.filestore.FileStorage;
import com.openexchange.filestore.FileStorages;
import com.openexchange.filestore.QuotaFileStorageService;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.InMemoryAttachmentBase;
import com.openexchange.groupware.attach.impl.AttachmentImpl;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.InMemoryInfostoreDatabase;
import com.openexchange.groupware.infostore.database.impl.DatabaseImpl;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.Charsets;
import com.openexchange.tools.file.InMemoryFileStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.management.MBeanException;
import junit.framework.TestCase;

public class ConsistencyTest
extends TestCase {
    private final InMemoryInfostoreDatabase database = new InMemoryInfostoreDatabase();
    private InMemoryFileStorage storage = null;
    private final InMemoryAttachmentBase attachments = new InMemoryAttachmentBase();
    private SimQuotaFileStorageService quotaFileStorageService = null;
    private ContextImpl ctx = null;
    private ContextImpl ctx2 = null;
    private ContextImpl ctx3 = null;
    private final Map<Integer, Context> contexts = new HashMap<Integer, Context>();
    private int id = 20;
    private static final HashSet<String> MISSING = new HashSet<String>(){
        private static final long serialVersionUID = -795039863003179912L;
        {
            this.add("00/01/01");
            this.add("00/01/03");
            this.add("00/02/02");
        }
    };
    private static final HashSet<String> UNASSIGNED = new HashSet<String>(){
        private static final long serialVersionUID = 7050405041645511451L;
        {
            this.add("00/00/02");
            this.add("00/00/03");
            this.add("00/01/02");
            this.add("00/02/03");
            this.add("00/04/04");
        }
    };

    protected void setUp() throws Exception {
        super.setUp();
        this.storage = new InMemoryFileStorage();
        this.quotaFileStorageService = new SimQuotaFileStorageService(this.storage);
        FileStorages.setQuotaFileStorageService((QuotaFileStorageService)this.quotaFileStorageService);
        this.ctx = new ContextImpl(1);
        this.ctx.setFilestoreId(1);
        this.ctx2 = new ContextImpl(2);
        this.ctx2.setFilestoreId(1);
        this.ctx3 = new ContextImpl(3);
        this.ctx3.setFilestoreId(2);
        this.contexts.put(Autoboxing.I((int)this.ctx.getContextId()), (Context)this.ctx);
        this.contexts.put(Autoboxing.I((int)this.ctx2.getContextId()), (Context)this.ctx2);
        this.contexts.put(Autoboxing.I((int)this.ctx3.getContextId()), (Context)this.ctx3);
        this.simulateBrokenContext((Context)this.ctx);
        this.simulateBrokenContext((Context)this.ctx2);
        this.simulateBrokenContext((Context)this.ctx3);
    }

    public void testListMissingFilesInContext() throws MBeanException {
        ConsistencyMBean consistency = this.getConsistencyTool();
        List missing = consistency.listMissingFilesInContext(this.ctx.getContextId());
        ConsistencyTest.assertNotNull((Object)missing);
        HashSet<String> expected = new HashSet<String>(MISSING);
        ConsistencyTest.assertEquals((String)missing.toString(), (int)expected.size(), (int)missing.size());
        expected.removeAll(missing);
        ConsistencyTest.assertTrue((String)missing.toString(), (boolean)expected.isEmpty());
    }

    public void testListMissingFilesInFilestore() throws MBeanException {
        ConsistencyMBean consistency = this.getConsistencyTool();
        Map missing = consistency.listMissingFilesInFilestore(1);
        this.assertContextEntities(missing, MISSING, new Context[]{this.ctx, this.ctx2});
    }

    public void testListMissingFilesInDatabase() throws MBeanException {
        ConsistencyMBean consistency = this.getConsistencyTool();
        Map missing = consistency.listMissingFilesInDatabase(1);
        this.assertContextEntities(missing, MISSING, new Context[]{this.ctx, this.ctx3});
    }

    public void testListAllMissingFiles() throws MBeanException {
        ConsistencyMBean consistency = this.getConsistencyTool();
        Map missing = consistency.listAllMissingFiles();
        this.assertContextEntities(missing, MISSING, new Context[]{this.ctx, this.ctx2, this.ctx3});
    }

    public void testListUnassignedFilesInContext() throws MBeanException {
        ConsistencyMBean consistency = this.getConsistencyTool();
        List unassigned = consistency.listUnassignedFilesInContext(this.ctx.getContextId());
        ConsistencyTest.assertNotNull((Object)unassigned);
        HashSet<String> expected = new HashSet<String>(UNASSIGNED);
        ConsistencyTest.assertEquals((String)unassigned.toString(), (int)expected.size(), (int)unassigned.size());
        expected.removeAll(unassigned);
        ConsistencyTest.assertTrue((String)unassigned.toString(), (boolean)expected.isEmpty());
    }

    public void testListUnassignedFilesInFilestore() throws MBeanException {
        ConsistencyMBean consistency = this.getConsistencyTool();
        Map unassigned = consistency.listUnassignedFilesInFilestore(1);
        this.assertContextEntities(unassigned, UNASSIGNED, new Context[]{this.ctx, this.ctx2});
    }

    public void testListUnassignedFilesInDatabase() throws MBeanException {
        ConsistencyMBean consistency = this.getConsistencyTool();
        Map unassigned = consistency.listUnassignedFilesInDatabase(1);
        this.assertContextEntities(unassigned, UNASSIGNED, new Context[]{this.ctx, this.ctx3});
    }

    public void testListAllUnassignedFiles() throws MBeanException {
        ConsistencyMBean consistency = this.getConsistencyTool();
        Map unassigned = consistency.listAllUnassignedFiles();
        this.assertContextEntities(unassigned, UNASSIGNED, new Context[]{this.ctx, this.ctx2, this.ctx3});
    }

    public void testCreateDummyFilesForInfoitems() throws MBeanException, OXException {
        ConsistencyMBean consistency = this.getConsistencyTool();
        this.database.forgetChanges((Context)this.ctx);
        consistency.repairFilesInContext(this.ctx.getContextId(), "missing_file_for_infoitem : create_dummy");
        List<DocumentMetadata> changes = this.database.getChanges((Context)this.ctx);
        ConsistencyTest.assertEquals((int)2, (int)changes.size());
        this.storage.setContext((Context)this.ctx);
        for (DocumentMetadata version : changes) {
            ConsistencyTest.assertEquals((String)"\nCaution! The file has changed", (String)version.getDescription());
            ConsistencyTest.assertEquals((String)"text/plain", (String)version.getFileMIMEType());
            ConsistencyTest.assertNotNull((Object)this.storage.getFile(version.getFilestoreLocation()));
        }
    }

    public void testCreateDummyFilesForAttachments() throws MBeanException, OXException {
        ConsistencyMBean consistency = this.getConsistencyTool();
        this.attachments.forgetChanges((Context)this.ctx);
        consistency.repairFilesInContext(this.ctx.getContextId(), "missing_file_for_attachment : create_dummy");
        List<AttachmentMetadata> changes = this.attachments.getChanges((Context)this.ctx);
        ConsistencyTest.assertEquals((int)1, (int)changes.size());
        for (AttachmentMetadata attachment : changes) {
            ConsistencyTest.assertEquals((String)"\nCaution! The file has changed", (String)attachment.getComment());
            ConsistencyTest.assertEquals((String)"text/plain", (String)attachment.getFileMIMEType());
            ConsistencyTest.assertNotNull((Object)this.storage.getFile(attachment.getFileId()));
        }
    }

    public void testDeleteStaleInfoitems() throws MBeanException {
        ConsistencyMBean consistency = this.getConsistencyTool();
        this.database.forgetDeletions((Context)this.ctx);
        consistency.repairFilesInContext(this.ctx.getContextId(), "missing_file_for_infoitem : delete");
        List<DocumentMetadata> deletions = this.database.getDeletions((Context)this.ctx);
        ConsistencyTest.assertEquals((int)2, (int)deletions.size());
        HashSet<String> missing = new HashSet<String>(MISSING);
        for (DocumentMetadata document : deletions) {
            ConsistencyTest.assertTrue((boolean)missing.remove(document.getFilestoreLocation()));
        }
        ConsistencyTest.assertEquals((int)1, (int)missing.size());
    }

    public void testDeleteStaleAttachments() throws MBeanException {
        ConsistencyMBean consistency = this.getConsistencyTool();
        this.attachments.forgetDeletions((Context)this.ctx);
        consistency.repairFilesInContext(this.ctx.getContextId(), "missing_file_for_attachment : delete");
        List<AttachmentMetadata> deletions = this.attachments.getDeletions((Context)this.ctx);
        ConsistencyTest.assertEquals((int)1, (int)deletions.size());
        HashSet<String> missing = new HashSet<String>(MISSING);
        for (AttachmentMetadata document : deletions) {
            ConsistencyTest.assertTrue((boolean)missing.remove(document.getFileId()));
        }
        ConsistencyTest.assertEquals((int)2, (int)missing.size());
    }

    public void testCreateInfoitemForUnassignedFile() throws MBeanException {
        ConsistencyMBean consistency = this.getConsistencyTool();
        this.database.forgetCreated((Context)this.ctx);
        consistency.repairFilesInContext(1, "missing_entry_for_file : create_admin_infoitem");
        List<DocumentMetadata> created = this.database.getCreated((Context)this.ctx);
        ConsistencyTest.assertEquals((int)UNASSIGNED.size(), (int)created.size());
        HashSet<String> unassigned = new HashSet<String>(UNASSIGNED);
        for (DocumentMetadata document : created) {
            String location = document.getFilestoreLocation();
            ConsistencyTest.assertTrue((boolean)unassigned.remove(location));
            if (location == null) continue;
            String description = "This file needs attention";
            String title = "Restoredfile";
            String fileName = "Restoredfile";
            ConsistencyTest.assertEquals((String)"This file needs attention", (String)document.getDescription());
            ConsistencyTest.assertEquals((String)"Restoredfile", (String)document.getTitle());
            ConsistencyTest.assertEquals((String)"Restoredfile", (String)document.getFileName());
        }
    }

    public void testDeleteUnassignedFile() throws MBeanException {
        ConsistencyMBean consistency = this.getConsistencyTool();
        this.storage.forgetDeleted((Context)this.ctx);
        consistency.repairFilesInContext(1, "missing_entry_for_file : delete");
        List<String> deleted = this.storage.getDeleted((Context)this.ctx);
        ConsistencyTest.assertEquals((int)UNASSIGNED.size(), (int)deleted.size());
        HashSet<String> unassigned = new HashSet<String>(UNASSIGNED);
        unassigned.removeAll(deleted);
        ConsistencyTest.assertTrue((boolean)unassigned.isEmpty());
    }

    protected void assertContextEntities(Map<MBeanEntity, List<String>> missing, Set<String> expect, Context ... testContexts) {
        ConsistencyTest.assertNotNull(missing);
        HashSet<MBeanEntity> entities = new HashSet<MBeanEntity>(missing.keySet());
        ConsistencyTest.assertEquals((String)((Object)entities).toString(), (int)testContexts.length, (int)entities.size());
        for (Context context : testContexts) {
            MBeanEntity entity = new MBeanEntity(context.getContextId());
            List<String> ids = missing.get(entity);
            ConsistencyTest.assertNotNull(ids);
            HashSet<String> expected = new HashSet<String>(expect);
            ConsistencyTest.assertEquals((String)ids.toString(), (int)expected.size(), (int)ids.size());
            expected.removeAll(ids);
            ConsistencyTest.assertTrue((String)ids.toString(), (boolean)expected.isEmpty());
            entities.remove(entity);
        }
        ConsistencyTest.assertTrue((String)((Object)entities).toString(), (boolean)entities.isEmpty());
    }

    private ConsistencyMBean getConsistencyTool() {
        return new TestConsistency(this.database, this.attachments, this.storage, this.contexts);
    }

    protected void simulateBrokenContext(Context context) {
        this.simulateBrokenOlderVersionInInfostore(context);
        this.simulateBrokenCurrentVersionInInfostore(context);
        this.simulateWholeInfostoreEntry(context);
        this.simulateBrokenAttachment(context);
        this.simulateWholeAttachment(context);
        this.simulateFileStoreEntryWithoutDatabaseEntry(context);
    }

    private void simulateFileStoreEntryWithoutDatabaseEntry(Context context) {
        String unassignedEntry = "00/04/04";
        this.createFilestoreEntry(context, "00/04/04", "unassigned");
    }

    private void simulateWholeAttachment(Context context) {
        String attachmentEntry = "00/00/01";
        this.createAttachment(context, "00/00/01");
        this.createFilestoreEntry(context, "00/00/01", "wholeAttachment");
    }

    private void simulateBrokenAttachment(Context context) {
        String brokenAttachment = "00/01/01";
        this.createAttachment(context, "00/01/01");
    }

    private void simulateWholeInfostoreEntry(Context context) {
        String version1 = "00/00/02";
        String version2 = "00/00/03";
        int dmId = this.createInfostoreDocument(context);
        this.createVersion(context, dmId, "00/00/02");
        this.createVersion(context, dmId, "00/00/03");
        this.createFilestoreEntry(context, "00/00/02", "wholeInfoitemVersion1");
        this.createFilestoreEntry(context, "00/00/03", "wholeInfoitemVersion2");
    }

    private void simulateBrokenCurrentVersionInInfostore(Context context) {
        String version1 = "00/01/02";
        String version2 = "00/01/03";
        int dmId = this.createInfostoreDocument(context);
        this.createVersion(context, dmId, "00/01/02");
        this.createVersion(context, dmId, "00/01/03");
        this.createFilestoreEntry(context, "00/01/02", "brokenCurrentVersionV1");
    }

    private void simulateBrokenOlderVersionInInfostore(Context context) {
        String version1 = "00/02/02";
        String version2 = "00/02/03";
        int dmId = this.createInfostoreDocument(context);
        this.createVersion(context, dmId, "00/02/02");
        this.createVersion(context, dmId, "00/02/03");
        this.createFilestoreEntry(context, "00/02/03", "brokenOlderVersionV2");
    }

    private void createFilestoreEntry(Context context, String filestoreId, String content) {
        this.storage.put(context, filestoreId, content.getBytes(Charsets.UTF_8));
    }

    private void createAttachment(Context context, String filestorePath) {
        AttachmentImpl attachment = new AttachmentImpl();
        attachment.setFileId(filestorePath);
        attachment.setId(this.id++);
        attachment.setFilename("attachment.bin");
        attachment.setFilesize(23L);
        this.attachments.put(context, (AttachmentMetadata)attachment);
    }

    private int createInfostoreDocument(Context context) {
        int istoreId = this.id++;
        DocumentMetadataImpl dm = new DocumentMetadataImpl();
        dm.setId(istoreId);
        dm.setVersion(0);
        dm.setCreatedBy(1);
        this.database.put(context, (DocumentMetadata)dm);
        return istoreId;
    }

    private void createVersion(Context context, int dmId, String filestoreLocation) {
        DocumentMetadataImpl dm = new DocumentMetadataImpl();
        dm.setId(dmId);
        dm.setFilestoreLocation(filestoreLocation);
        dm.setVersion(this.database.getNextVersionNumber(context, dmId));
        dm.setCreatedBy(1);
        this.database.put(context, (DocumentMetadata)dm);
    }

    private static final class TestConsistency
    extends Consistency {
        private InMemoryInfostoreDatabase database = new InMemoryInfostoreDatabase();
        private InMemoryFileStorage storage = null;
        private InMemoryAttachmentBase attachments = new InMemoryAttachmentBase();
        private Map<Integer, Context> contexts = null;

        TestConsistency(InMemoryInfostoreDatabase database, InMemoryAttachmentBase attachments, InMemoryFileStorage storage, Map<Integer, Context> contexts) {
            this.database = database;
            this.storage = storage;
            this.attachments = attachments;
            this.contexts = contexts;
        }

        protected Context getContext(int contextId) {
            return this.contexts.get(Autoboxing.I((int)contextId));
        }

        protected DatabaseImpl getDatabase() {
            return this.database;
        }

        protected AttachmentBase getAttachments() {
            return this.attachments;
        }

        protected List<Context> getContextsForFilestore(int filestoreId) {
            ArrayList<Context> retval = new ArrayList<Context>();
            for (Context context : this.contexts.values()) {
                if (context.getFilestoreId() != filestoreId) continue;
                retval.add(context);
            }
            return retval;
        }

        protected List<Context> getContextsForDatabase(int datbaseId) {
            return Arrays.asList(this.contexts.get(Autoboxing.I((int)1)), this.contexts.get(Autoboxing.I((int)3)));
        }

        protected List<Context> getAllContexts() {
            return new ArrayList<Context>(this.contexts.values());
        }

        protected User getAdmin(Context ctx) {
            UserImpl usr = new UserImpl();
            usr.setId(1);
            return usr;
        }

        protected FileStorage getFileStorage(Context ctx) {
            this.storage.setContext(ctx);
            InMemoryFileStorage retval = this.storage;
            return retval;
        }

        protected FileStorage getFileStorage(Context ctx, User usr) throws OXException {
            this.storage.setContext(ctx);
            InMemoryFileStorage retval = this.storage;
            return retval;
        }

        protected FileStorage getFileStorage(Entity entity) throws OXException {
            this.storage.setContext(entity.getContext());
            InMemoryFileStorage retval = this.storage;
            return retval;
        }

        protected List<Entity> getEntitiesForFilestore(int filestoreId) throws OXException {
            ArrayList<Entity> retval = new ArrayList<Entity>();
            for (Context context : this.contexts.values()) {
                if (context.getFilestoreId() != filestoreId) continue;
                retval.add((Entity)new EntityImpl(context));
            }
            return retval;
        }

        protected SortedSet<String> getSnippetFileStoreLocationsPerContext(Context ctx) throws OXException {
            return new TreeSet<String>();
        }

        protected SortedSet<String> getVCardFileStoreLocationsPerContext(Context ctx) throws OXException {
            return new TreeSet<String>();
        }

        protected SortedSet<String> getPreviewCacheFileStoreLocationsPerContext(Context ctx) throws OXException {
            return new TreeSet<String>();
        }
    }
}

