/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.ajax.task.actions.UpdateResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.util.Calendar;
import java.util.TimeZone;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class Bug38782Test
extends AbstractAJAXSession {
    private AJAXClient client1;
    private TimeZone timeZone;
    private Task task;

    public Bug38782Test(String name) {
        super(name);
    }

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.client1 = this.getClient();
        this.timeZone = this.client.getValues().getTimeZone();
        this.task = new Task();
        this.task.setParentFolderID(this.client1.getValues().getPrivateTaskFolder());
        this.task.setTitle("Test for bug 38782");
        this.task.setRecurrenceType(1);
        this.task.setInterval(1);
        this.task.setOccurrence(2);
        Calendar start = TimeTools.createCalendar(this.timeZone);
        this.task.setStartDate(start.getTime());
        start.add(11, 2);
        this.task.setEndDate(start.getTime());
        this.client1.execute(new InsertRequest(this.task, this.timeZone, true)).fillTask(this.task);
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.client1.execute(new DeleteRequest(this.task));
        super.tearDown();
    }

    @Test
    public void testGetAllTasks() throws Exception {
        Task test = Create.cloneForUpdate(this.task);
        test.setStartDate(null);
        test.setEndDate(null);
        UpdateResponse response = this.client1.execute(new UpdateRequest(test, this.timeZone, false));
        if (!response.hasError()) {
            this.task.setLastModified(response.getTimestamp());
            test = Create.cloneForUpdate(this.task);
            test.setStatus(3);
            response = this.client1.execute(new UpdateRequest(test, this.timeZone, false));
            if (response.hasError()) {
                Bug38782Test.assertTrue((String)"This is the expected NullPointerException from the bug report.", (boolean)AjaxExceptionCodes.UNEXPECTED_ERROR.create().similarTo(response.getException()));
            }
            this.task.setLastModified(response.getTimestamp());
        } else {
            Bug38782Test.assertTrue((String)"Expected exception for recurring tasks getting start and end date removed.", (boolean)TaskExceptionCode.MISSING_RECURRENCE_VALUE.create().similarTo(response.getException()));
        }
    }
}

