/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.task.actions.ConfirmWithTaskInParametersRequest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.Task;
import java.io.IOException;
import java.util.TimeZone;
import org.json.JSONException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class Bug37002Test
extends AbstractAJAXSession {
    private AJAXClient client1;
    private AJAXClient client2;
    private Task task;
    private TimeZone timeZone;

    public Bug37002Test(String name) {
        super(name);
    }

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.client1 = this.getClient();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        UserParticipant participant = new UserParticipant(this.client2.getValues().getUserId());
        this.timeZone = this.client.getValues().getTimeZone();
        this.task = Create.createWithDefaults(this.client1.getValues().getPrivateTaskFolder(), "Test for bug 37002");
        this.task.addParticipant((Participant)participant);
        this.client1.execute(new InsertRequest(this.task, this.timeZone, true)).fillTask(this.task);
        Task client2Task = Create.cloneForUpdate(this.task);
        client2Task.setParentFolderID(this.client2.getValues().getPrivateTaskFolder());
        this.client2.execute(new ConfirmWithTaskInParametersRequest(client2Task, 1, "Will do the stuff.")).fillTask(this.task, client2Task);
        Task done = Create.cloneForUpdate(client2Task);
        done.addParticipant((Participant)participant);
        done.setStatus(3);
        this.client2.execute(new UpdateRequest(done, this.timeZone)).fillTask(this.task, client2Task, done);
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.client1.execute(new DeleteRequest(this.task));
        super.tearDown();
    }

    @Test
    public void testForLostConfirmStatus() throws OXException, IOException, JSONException {
        Task test = this.client1.execute(new GetRequest(this.task)).getTask(this.timeZone);
        UserParticipant[] participants = test.getUsers();
        Bug37002Test.assertEquals((String)"Number of task participants should be one.", (int)1, (int)participants.length);
        UserParticipant participant = participants[0];
        Bug37002Test.assertEquals((String)"Confirmation status got lost.", (int)1, (int)participant.getConfirm());
        Bug37002Test.assertEquals((String)"Confirm message got lost.", (String)"Will do the stuff.", (String)participant.getConfirmMessage());
    }
}

