/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.ListRequest;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageGuestObjectPermission;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.groupware.container.FolderObject;
import java.util.Collections;
import java.util.Iterator;

public class ShowSharedFilesFolderTest
extends ShareTest {
    private FileStorageGuestObjectPermission perm;
    private File file;
    private ExtendedPermissionEntity guest;

    public ShowSharedFilesFolderTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.perm = ShowSharedFilesFolderTest.randomGuestObjectPermission();
        this.file = this.insertSharedFile(this.client.getValues().getPrivateInfostoreFolder(), (FileStorageObjectPermission)this.perm);
        FileStorageObjectPermission matchingPermission = null;
        for (FileStorageObjectPermission permission : this.file.getObjectPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        ShowSharedFilesFolderTest.assertNotNull((String)"No matching permission for created file found.", matchingPermission);
        ShowSharedFilesFolderTest.checkPermissions((FileStorageObjectPermission)this.perm, matchingPermission);
        this.guest = this.discoverGuestEntity(this.file.getFolderId(), this.file.getId(), matchingPermission.getEntity());
        ShowSharedFilesFolderTest.checkGuestPermission((FileStorageObjectPermission)this.perm, this.guest);
    }

    @Override
    public void tearDown() throws Exception {
        ShowSharedFilesFolderTest.deleteFilesSilently(this.client, Collections.singletonList(this.file));
        super.tearDown();
    }

    public void testShowSharedFilesFolder() throws Exception {
        GuestClient guestClient = this.resolveShare(this.guest, this.perm.getRecipient());
        ListRequest req = new ListRequest((API)EnumAPI.OX_NEW, 9);
        ListResponse res = guestClient.execute(req);
        Iterator<FolderObject> i = res.getFolder();
        boolean found = false;
        while (i.hasNext()) {
            if (10 != i.next().getObjectID()) continue;
            found = true;
            break;
        }
        ShowSharedFilesFolderTest.assertTrue((String)"Shared files folder not found.", (boolean)found);
    }
}

