/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.session.actions.AutologinRequest;
import com.openexchange.ajax.session.actions.AutologinResponse;
import com.openexchange.ajax.session.actions.StoreRequest;
import com.openexchange.ajax.session.actions.StoreResponse;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.recipient.RecipientType;
import com.openexchange.share.recipient.ShareRecipient;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;

public class GuestAutologinTest
extends ShareTest {
    public GuestAutologinTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGuestAutologin() throws Exception {
        int module = GuestAutologinTest.randomModule();
        OCLGuestPermission guestPermission = GuestAutologinTest.randomGuestPermission(RecipientType.GUEST, module);
        ShareRecipient recipient = guestPermission.getRecipient();
        FolderObject folder = this.insertSharedFolder(EnumAPI.OX_NEW, module, this.getDefaultFolder(module), guestPermission);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        GuestAutologinTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        GuestAutologinTest.checkPermissions(guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(EnumAPI.OX_NEW, module, folder.getObjectID(), matchingPermission.getEntity());
        GuestAutologinTest.checkGuestPermission(guestPermission, guest);
        String shareURL = this.discoverShareURL(guest);
        String client = AJAXClient.class.getName();
        AJAXSession sharedSession = this.getSession();
        String oldSessionID = sharedSession.getId();
        try {
            this.getSession().setId(null);
            GuestClient guestClient = new GuestClient(sharedSession, shareURL, GuestAutologinTest.getUsername(recipient), GuestAutologinTest.getPassword(recipient), client, true, false);
            StoreRequest storeRequest = new StoreRequest(sharedSession.getId(), false);
            StoreResponse storeResponse = guestClient.execute(storeRequest);
            GuestAutologinTest.assertFalse((String)storeResponse.getErrorMessage(), (boolean)storeResponse.hasError());
            AutologinRequest autologin = new AutologinRequest(new AutologinRequest.AutologinParameters(GuestAutologinTest.randomUID(), client, "7.4.2"), false);
            AutologinResponse response = guestClient.execute(autologin);
            GuestAutologinTest.assertFalse((String)response.getErrorMessage(), (boolean)response.hasError());
            GuestAutologinTest.assertEquals((String)guestClient.getSession().getId(), (String)response.getSessionId());
            GuestAutologinTest.assertEquals((String)GuestAutologinTest.getUsername(recipient), (String)response.getUser());
        }
        finally {
            sharedSession.setId(oldSessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGuestAutologinWithoutStore() throws Exception {
        int module = GuestAutologinTest.randomModule();
        OCLGuestPermission guestPermission = GuestAutologinTest.randomGuestPermission(RecipientType.GUEST, module);
        ShareRecipient recipient = guestPermission.getRecipient();
        FolderObject folder = this.insertSharedFolder(EnumAPI.OX_NEW, module, this.getDefaultFolder(module), guestPermission);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        GuestAutologinTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        GuestAutologinTest.checkPermissions(guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(EnumAPI.OX_NEW, module, folder.getObjectID(), matchingPermission.getEntity());
        GuestAutologinTest.checkGuestPermission(guestPermission, guest);
        String shareURL = this.discoverShareURL(guest);
        String client = AJAXClient.class.getName();
        AJAXSession sharedSession = this.getSession();
        String oldSessionID = sharedSession.getId();
        try {
            this.getSession().setId(null);
            GuestClient guestClient = new GuestClient(sharedSession, shareURL, GuestAutologinTest.getUsername(recipient), GuestAutologinTest.getPassword(recipient), client, true, false);
            AutologinRequest autologin = new AutologinRequest(new AutologinRequest.AutologinParameters(GuestAutologinTest.randomUID(), client, "7.4.2"), false);
            AutologinResponse response = guestClient.execute(autologin);
            GuestAutologinTest.assertTrue((String)"Autologin worked without store request", (boolean)response.hasError());
            GuestAutologinTest.assertEquals((int)OXJSONExceptionCodes.INVALID_COOKIE.getNumber(), (int)response.getException().getCode());
        }
        finally {
            sharedSession.setId(oldSessionID);
            this.client = new AJAXClient(AJAXClient.User.User1);
        }
    }
}

