/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.contact.action.DeleteRequest;
import com.openexchange.ajax.contact.action.GetResponse;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.folder.actions.VisibleFoldersRequest;
import com.openexchange.ajax.folder.actions.VisibleFoldersResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.AbstractColumnsResponse;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.infostore.actions.AllInfostoreRequest;
import com.openexchange.ajax.infostore.actions.DeleteInfostoreRequest;
import com.openexchange.ajax.infostore.actions.DeleteInfostoreResponse;
import com.openexchange.ajax.infostore.actions.GetDocumentRequest;
import com.openexchange.ajax.infostore.actions.GetDocumentResponse;
import com.openexchange.ajax.infostore.actions.GetInfostoreRequest;
import com.openexchange.ajax.infostore.actions.GetInfostoreResponse;
import com.openexchange.ajax.infostore.actions.NewInfostoreRequest;
import com.openexchange.ajax.infostore.actions.NewInfostoreResponse;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreRequest;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreResponse;
import com.openexchange.ajax.session.actions.LoginRequest;
import com.openexchange.ajax.session.actions.LoginResponse;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ResolveShareRequest;
import com.openexchange.ajax.share.actions.ResolveShareResponse;
import com.openexchange.ajax.task.actions.AllRequest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageGuestObjectPermission;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.folderstorage.Permissions;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.modules.Module;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.util.TimeZones;
import com.openexchange.java.util.UUIDs;
import com.openexchange.share.recipient.ShareRecipient;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONObject;
import org.junit.Assert;

public class GuestClient
extends AJAXClient {
    private final ResolveShareResponse shareResponse;
    private final LoginResponse loginResponse;
    private final String module;
    private final String item;
    private final String folder;

    public GuestClient(String url, ShareRecipient recipient) throws Exception {
        this(url, recipient, false);
    }

    public GuestClient(String url, ShareRecipient recipient, boolean failOnNonRedirect) throws Exception {
        this(new AJAXSession(), url, ShareTest.getUsername(recipient), ShareTest.getPassword(recipient), failOnNonRedirect);
    }

    public GuestClient(AJAXSession ajaxSession, String url, ShareRecipient recipient, boolean failOnNonRedirect) throws Exception {
        this(ajaxSession, url, recipient, failOnNonRedirect, true);
    }

    public GuestClient(AJAXSession ajaxSession, String url, ShareRecipient recipient, boolean failOnNonRedirect, boolean mustLogout) throws Exception {
        this(ajaxSession, url, ShareTest.getUsername(recipient), ShareTest.getPassword(recipient), failOnNonRedirect, mustLogout);
    }

    public GuestClient(String url, String username, String password) throws Exception {
        this(url, username, password, false);
    }

    public GuestClient(String url, String username, String password, boolean failOnNonRedirect) throws Exception {
        this(new AJAXSession(), url, username, password, failOnNonRedirect);
    }

    public GuestClient(AJAXSession ajaxSession, String url, String username, String password, boolean failOnNonRedirect) throws Exception {
        this(ajaxSession, url, username, password, failOnNonRedirect, true);
    }

    public GuestClient(AJAXSession ajaxSession, String url, String username, String password, boolean failOnNonRedirect, boolean mustLogout) throws Exception {
        this(ajaxSession, url, username, password, null, failOnNonRedirect, mustLogout);
    }

    public GuestClient(AJAXSession ajaxSession, String url, String username, String password, String client, boolean failOnNonRedirect, boolean mustLogout) throws Exception {
        this(new ClientConfig(url).setAJAXSession(ajaxSession).setCredentials(username, password).setClient(client).setFailOnNonRedirect(failOnNonRedirect).setMustLogout(mustLogout));
    }

    public GuestClient(ClientConfig config) throws Exception {
        super(GuestClient.getOrCreateSession(config), config.mustLogout);
        GuestClient.prepareClient(this.getHttpClient(), config.username, config.password);
        this.setHostname(new URI(config.url).getHost());
        this.setProtocol(new URI(config.url).getScheme());
        this.shareResponse = Executor.execute(this, new ResolveShareRequest(config.url, config.failOnNonRedirect), this.getProtocol(), this.getHostname());
        if (null != this.shareResponse.getLoginType()) {
            this.loginResponse = this.login(this.shareResponse, config);
            this.getSession().setId(this.loginResponse.getSessionId());
            if (!this.loginResponse.hasError()) {
                JSONObject data = (JSONObject)this.loginResponse.getData();
                this.module = data.has("module") ? data.getString("module") : null;
                this.folder = data.has("folder") ? data.getString("folder") : null;
                this.item = data.has("item") ? data.getString("item") : null;
            } else {
                this.module = null;
                this.folder = null;
                this.item = null;
            }
        } else {
            this.loginResponse = null;
            this.getSession().setId(this.shareResponse.getSessionID());
            this.module = this.shareResponse.getModule();
            this.folder = this.shareResponse.getFolder();
            this.item = this.shareResponse.getItem();
            this.shareResponse.getSessionID();
        }
    }

    private static AJAXSession getOrCreateSession(ClientConfig config) {
        if (config.ajaxSession == null) {
            return new AJAXSession();
        }
        return config.ajaxSession;
    }

    private LoginResponse login(ResolveShareResponse shareResponse, ClientConfig config) throws Exception {
        LoginRequest loginRequest = null;
        if ("guest".equals(shareResponse.getLoginType()) || "guest_password".equals(shareResponse.getLoginType())) {
            LoginRequest.GuestCredentials credentials = new LoginRequest.GuestCredentials(config.username, config.password);
            loginRequest = LoginRequest.createGuestLoginRequest(shareResponse.getShare(), shareResponse.getTarget(), credentials, config.client, false);
        } else if ("anonymous_password".equals(shareResponse.getLoginType())) {
            loginRequest = LoginRequest.createAnonymousLoginRequest(shareResponse.getShare(), shareResponse.getTarget(), config.password, false);
        } else {
            Assert.fail((String)("unknown login type: " + shareResponse.getLoginType()));
        }
        return Executor.execute(this, loginRequest, this.getProtocol(), this.getHostname());
    }

    private static void prepareClient(DefaultHttpClient httpClient, String username, String password) {
        httpClient.getParams().setBooleanParameter("http.protocol.handle-redirects", false);
        if (null != password) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(null != username ? username : "guest", password);
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            httpClient.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
    }

    public ResolveShareResponse getShareResolveResponse() {
        return this.shareResponse;
    }

    public LoginResponse getLoginResponse() {
        return this.loginResponse;
    }

    public String getModule() {
        return this.module;
    }

    public int getModuleID() {
        return Module.getModuleInteger((String)this.getModule());
    }

    public String getFolder() {
        return this.folder;
    }

    public int getIntFolder() {
        return Integer.parseInt(this.getFolder());
    }

    public String getItem() {
        return this.item;
    }

    public void checkShareAccessible(FileStorageGuestObjectPermission permissions) throws Exception {
        this.checkFileAccessible(this.getFolder(), this.getItem(), permissions);
    }

    public void checkShareAccessible(FileStorageGuestObjectPermission permissions, byte[] expectedContents) throws Exception {
        this.checkFileAccessible(this.getFolder(), this.getItem(), permissions, expectedContents);
    }

    public void checkShareAccessible(OCLGuestPermission permissions) throws Exception {
        this.checkFolderAccessible(this.getFolder(), permissions);
    }

    public void checkFolderAccessible(String folderID, OCLGuestPermission permissions) throws Exception {
        com.openexchange.ajax.folder.actions.GetResponse getResponse = this.execute(new GetRequest((API)EnumAPI.OX_NEW, Integer.valueOf(folderID)));
        FolderObject folder = getResponse.getFolder();
        folder.setLastModified(getResponse.getTimestamp());
        String id = this.createItem(folder, false == permissions.canCreateObjects());
        if (null != id) {
            this.getItem(folder, id, false == permissions.canReadOwnObjects());
            this.deleteItem(folder, id, false == permissions.canDeleteAllObjects());
        }
        this.getAll(folder, false == permissions.canReadOwnObjects());
    }

    public void checkFileAccessible(String folderID, String fileID, FileStorageGuestObjectPermission permissions) throws Exception {
        this.checkFileAccessible(folderID, fileID, permissions, null);
    }

    public void checkFileAccessible(String folderID, String fileID, FileStorageGuestObjectPermission permissions, byte[] expectedContents) throws Exception {
        GetInfostoreRequest getInfostoreRequest = new GetInfostoreRequest(fileID);
        getInfostoreRequest.setFailOnError(permissions.canRead());
        GetInfostoreResponse getInfostoreResponse = this.execute(getInfostoreRequest);
        GuestClient.checkResponse(getInfostoreResponse, false == permissions.canRead());
        DefaultFile file = new DefaultFile(getInfostoreResponse.getDocumentMetadata());
        if (null != file.getFileName() && 0L < file.getFileSize()) {
            GetDocumentRequest getDocumentRequest = new GetDocumentRequest(folderID, fileID);
            getInfostoreRequest.setFailOnError(permissions.canRead());
            GetDocumentResponse getDocumentResponse = this.execute(getDocumentRequest);
            GuestClient.checkResponse(getDocumentResponse, false == permissions.canRead());
            byte[] contents = getDocumentResponse.getContentAsByteArray();
            if (!permissions.canRead()) {
                Assert.assertNull((String)"Contents wrong", (Object)contents);
            } else if (null == expectedContents) {
                Assert.assertNotNull((String)"Contents wrong", (Object)contents);
            } else {
                Assert.assertArrayEquals((String)"Contents wrong", (byte[])expectedContents, (byte[])contents);
            }
        }
        if (permissions.canRead()) {
            file.setFileName(file.getFileName() + "_edit");
            UpdateInfostoreRequest updateInfostoreRequest = new UpdateInfostoreRequest((File)file, new File.Field[]{File.Field.FILENAME}, file.getLastModified());
            updateInfostoreRequest.setFailOnError(permissions.canWrite());
            UpdateInfostoreResponse updateInfostoreResponse = this.execute(updateInfostoreRequest);
            GuestClient.checkResponse(updateInfostoreResponse, false == permissions.canWrite());
            file.setLastModified(updateInfostoreResponse.getTimestamp());
        }
    }

    public void checkFileNotAccessible(String fileID) throws Exception {
        GetInfostoreRequest getInfostoreRequest = new GetInfostoreRequest(fileID);
        getInfostoreRequest.setFailOnError(false);
        GetInfostoreResponse getInfostoreResponse = this.execute(getInfostoreRequest);
        GuestClient.checkResponse(getInfostoreResponse, true);
    }

    public void checkFileAccessible(String id, OCLGuestPermission permissions) throws Exception {
        FileID fileID = new FileID(id);
        fileID.setFolderId(Integer.toString(10));
        GetInfostoreRequest getFileRequest = new GetInfostoreRequest(fileID.toUniqueID());
        getFileRequest.setFailOnError(true);
        GetInfostoreResponse getFileResponse = this.execute(getFileRequest);
        File file = getFileResponse.getDocumentMetadata();
        List objectPermissions = file.getObjectPermissions();
        if (objectPermissions == null) {
            Assert.fail((String)("File contains no object permission for entity " + permissions.getEntity()));
        }
        FileStorageObjectPermission permissionForEntity = null;
        for (FileStorageObjectPermission p : objectPermissions) {
            if (p.getEntity() != permissions.getEntity() || p.isGroup() != permissions.isGroupPermission()) continue;
            permissionForEntity = p;
            break;
        }
        int expected = GuestClient.getObjectPermissionBits(permissions.getPermissionBits());
        if (permissionForEntity == null) {
            Assert.fail((String)("File contains no object permission for entity " + permissions.getEntity()));
        }
        Assert.assertEquals((String)"Wrong permission found", (long)expected, (long)permissionForEntity.getPermissions());
    }

    protected static int getObjectPermissionBits(int folderPermissionBits) {
        int objectBits = 0;
        int[] permissionBits = Permissions.parsePermissionBits((int)folderPermissionBits);
        int rp = permissionBits[1];
        int wp = permissionBits[2];
        int dp = permissionBits[3];
        if (dp >= 4) {
            objectBits = 4;
        } else if (wp >= 4) {
            objectBits = 2;
        } else if (rp >= 4) {
            objectBits = 1;
        }
        return objectBits;
    }

    public void checkFolderNotAccessible(String folderID) throws Exception {
        com.openexchange.ajax.folder.actions.GetResponse getResponse = this.execute(new GetRequest((API)EnumAPI.OX_NEW, (int)Integer.valueOf(folderID), false));
        Assert.assertTrue((String)"No errors in response", (boolean)getResponse.hasError());
        Assert.assertNull((String)"Folder in response", (Object)getResponse.getFolder());
    }

    public void checkModuleAvailable(int moduleID) throws Exception {
        Object[] array;
        com.openexchange.ajax.config.actions.GetResponse getResponse = this.execute(new com.openexchange.ajax.config.actions.GetRequest(Tree.AvailableModules));
        String module = this.getContentType(moduleID);
        for (Object object : array = getResponse.getArray()) {
            if (!module.equals(object)) continue;
            return;
        }
        Assert.fail((String)("Module " + this.getContentType(moduleID) + " not found"));
    }

    public void checkModuleNotAvailable(int moduleID) throws Exception {
        Object[] array;
        com.openexchange.ajax.config.actions.GetResponse getResponse = this.execute(new com.openexchange.ajax.config.actions.GetRequest(Tree.AvailableModules));
        String module = this.getContentType(moduleID);
        for (Object object : array = getResponse.getArray()) {
            Assert.assertNotEquals((String)("Module " + this.getContentType(moduleID) + " found"), (Object)object, (Object)module);
        }
    }

    public void checkShareModuleAvailable() throws Exception {
        this.checkModuleAvailable(this.getModuleID());
    }

    public void checkShareModuleAvailableExclusively() throws Exception {
        com.openexchange.ajax.config.actions.GetResponse getResponse = this.execute(new com.openexchange.ajax.config.actions.GetRequest(Tree.AvailableModules));
        Object[] array = getResponse.getArray();
        for (int moduleID : new int[]{2, 3, 8, 1}) {
            String module = this.getContentType(moduleID);
            boolean found = false;
            for (Object object : array) {
                if (!module.equals(object)) continue;
                found = true;
                break;
            }
            if (this.getModuleID() == moduleID) {
                Assert.assertTrue((String)("Module " + module + " not found"), (boolean)found);
                continue;
            }
            Assert.assertFalse((String)("Module " + module + " was found"), (boolean)found);
        }
    }

    private String getContentType(int module) {
        switch (module) {
            case 3: {
                return "contacts";
            }
            case 8: {
                return "infostore";
            }
            case 1: {
                return "tasks";
            }
            case 2: {
                return "calendar";
            }
        }
        Assert.fail((String)("no content type for " + this.getModule() + ""));
        return null;
    }

    public void checkSessionAlive(boolean expectToFail) throws Exception {
        com.openexchange.ajax.user.actions.GetResponse getResponse = this.execute(new com.openexchange.ajax.user.actions.GetRequest(TimeZones.UTC, false == expectToFail));
        GuestClient.checkResponse(getResponse, expectToFail);
        if (8 != this.getModuleID()) {
            String contentType = this.getContentType(this.getModuleID());
            VisibleFoldersResponse response = this.execute(new VisibleFoldersRequest(EnumAPI.OX_NEW, contentType, FolderObject.ALL_COLUMNS, false == expectToFail));
            GuestClient.checkResponse(response, expectToFail);
        }
    }

    private static void checkResponse(AbstractAJAXResponse response, boolean expectToFail) {
        Assert.assertNotNull((String)"No response", (Object)((Object)response));
        if (expectToFail) {
            if (!response.hasError()) {
                System.out.println("+++");
            }
            Assert.assertTrue((String)"No errors in response", (boolean)response.hasError());
        } else {
            Assert.assertFalse((String)"Errors in response", (boolean)response.hasError());
        }
    }

    private void deleteItem(FolderObject folder, String id, boolean expectToFail) throws Exception {
        int folderID = folder.getObjectID();
        Date timestamp = GuestClient.getFutureTimestamp();
        boolean failOnError = false == expectToFail;
        switch (folder.getModule()) {
            case 3: {
                CommonDeleteResponse deleteContactResponse = this.execute(new DeleteRequest(folderID, Integer.parseInt(id), timestamp, failOnError));
                GuestClient.checkResponse(deleteContactResponse, expectToFail);
                break;
            }
            case 8: {
                DeleteInfostoreRequest deleteInfostoreRequest = new DeleteInfostoreRequest(id, String.valueOf(folderID), timestamp);
                deleteInfostoreRequest.setFailOnError(failOnError);
                DeleteInfostoreResponse deleteInfostoreResponse = this.execute(deleteInfostoreRequest);
                GuestClient.checkResponse(deleteInfostoreResponse, expectToFail);
                break;
            }
            case 1: {
                CommonDeleteResponse deleteTaskResponse = this.execute(new com.openexchange.ajax.task.actions.DeleteRequest(folderID, Integer.parseInt(id), timestamp, failOnError));
                GuestClient.checkResponse(deleteTaskResponse, expectToFail);
                break;
            }
            case 2: {
                CommonDeleteResponse deleteAppointmentResponse = this.execute(new com.openexchange.ajax.appointment.action.DeleteRequest(Integer.parseInt(id), folderID, timestamp, failOnError));
                GuestClient.checkResponse(deleteAppointmentResponse, expectToFail);
                break;
            }
            default: {
                Assert.fail((String)("no delete item request for " + folder.getModule() + " implemented"));
            }
        }
    }

    public Object getItem(FolderObject folder, String id, boolean expectToFail) throws Exception {
        int folderID = folder.getObjectID();
        boolean failOnError = false == expectToFail;
        TimeZone timeZone = TimeZones.UTC;
        switch (folder.getModule()) {
            case 3: {
                GetResponse contactGetResponse = this.execute(new com.openexchange.ajax.contact.action.GetRequest(folderID, Integer.parseInt(id), timeZone, failOnError));
                GuestClient.checkResponse(contactGetResponse, expectToFail);
                return expectToFail ? null : contactGetResponse.getContact();
            }
            case 8: {
                GetInfostoreRequest getInfostoreRequest = new GetInfostoreRequest(id);
                getInfostoreRequest.setFailOnError(false == expectToFail);
                GetInfostoreResponse getInfostoreResponse = this.execute(getInfostoreRequest);
                GuestClient.checkResponse(getInfostoreResponse, expectToFail);
                return expectToFail ? null : getInfostoreResponse.getDocumentMetadata();
            }
            case 1: {
                com.openexchange.ajax.task.actions.GetResponse getTaskResponse = this.execute(new com.openexchange.ajax.task.actions.GetRequest(folderID, Integer.parseInt(id), failOnError));
                GuestClient.checkResponse(getTaskResponse, expectToFail);
                return expectToFail ? null : getTaskResponse.getTask(timeZone);
            }
            case 2: {
                com.openexchange.ajax.appointment.action.GetResponse getAppointmentResponse = this.execute(new com.openexchange.ajax.appointment.action.GetRequest(folderID, Integer.parseInt(id), failOnError));
                GuestClient.checkResponse(getAppointmentResponse, expectToFail);
                return expectToFail ? null : getAppointmentResponse.getAppointment(timeZone);
            }
        }
        Assert.fail((String)("no get item request for " + folder.getModule() + " implemented"));
        return null;
    }

    private String createItem(FolderObject folder, boolean expectToFail) throws Exception {
        boolean failOnError = false == expectToFail;
        int folderID = folder.getObjectID();
        TimeZone timeZone = TimeZones.UTC;
        switch (folder.getModule()) {
            case 3: {
                Contact contact = new Contact();
                contact.setParentFolderID(folderID);
                contact.setDisplayName(UUIDs.getUnformattedString((UUID)UUID.randomUUID()));
                com.openexchange.ajax.contact.action.InsertResponse insertContactResponse = this.execute(new com.openexchange.ajax.contact.action.InsertRequest(contact, failOnError));
                GuestClient.checkResponse(insertContactResponse, expectToFail);
                return expectToFail ? null : String.valueOf(insertContactResponse.getId());
            }
            case 8: {
                byte[] data = UUIDs.toByteArray((UUID)UUID.randomUUID());
                DefaultFile metadata = new DefaultFile();
                metadata.setFolderId(String.valueOf(folderID));
                metadata.setFileName(UUIDs.getUnformattedString((UUID)UUID.randomUUID()) + ".test");
                NewInfostoreRequest newRequest = new NewInfostoreRequest((File)metadata, new ByteArrayInputStream(data));
                newRequest.setFailOnError(false == expectToFail);
                NewInfostoreResponse newResponse = this.execute(newRequest);
                GuestClient.checkResponse(newResponse, expectToFail);
                return expectToFail ? null : String.valueOf(newResponse.getID());
            }
            case 1: {
                Task task = new Task();
                task.setParentFolderID(folderID);
                task.setTitle(UUIDs.getUnformattedString((UUID)UUID.randomUUID()));
                InsertResponse insertTaskResponse = this.execute(new InsertRequest(task, timeZone, failOnError));
                GuestClient.checkResponse(insertTaskResponse, expectToFail);
                return expectToFail ? null : String.valueOf(insertTaskResponse.getId());
            }
            case 2: {
                Appointment appointment = new Appointment();
                appointment.setParentFolderID(folderID);
                appointment.setTitle(UUIDs.getUnformattedString((UUID)UUID.randomUUID()));
                appointment.setStartDate(new Date());
                appointment.setEndDate(new Date(appointment.getStartDate().getTime() + 3600000L));
                appointment.setIgnoreConflicts(true);
                AppointmentInsertResponse insertAppointmentResponse = this.execute(new com.openexchange.ajax.appointment.action.InsertRequest(appointment, timeZone, failOnError));
                GuestClient.checkResponse(insertAppointmentResponse, expectToFail);
                return expectToFail ? null : String.valueOf(insertAppointmentResponse.getId());
            }
        }
        Assert.fail((String)("no create item request for " + folder.getModule() + " implemented"));
        return null;
    }

    private AbstractColumnsResponse getAll(FolderObject folder, boolean expectToFail) throws Exception {
        int folderID = folder.getObjectID();
        switch (folder.getModule()) {
            case 3: {
                CommonAllResponse allContactResponse = this.execute(new com.openexchange.ajax.contact.action.AllRequest(folderID, Contact.ALL_COLUMNS));
                GuestClient.checkResponse(allContactResponse, expectToFail);
                return allContactResponse;
            }
            case 8: {
                int[] columns = new int[]{1, 700, 706, 701, 20};
                AbstractColumnsResponse allInfostoreResponse = this.execute(new AllInfostoreRequest(folderID, columns, 1, Order.ASCENDING));
                GuestClient.checkResponse(allInfostoreResponse, expectToFail);
                return allInfostoreResponse;
            }
            case 1: {
                CommonAllResponse allTaskResponse = this.execute(new AllRequest(folderID, Task.ALL_COLUMNS, 1, Order.ASCENDING));
                GuestClient.checkResponse(allTaskResponse, expectToFail);
                return allTaskResponse;
            }
            case 2: {
                Date start = new Date(System.currentTimeMillis() - 100000000L);
                Date end = new Date(System.currentTimeMillis() + 100000000L);
                CommonAllResponse allCalendarResponse = this.execute(new com.openexchange.ajax.appointment.action.AllRequest(folderID, CalendarDataObject.ALL_COLUMNS, start, end, TimeZones.UTC));
                GuestClient.checkResponse(allCalendarResponse, expectToFail);
                return allCalendarResponse;
            }
        }
        Assert.fail((String)("no all request for " + folder.getModule() + " implemented"));
        return null;
    }

    private DefaultHttpClient getHttpClient() {
        return this.getSession().getHttpClient();
    }

    private static Date getFutureTimestamp() {
        return new Date(System.currentTimeMillis() + 1000000L);
    }

    public static final class ClientConfig {
        private final String url;
        private String username;
        private String password;
        private boolean failOnNonRedirect;
        private boolean mustLogout;
        private String client;
        private AJAXSession ajaxSession;

        public ClientConfig(String url) {
            this.url = url;
        }

        public ClientConfig setCredentials(ShareRecipient recipient) {
            this.username = ShareTest.getUsername(recipient);
            this.password = ShareTest.getPassword(recipient);
            return this;
        }

        public ClientConfig setCredentials(String username, String password) {
            this.username = username;
            this.password = password;
            return this;
        }

        public ClientConfig setUsername(String username) {
            this.username = username;
            return this;
        }

        public ClientConfig setPassword(String password) {
            this.password = password;
            return this;
        }

        public ClientConfig setFailOnNonRedirect(boolean failOnNonRedirect) {
            this.failOnNonRedirect = failOnNonRedirect;
            return this;
        }

        public ClientConfig setMustLogout(boolean mustLogout) {
            this.mustLogout = mustLogout;
            return this;
        }

        public ClientConfig setAJAXSession(AJAXSession ajaxSession) {
            this.ajaxSession = ajaxSession;
            return this;
        }

        public ClientConfig setClient(String client) {
            this.client = client;
            return this;
        }
    }
}

