/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth.provider.protocol;

import com.openexchange.html.internal.parser.HtmlHandler;
import com.openexchange.html.internal.parser.HtmlParser;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.junit.Assert;

public class HttpTools {
    public static Map<String, String> extractQueryParams(URI uri) throws UnsupportedEncodingException {
        String[] redirectParamPairs;
        HashMap<String, String> params = new HashMap<String, String>();
        for (String pair : redirectParamPairs = URLDecoder.decode(uri.getRawQuery(), "UTF-8").split("&")) {
            String[] split = pair.split("=");
            params.put(split[0], split[1]);
        }
        return params;
    }

    public static URI getRedirectLocation(HttpResponse response) throws URISyntaxException {
        Header header = response.getFirstHeader("Location");
        Assert.assertNotNull((String)"No location header present in response", (Object)header);
        return new URI(header.getValue());
    }

    public static Map<String, String> getHiddenFormFields(String form) {
        final HashMap<String, String> params = new HashMap<String, String>();
        HtmlParser.parse((String)form, (HtmlHandler)new HtmlHandler(){

            public void handleXMLDeclaration(String version, Boolean standalone, String encoding) {
            }

            public void handleText(String text, boolean ignorable) {
            }

            public void handleStartTag(String tag, Map<String, String> attributes) {
                this.handleTag(tag, attributes);
            }

            public void handleSimpleTag(String tag, Map<String, String> attributes) {
                this.handleTag(tag, attributes);
            }

            private void handleTag(String tag, Map<String, String> attributes) {
                if ("input".equals(tag) && "hidden".equals(attributes.get("type"))) {
                    String name = attributes.get("name");
                    String value = attributes.get("value");
                    if (name != null && value != null) {
                        params.put(name, value);
                    }
                }
            }

            public void handleError(String errorMsg) {
            }

            public void handleEndTag(String tag) {
            }

            public void handleDocDeclaration(String docDecl) {
            }

            public void handleComment(String comment) {
            }

            public void handleCDATA(String text) {
            }
        });
        return params;
    }
}

