/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth.provider;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.oauth.provider.protocol.Grant;
import com.openexchange.ajax.oauth.provider.protocol.OAuthParams;
import com.openexchange.ajax.oauth.provider.protocol.Protocol;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.java.util.UUIDs;
import com.openexchange.oauth.provider.resourceserver.scope.Scope;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.junit.Assert;

public class OAuthSession
extends AJAXSession {
    private final String clientId;
    private final String clientSecret;
    private final String redirectURI;
    private final Scope scope;
    private Grant grant;

    public OAuthSession(AJAXClient.User user, String clientId, String clientSecret, String redirectURI, Scope scope) {
        super(OAuthSession.newWebConversation(), OAuthSession.newOAuthHttpClient(), null);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectURI = redirectURI;
        this.scope = scope;
        try {
            AJAXConfig.init();
            this.obtainAccess(user, (HttpClient)this.getHttpClient());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static DefaultHttpClient newOAuthHttpClient() {
        DefaultHttpClient client = OAuthSession.newHttpClient();
        try {
            SSLSocketFactory ssf = new SSLSocketFactory((TrustStrategy)new TrustSelfSignedStrategy(), (X509HostnameVerifier)new AllowAllHostnameVerifier());
            client.getConnectionManager().getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)ssf));
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            Assert.fail((String)e.getMessage());
        }
        HttpParams params = client.getParams();
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)false);
        HttpClientParams.setAuthenticating((HttpParams)params, (boolean)false);
        return client;
    }

    private void obtainAccess(AJAXClient.User user, HttpClient client) throws Exception {
        String hostname = AJAXConfig.getProperty(AJAXConfig.Property.HOSTNAME);
        String login = AJAXConfig.getProperty(user.getLogin()) + "@" + AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME);
        String password = AJAXConfig.getProperty(user.getPassword());
        String state = UUIDs.getUnformattedStringFromRandom();
        OAuthParams params = new OAuthParams().setHostname(hostname).setClientId(this.clientId).setClientSecret(this.clientSecret).setRedirectURI(this.redirectURI).setScope(this.scope.toString()).setState(state);
        this.grant = Protocol.obtainAccess(client, params, login, password);
    }

    public String getAccessToken() {
        return this.grant.getAccessToken();
    }

    public String getRefreshToken() {
        return this.grant.getRefreshToken();
    }
}

