/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.categories;

import com.openexchange.ajax.mail.MailTestManager;
import com.openexchange.ajax.mail.TestMail;
import com.openexchange.ajax.mail.actions.NewMailRequest;
import com.openexchange.ajax.mail.categories.AbstractMailCategoriesTest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.search.Order;
import com.openexchange.mail.dataobjects.MailMessage;
import java.io.IOException;
import org.json.JSONException;

public class AllRequestCategoryParameterTest
extends AbstractMailCategoriesTest {
    private static final int[] COLUMNS = new int[]{102, 600, 601, 602, 603, 604, 605, 606, 607, 608, 610, 611, 614, 652};

    public AllRequestCategoryParameterTest(String name) throws OXException, IOException, JSONException {
        super(name);
    }

    public void testAllRequest() throws Exception {
        MailTestManager manager = new MailTestManager(this.client, false);
        this.getClient().execute(new NewMailRequest(this.getInboxFolder(), this.EML, -1, true));
        String origin = this.values.getInboxFolder();
        MailMessage[] messages = manager.listMails(origin, COLUMNS, 610, Order.DESCENDING, true, "general");
        AllRequestCategoryParameterTest.assertTrue((String)"General category should contain the old mail.", (messages.length == 1 ? 1 : 0) != 0);
        messages = manager.listMails(origin, COLUMNS, 610, Order.DESCENDING, true, "social");
        AllRequestCategoryParameterTest.assertTrue((String)"Category 1 should contain no email.", (messages.length == 0 ? 1 : 0) != 0);
        TestMail mail = new TestMail(this.getFirstMailInFolder(origin));
        manager.moveToCategory(mail, "social");
        messages = manager.listMails(origin, COLUMNS, 610, Order.DESCENDING, true, "general");
        AllRequestCategoryParameterTest.assertTrue((String)"General category shouldn't contain the mail any more.", (messages.length == 0 ? 1 : 0) != 0);
        messages = manager.listMails(origin, COLUMNS, 610, Order.DESCENDING, true, "social");
        AllRequestCategoryParameterTest.assertTrue((String)"Category 1 should contain the mail now.", (messages.length == 1 ? 1 : 0) != 0);
    }
}

