/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.mail.actions.AbstractMailCategoriesRequest;
import com.openexchange.ajax.mail.actions.TrainResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TrainRequest
extends AbstractMailCategoriesRequest<TrainResponse> {
    private static final String ACTION_TRAIN = "train";
    private static final String PARAMETER_CATEGORY_ID = "category_id";
    private static final String PARAMETER_APPLY_FOR_FUTURE = "apply-for-future-ones";
    private static final String PARAMETER_APPLY_FOR_EXISTING = "apply-for-existing";
    private String categoryId;
    private boolean future = true;
    private boolean past = false;
    private List<String> mails = new ArrayList<String>();

    public TrainRequest(String categoryId, boolean applyToFutureOnes, boolean applyToExistingOnes) {
        this.future = applyToFutureOnes;
        this.past = applyToExistingOnes;
        this.categoryId = categoryId;
    }

    public TrainRequest(String categoryId) {
        this.categoryId = categoryId;
    }

    public void addAddress(String emailAddress) {
        this.mails.add(emailAddress);
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        LinkedList<AJAXRequest.Parameter> list = new LinkedList<AJAXRequest.Parameter>();
        list.add(new AJAXRequest.Parameter("action", ACTION_TRAIN));
        list.add(new AJAXRequest.Parameter(PARAMETER_CATEGORY_ID, this.categoryId));
        list.add(new AJAXRequest.Parameter(PARAMETER_APPLY_FOR_FUTURE, this.future));
        list.add(new AJAXRequest.Parameter(PARAMETER_APPLY_FOR_EXISTING, this.past));
        return list.toArray(new AJAXRequest.Parameter[list.size()]);
    }

    @Override
    public AbstractAJAXParser<? extends TrainResponse> getParser() {
        return new AbstractAJAXParser<TrainResponse>(true){

            @Override
            protected TrainResponse createResponse(Response response) {
                return new TrainResponse(response);
            }
        };
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        JSONObject obj = new JSONObject(1);
        JSONArray array = new JSONArray(this.mails);
        obj.put("from", (Object)array);
        return obj;
    }
}

