/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import java.util.HashSet;
import java.util.Set;

public enum MailFlag {
    ANSWERED(1, "answered"),
    DELETED(2, "deleted"),
    DRAFT(4, "draft"),
    FLAGGED(8, "flagged"),
    RECENT(16, "recent"),
    SEEN(32, "seen"),
    USER(64, "user"),
    SPAM(128, "spam"),
    FORWARDED(256, "forwarded"),
    READ_ACK(512, "read_ack");

    private int value;
    private String name;

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    private MailFlag(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public boolean isContainedIn(int bitmask) {
        return (bitmask & this.value) > 0;
    }

    public static MailFlag getByValue(int value) {
        MailFlag[] values;
        for (MailFlag temp : values = MailFlag.values()) {
            if (temp.value != value) continue;
            return temp;
        }
        return null;
    }

    public static MailFlag getByName(String searched) {
        MailFlag[] values;
        for (MailFlag temp : values = MailFlag.values()) {
            if (!searched.trim().equalsIgnoreCase(temp.name)) continue;
            return temp;
        }
        return null;
    }

    public static Set<MailFlag> transform(int bitmask) {
        HashSet<MailFlag> set = new HashSet<MailFlag>();
        for (int i = 1; i <= bitmask; i <<= 1) {
            if ((i & bitmask) <= 0 || MailFlag.getByValue(i) == null) continue;
            set.add(MailFlag.getByValue(i));
        }
        return set;
    }
}

