/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.AutosaveRequest;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import com.openexchange.ajax.mail.actions.MailReferenceResponse;
import com.openexchange.ajax.mail.actions.NewMailRequestWithUploads;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import org.json.JSONObject;

public class Bug34254Test
extends AbstractMailTest {
    public Bug34254Test(String name) {
        super(name);
    }

    public void testDeleteNormalDraft() throws Exception {
        String subject = "Bug34254Test_testDeleteNormalDraft_" + System.currentTimeMillis();
        JSONObject composedMail = this.createEMail(this.getSendAddress(), subject, "text/html", "Mail text.<br /><br />People have been asking for support for the IMAP IDLE command for quite<br />a few years and I think I've finally figured out how to provide such<br />support safely.  The difficulty isn't in executing the command, which<br />is quite straightforward, the difficulty is in deciding how to expose<br />it to applications, and inhandling the multithreading issues that<br />arise.<br /><br />After three attempts, I've got a version that seems to work.  It passes<br />all my tests, including a multithreading test I wrote just for this<br />purpose.  So now it's time for others to try it out as well.  Below is<br />my writeup on how to use the IDLE command.  You can find the test<br />version of JavaMail (essentially an early version of JavaMail 1.4.1)<br />in the java.net Maven repository (you want the 1.4.1ea version):<br /><br />https://maven-repository.dev.java.net/nonav/repository/javax.mail/<br /><br />Note that this version is built with JDK 1.5 and thus requires JDK 1.5.<br /><br />Oh,and here's the entire list of what's fixed in this version so far:<br /><br />4107594 IMAP implementation should use the IDLE extension if available<br />6423701 Problem with using OrTerm when the protocol is IMAP<br />6431207 SMTP is adding extra CRLF to message content<br />6447295 IMAPMessage fails to return Content-Language from bodystructure<br />6447799 encoded text not decoded even when mail.mime.decodetext.strict is false<br />6447801 MimeBodyPart.writeTo reencodes data unnecessarily<br />6456422 NullPointerException in smtptransport when sending MimeMessages<br />        with no encoding<br />6456444 MimeMessages created from stream are not correctly handled<br />        with allow8bitmime<br />&lt;no id&gt; fix performance bug in base64 encoder; now even faster!");
        JSONObject mail = new JSONObject(composedMail);
        mail.put("flags", 4);
        NewMailRequestWithUploads newDraftRequest = new NewMailRequestWithUploads(mail);
        MailReferenceResponse newDraftResponse = this.client.execute(newDraftRequest);
        String draftReference = newDraftResponse.getMailReference();
        String draftFolder = newDraftResponse.getFolder();
        String draftMailID = newDraftResponse.getMailID();
        Bug34254Test.assertEquals((String)"Draft saved in wrong folder", (String)this.client.getValues().getDraftsFolder(), (String)draftFolder);
        GetRequest getRequest = new GetRequest(draftFolder, draftMailID, GetRequest.View.HTML);
        GetResponse getResponse = this.client.execute(getRequest);
        MailMessage reloaded = getResponse.getMail(this.getTimeZone());
        Bug34254Test.assertEquals((String)"Wrong mail reference", (String)subject, (String)reloaded.getSubject());
        mail = new JSONObject(composedMail);
        mail.put("msgref", (Object)draftReference);
        mail.put("sendtype", ComposeType.DRAFT_DELETE_ON_TRANSPORT.getType());
        NewMailRequestWithUploads sendDraftRequest = new NewMailRequestWithUploads(mail);
        MailReferenceResponse sendDraftResponse = this.client.execute(sendDraftRequest);
        Bug34254Test.assertEquals((String)"Mail not stored in sent folder", (String)this.client.getValues().getSentFolder(), (String)sendDraftResponse.getFolder());
        getRequest = new GetRequest(draftFolder, draftMailID, false);
        getResponse = this.client.execute(getRequest);
        Bug34254Test.assertNull((String)"Draft was not deleted", (Object)getResponse.getData());
    }

    public void testDeleteAutoDraft() throws Exception {
        String subject = "Bug34254Test_testDeleteAutoDraft_" + System.currentTimeMillis();
        JSONObject composedMail = this.createEMail(this.getSendAddress(), subject, "text/html", "Mail text.<br /><br />People have been asking for support for the IMAP IDLE command for quite<br />a few years and I think I've finally figured out how to provide such<br />support safely.  The difficulty isn't in executing the command, which<br />is quite straightforward, the difficulty is in deciding how to expose<br />it to applications, and inhandling the multithreading issues that<br />arise.<br /><br />After three attempts, I've got a version that seems to work.  It passes<br />all my tests, including a multithreading test I wrote just for this<br />purpose.  So now it's time for others to try it out as well.  Below is<br />my writeup on how to use the IDLE command.  You can find the test<br />version of JavaMail (essentially an early version of JavaMail 1.4.1)<br />in the java.net Maven repository (you want the 1.4.1ea version):<br /><br />https://maven-repository.dev.java.net/nonav/repository/javax.mail/<br /><br />Note that this version is built with JDK 1.5 and thus requires JDK 1.5.<br /><br />Oh,and here's the entire list of what's fixed in this version so far:<br /><br />4107594 IMAP implementation should use the IDLE extension if available<br />6423701 Problem with using OrTerm when the protocol is IMAP<br />6431207 SMTP is adding extra CRLF to message content<br />6447295 IMAPMessage fails to return Content-Language from bodystructure<br />6447799 encoded text not decoded even when mail.mime.decodetext.strict is false<br />6447801 MimeBodyPart.writeTo reencodes data unnecessarily<br />6456422 NullPointerException in smtptransport when sending MimeMessages<br />        with no encoding<br />6456444 MimeMessages created from stream are not correctly handled<br />        with allow8bitmime<br />&lt;no id&gt; fix performance bug in base64 encoder; now even faster!");
        JSONObject mail = new JSONObject(composedMail);
        AutosaveRequest autosaveRequest = new AutosaveRequest(mail);
        MailReferenceResponse autosaveResponse = this.client.execute(autosaveRequest);
        String draftReference = autosaveResponse.getMailReference();
        String draftFolder = autosaveResponse.getFolder();
        String draftMailID = autosaveResponse.getMailID();
        Bug34254Test.assertEquals((String)"Draft saved in wrong folder", (String)this.client.getValues().getDraftsFolder(), (String)draftFolder);
        GetRequest getRequest = new GetRequest(draftFolder, draftMailID, GetRequest.View.HTML);
        GetResponse getResponse = this.client.execute(getRequest);
        MailMessage reloaded = getResponse.getMail(this.getTimeZone());
        Bug34254Test.assertEquals((String)"Wrong mail reference", (String)subject, (String)reloaded.getSubject());
        mail = new JSONObject(composedMail);
        mail.put("msgref", (Object)draftReference);
        mail.put("sendtype", ComposeType.DRAFT_DELETE_ON_TRANSPORT.getType());
        NewMailRequestWithUploads sendDraftRequest = new NewMailRequestWithUploads(mail);
        MailReferenceResponse sendDraftResponse = this.client.execute(sendDraftRequest);
        Bug34254Test.assertEquals((String)"Mail not stored in sent folder", (String)this.client.getValues().getSentFolder(), (String)sendDraftResponse.getFolder());
        getRequest = new GetRequest(draftFolder, draftMailID, false);
        getResponse = this.client.execute(getRequest);
        Bug34254Test.assertNull((String)"Draft was not deleted", (Object)getResponse.getData());
    }
}

