/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.test;

import com.openexchange.ajax.framework.AbstractColumnsResponse;
import com.openexchange.ajax.infostore.actions.AllInfostoreRequest;
import com.openexchange.ajax.infostore.test.AbstractInfostoreTest;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Streams;
import com.openexchange.java.util.UUIDs;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.junit.Test;

public final class Bug27722Test
extends AbstractInfostoreTest {
    private static final int TOTAL_ITEMS = 100;
    private static final int DELETED_ITEMS = 50;
    private FolderObject testFolder;
    private List<com.openexchange.file.storage.File> items;

    public Bug27722Test(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.testFolder = this.fMgr.generatePrivateFolder(UUID.randomUUID().toString(), 8, this.client.getValues().getPrivateInfostoreFolder(), this.client.getValues().getUserId());
        this.testFolder = this.fMgr.insertFolderOnServer(this.testFolder);
        this.items = new ArrayList<com.openexchange.file.storage.File>(100);
        for (int i = 0; i < 100; ++i) {
            File tempFile = null;
            try {
                FileOutputStream outputStream = null;
                try {
                    tempFile = File.createTempFile("file_" + i, ".tst");
                    tempFile.deleteOnExit();
                    outputStream = new FileOutputStream(tempFile);
                    outputStream.write(UUIDs.toByteArray((UUID)UUID.randomUUID()));
                    outputStream.flush();
                }
                catch (Throwable throwable) {
                    Streams.close(outputStream);
                    throw throwable;
                }
                Streams.close((Closeable)outputStream);
                DefaultFile document = new DefaultFile();
                document.setFolderId(String.valueOf(this.testFolder.getObjectID()));
                document.setTitle(tempFile.getName());
                document.setFileName(tempFile.getName());
                document.setVersion(String.valueOf(1));
                document.setFileSize(tempFile.length());
                this.infoMgr.newAction((com.openexchange.file.storage.File)document, tempFile);
                this.items.add((com.openexchange.file.storage.File)document);
                continue;
            }
            finally {
                if (null != tempFile) {
                    tempFile.delete();
                }
            }
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testDeleteManyFiles() throws Exception {
        ArrayList<String> objectIDs = new ArrayList<String>(50);
        ArrayList<String> folderIDs = new ArrayList<String>(50);
        Random random = new Random();
        while (objectIDs.size() < 50) {
            com.openexchange.file.storage.File randomDocument = this.items.get(random.nextInt(100));
            String objectID = randomDocument.getId();
            if (objectIDs.contains(objectID)) continue;
            objectIDs.add(objectID);
            folderIDs.add(randomDocument.getFolderId());
        }
        this.infoMgr.deleteAction(objectIDs, folderIDs, this.infoMgr.getLastResponse().getTimestamp());
        long duration = this.infoMgr.getLastResponse().getRequestDuration();
        Bug27722Test.assertTrue((String)("deletion took " + duration + "ms, which is too long"), (500L > duration ? 1 : 0) != 0);
        int[] columns = new int[]{1};
        AllInfostoreRequest allRequest = new AllInfostoreRequest(this.testFolder.getObjectID(), columns, -1, null);
        AbstractColumnsResponse allResponse = this.getClient().execute(allRequest);
        Bug27722Test.assertEquals((String)"Unexpected object count", (int)50, (int)allResponse.getArray().length);
        for (Object[] object : allResponse) {
            String objectID = object[0].toString();
            Bug27722Test.assertFalse((String)"Object not deleted", (boolean)objectIDs.contains(objectID));
        }
    }

    @Test
    public void testHardDeleteManyFiles() throws Exception {
        ArrayList<String> objectIDs = new ArrayList<String>(50);
        ArrayList<String> folderIDs = new ArrayList<String>(50);
        Random random = new Random();
        while (objectIDs.size() < 50) {
            com.openexchange.file.storage.File randomDocument = this.items.get(random.nextInt(100));
            String objectID = randomDocument.getId();
            if (objectIDs.contains(objectID)) continue;
            objectIDs.add(objectID);
            folderIDs.add(randomDocument.getFolderId());
        }
        this.infoMgr.deleteAction(objectIDs, folderIDs, this.infoMgr.getLastResponse().getTimestamp(), Boolean.TRUE);
        long duration = this.infoMgr.getLastResponse().getRequestDuration();
        Bug27722Test.assertTrue((String)("hard deletion took " + duration + "ms, which is too long"), (2500L > duration ? 1 : 0) != 0);
        int[] columns = new int[]{1};
        AllInfostoreRequest allRequest = new AllInfostoreRequest(this.testFolder.getObjectID(), columns, -1, null);
        AbstractColumnsResponse allResponse = this.getClient().execute(allRequest);
        Bug27722Test.assertEquals((String)"Unexpected object count", (int)50, (int)allResponse.getArray().length);
        for (Object[] object : allResponse) {
            String objectID = object[0].toString();
            Bug27722Test.assertFalse((String)"Object not deleted", (boolean)objectIDs.contains(objectID));
        }
    }
}

